/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jasig.portal.events.aggr.AggregatedGroupConfig;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.session.EventSession;
import org.joda.time.DateTime;

class FilteredEventSession
implements EventSession {
    private static final long serialVersionUID = 1L;
    private final EventSession parent;
    private final AggregatedGroupConfig aggregatedGroupConfig;
    private final Set<AggregatedGroupMapping> filteredGroupMappings;

    FilteredEventSession(EventSession parent, AggregatedGroupConfig aggregatedGroupConfig) {
        this.parent = parent;
        this.aggregatedGroupConfig = aggregatedGroupConfig;
        ImmutableSet.Builder filteredGroupMappingsBuilder = ImmutableSet.builder();
        for (AggregatedGroupMapping aggregatedGroupMapping : parent.getGroupMappings()) {
            if (!this.aggregatedGroupConfig.isIncluded((Object)aggregatedGroupMapping)) continue;
            filteredGroupMappingsBuilder.add((Object)aggregatedGroupMapping);
        }
        this.filteredGroupMappings = filteredGroupMappingsBuilder.build();
    }

    public void recordAccess(DateTime eventDate) {
        this.parent.recordAccess(eventDate);
    }

    public String getEventSessionId() {
        return this.parent.getEventSessionId();
    }

    public Set<AggregatedGroupMapping> getGroupMappings() {
        return this.filteredGroupMappings;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aggregatedGroupConfig == null ? 0 : this.aggregatedGroupConfig.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilteredEventSession other = (FilteredEventSession)obj;
        if (this.aggregatedGroupConfig == null ? other.aggregatedGroupConfig != null : !this.aggregatedGroupConfig.equals(other.aggregatedGroupConfig)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    public String toString() {
        return this.parent.toString();
    }
}

