/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import java.util.List;
import org.jasig.portal.concurrency.locking.IClusterLockService;
import org.jasig.portal.events.aggr.AcademicTermDetail;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.AggregationIntervalHelper;
import org.jasig.portal.events.aggr.AggregationIntervalInfo;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.EventDateTimeUtils;
import org.jasig.portal.events.aggr.PortalEventDimensionPopulator;
import org.jasig.portal.events.aggr.QuarterDetail;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.dao.DateDimensionDao;
import org.jasig.portal.events.aggr.dao.IEventAggregationManagementDao;
import org.jasig.portal.events.aggr.dao.TimeDimensionDao;
import org.jasig.portal.events.handlers.db.IPortalEventDao;
import org.jasig.portal.jpa.BaseAggrEventsJpaDao;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PortalEventDimensionPopulatorImpl
extends BaseAggrEventsJpaDao
implements DisposableBean,
PortalEventDimensionPopulator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TimeDimensionDao timeDimensionDao;
    private DateDimensionDao dateDimensionDao;
    private AggregationIntervalHelper intervalHelper;
    private IPortalEventDao portalEventDao;
    private IEventAggregationManagementDao eventAggregationManagementDao;
    private IClusterLockService clusterLockService;
    private ReadablePeriod dimensionBuffer = Period.days((int)30);
    private volatile boolean checkedDimensions = false;
    private volatile boolean shutdown = false;

    @Autowired
    public void setClusterLockService(IClusterLockService clusterLockService) {
        this.clusterLockService = clusterLockService;
    }

    @Autowired
    public void setTimeDimensionDao(TimeDimensionDao timeDimensionDao) {
        this.timeDimensionDao = timeDimensionDao;
    }

    @Autowired
    public void setDateDimensionDao(DateDimensionDao dateDimensionDao) {
        this.dateDimensionDao = dateDimensionDao;
    }

    @Autowired
    public void setIntervalHelper(AggregationIntervalHelper intervalHelper) {
        this.intervalHelper = intervalHelper;
    }

    @Autowired
    public void setPortalEventDao(IPortalEventDao portalEventDao) {
        this.portalEventDao = portalEventDao;
    }

    @Autowired
    public void setEventAggregationManagementDao(IEventAggregationManagementDao eventAggregationManagementDao) {
        this.eventAggregationManagementDao = eventAggregationManagementDao;
    }

    @Value(value="${org.jasig.portal.events.aggr.PortalEventDimensionPopulatorImpl.dimensionBuffer:P30D}")
    public void setDimensionBuffer(ReadablePeriod dimensionBuffer) {
        if (new Period((Object)dimensionBuffer).toStandardDays().getDays() < 1) {
            throw new IllegalArgumentException("dimensionBuffer must be at least 1 day. Is: " + new Period((Object)dimensionBuffer).toStandardDays().getDays());
        }
        this.dimensionBuffer = dimensionBuffer;
    }

    public void destroy() throws Exception {
        this.shutdown = true;
    }

    public boolean isCheckedDimensions() {
        return this.checkedDimensions;
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public void doPopulateDimensions() {
        if (this.shutdown) {
            this.logger.warn("populateDimensions called after shutdown, ignoring call");
        }
        if (!this.clusterLockService.isLockOwner(DIMENSION_LOCK_NAME)) {
            throw new IllegalStateException("The cluster lock " + DIMENSION_LOCK_NAME + " must be owned by the current thread and server");
        }
        this.doPopulateTimeDimensions();
        this.doPopulateDateDimensions();
        this.doUpdateDateDimensions();
        this.getEntityManager().flush();
        this.checkedDimensions = true;
    }

    private void checkShutdown() {
        if (this.shutdown) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("uPortal is shutting down, throwing an exeption to stop processing");
        }
    }

    final void doPopulateTimeDimensions() {
        List timeDimensions = this.timeDimensionDao.getTimeDimensions();
        if (timeDimensions.isEmpty()) {
            this.logger.info("No TimeDimensions exist, creating them");
        } else if (timeDimensions.size() != 1440) {
            this.logger.info("There are only " + timeDimensions.size() + " time dimensions in the database, there should be " + 1440 + " creating missing dimensions");
        } else {
            this.logger.debug("Found expected " + timeDimensions.size() + " time dimensions");
            return;
        }
        LocalTime nextTime = new LocalTime(0, 0);
        LocalTime lastTime = new LocalTime(23, 59);
        for (TimeDimension timeDimension : timeDimensions) {
            LocalTime dimensionTime = timeDimension.getTime();
            if (nextTime.isBefore((ReadablePartial)dimensionTime)) {
                do {
                    this.checkShutdown();
                    this.timeDimensionDao.createTimeDimension(nextTime);
                } while ((nextTime = nextTime.plusMinutes(1)).isBefore((ReadablePartial)dimensionTime));
            } else if (nextTime.isAfter((ReadablePartial)dimensionTime)) {
                do {
                    this.checkShutdown();
                    this.timeDimensionDao.createTimeDimension(dimensionTime);
                } while (nextTime.isAfter((ReadablePartial)(dimensionTime = dimensionTime.plusMinutes(1))));
            }
            nextTime = dimensionTime.plusMinutes(1);
        }
        while (nextTime.isBefore((ReadablePartial)lastTime) || nextTime.equals((Object)lastTime)) {
            this.checkShutdown();
            this.timeDimensionDao.createTimeDimension(nextTime);
            if (nextTime.equals((Object)lastTime)) break;
            nextTime = nextTime.plusMinutes(1);
        }
    }

    final void doPopulateDateDimensions() {
        DateTime now = this.getNow();
        DateTime oldestPortalEventTimestamp = this.portalEventDao.getOldestPortalEventTimestamp();
        AggregationIntervalInfo startIntervalInfo = oldestPortalEventTimestamp == null || now.isBefore((ReadableInstant)oldestPortalEventTimestamp) ? this.intervalHelper.getIntervalInfo(AggregationInterval.YEAR, now.minus(this.dimensionBuffer)) : this.intervalHelper.getIntervalInfo(AggregationInterval.YEAR, oldestPortalEventTimestamp.minus(this.dimensionBuffer));
        DateTime newestPortalEventTimestamp = this.portalEventDao.getNewestPortalEventTimestamp();
        AggregationIntervalInfo endIntervalInfo = newestPortalEventTimestamp == null || now.isAfter((ReadableInstant)newestPortalEventTimestamp) ? this.intervalHelper.getIntervalInfo(AggregationInterval.YEAR, now.plus(this.dimensionBuffer)) : this.intervalHelper.getIntervalInfo(AggregationInterval.YEAR, newestPortalEventTimestamp.plus(this.dimensionBuffer));
        DateMidnight start = startIntervalInfo.getStart().toDateMidnight();
        DateMidnight end = endIntervalInfo.getEnd().toDateMidnight();
        this.doPopulateDateDimensions(start, end);
    }

    final void doPopulateDateDimensions(DateMidnight start, DateMidnight end) {
        this.logger.info("Populating DateDimensions between {} and {}", (Object)start, (Object)end);
        List quartersDetails = this.eventAggregationManagementDao.getQuartersDetails();
        List academicTermDetails = this.eventAggregationManagementDao.getAcademicTermDetails();
        List dateDimensions = this.dateDimensionDao.getDateDimensionsBetween(start, end);
        DateMidnight nextDate = start;
        for (DateDimension dateDimension : dateDimensions) {
            DateMidnight dimensionDate = dateDimension.getDate();
            if (nextDate.isBefore((ReadableInstant)dimensionDate)) {
                do {
                    this.checkShutdown();
                    this.createDateDimension(quartersDetails, academicTermDetails, nextDate);
                } while ((nextDate = nextDate.plusDays(1)).isBefore((ReadableInstant)dimensionDate));
            } else if (nextDate.isAfter((ReadableInstant)dimensionDate)) {
                do {
                    this.checkShutdown();
                    this.createDateDimension(quartersDetails, academicTermDetails, dimensionDate);
                } while (nextDate.isAfter((ReadableInstant)(dimensionDate = dimensionDate.plusDays(1))));
            }
            nextDate = dimensionDate.plusDays(1);
        }
        while (nextDate.isBefore((ReadableInstant)end)) {
            this.checkShutdown();
            this.createDateDimension(quartersDetails, academicTermDetails, nextDate);
            nextDate = nextDate.plusDays(1);
        }
    }

    final void doUpdateDateDimensions() {
        List dateDimensions = this.dateDimensionDao.getDateDimensionsWithoutTerm();
        List academicTermDetails = this.eventAggregationManagementDao.getAcademicTermDetails();
        for (DateDimension dateDimension : dateDimensions) {
            DateMidnight date = dateDimension.getDate();
            AcademicTermDetail termDetail = (AcademicTermDetail)EventDateTimeUtils.findDateRangeSorted((ReadableInstant)date, (List)academicTermDetails);
            if (termDetail == null) continue;
            dateDimension.setTerm(termDetail.getTermName());
            this.dateDimensionDao.updateDateDimension(dateDimension);
        }
    }

    DateTime getNow() {
        return DateTime.now();
    }

    protected void createDateDimension(List<QuarterDetail> quartersDetails, List<AcademicTermDetail> academicTermDetails, DateMidnight date) {
        QuarterDetail quarterDetail = (QuarterDetail)EventDateTimeUtils.findDateRangeSorted((ReadableInstant)date, quartersDetails);
        AcademicTermDetail termDetail = (AcademicTermDetail)EventDateTimeUtils.findDateRangeSorted((ReadableInstant)date, academicTermDetails);
        this.dateDimensionDao.createDateDimension(date, quarterDetail.getQuarterId(), termDetail != null ? termDetail.getTermName() : null);
    }
}

