/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.jasig.portal.concurrency.locking.IClusterLockService;
import org.jasig.portal.concurrency.locking.LockOptions;
import org.jasig.portal.events.aggr.EventProcessingResult;
import org.jasig.portal.events.aggr.HibernateCacheEvictor;
import org.jasig.portal.events.aggr.IPortalEventProcessingManager;
import org.jasig.portal.events.aggr.PortalEventDimensionPopulator;
import org.jasig.portal.events.aggr.PortalEventPurger;
import org.jasig.portal.events.aggr.PortalEventSessionPurger;
import org.jasig.portal.events.aggr.PortalRawEventsAggregator;
import org.jasig.portal.version.dao.VersionDao;
import org.jasig.portal.version.om.Version;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="portalEventAggregationManager")
public class PortalEventProcessingManagerImpl
implements IPortalEventProcessingManager,
HibernateCacheEvictor,
DisposableBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PortalEventDimensionPopulator portalEventDimensionPopulator;
    private PortalRawEventsAggregator portalEventAggregator;
    private PortalEventPurger portalEventPurger;
    private PortalEventSessionPurger portalEventSessionPurger;
    private IClusterLockService clusterLockService;
    private Map<String, Version> requiredProductVersions = Collections.emptyMap();
    private VersionDao versionDao;
    private long aggregateRawEventsPeriod = 0L;
    private long purgeRawEventsPeriod = 0L;
    private long purgeEventSessionsPeriod = 0L;
    private final ThreadLocal<Map<Class<?>, Collection<Serializable>>> evictedEntitiesHolder = new /* Unavailable Anonymous Inner Class!! */;
    private volatile boolean shutdown = false;

    @Autowired
    public void setClusterLockService(IClusterLockService clusterLockService) {
        this.clusterLockService = clusterLockService;
    }

    @Autowired
    public void setPortalEventDimensionPopulator(PortalEventDimensionPopulator portalEventDimensionPopulator) {
        this.portalEventDimensionPopulator = portalEventDimensionPopulator;
    }

    @Autowired
    public void setPortalEventAggregator(PortalRawEventsAggregator portalEventAggregator) {
        this.portalEventAggregator = portalEventAggregator;
    }

    @Autowired
    public void setPortalEventPurger(PortalEventPurger portalEventPurger) {
        this.portalEventPurger = portalEventPurger;
    }

    @Autowired
    public void setPortalEventSessionPurger(PortalEventSessionPurger portalEventSessionPurger) {
        this.portalEventSessionPurger = portalEventSessionPurger;
    }

    @Value(value="${org.jasig.portal.events.aggr.PortalEventProcessingManagerImpl.aggregateRawEventsPeriod}")
    public void setAggregateRawEventsPeriod(long aggregateRawEventsPeriod) {
        this.aggregateRawEventsPeriod = aggregateRawEventsPeriod;
    }

    @Value(value="${org.jasig.portal.events.aggr.PortalEventProcessingManagerImpl.purgeRawEventsPeriod}")
    public void setPurgeRawEventsPeriod(long purgeRawEventsPeriod) {
        this.purgeRawEventsPeriod = purgeRawEventsPeriod;
    }

    @Value(value="${org.jasig.portal.events.aggr.PortalEventProcessingManagerImpl.purgeEventSessionsPeriod}")
    public void setPurgeEventSessionsPeriod(long purgeEventSessionsPeriod) {
        this.purgeEventSessionsPeriod = purgeEventSessionsPeriod;
    }

    @Resource(name="productVersions")
    public void setRequiredProductVersions(Map<String, Version> requiredProductVersions) {
        this.requiredProductVersions = ImmutableMap.copyOf(requiredProductVersions);
    }

    @Autowired
    public void setVersionDao(VersionDao versionDao) {
        this.versionDao = versionDao;
    }

    public void destroy() throws Exception {
        this.shutdown = true;
    }

    public boolean populateDimensions() {
        if (this.shutdown) {
            this.logger.warn("populateDimensions called after shutdown, ignoring call");
            return false;
        }
        if (!this.checkDatabaseVersion("AggrEventsDb")) {
            this.logger.info("The database and software versions for AggrEventsDb do not match. No dimension population will be done");
            return false;
        }
        try {
            IClusterLockService.TryLockFunctionResult result = this.clusterLockService.doInTryLock(PortalEventDimensionPopulator.DIMENSION_LOCK_NAME, (Function)new /* Unavailable Anonymous Inner Class!! */);
            return result.getLockStatus() == IClusterLockService.LockStatus.EXECUTED;
        }
        catch (InterruptedException e) {
            this.logger.warn("Interrupted while populating dimensions", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
        catch (RuntimeException e) {
            this.logger.error("populateDimensions failed", (Throwable)e);
            throw e;
        }
    }

    public boolean aggregateRawEvents() {
        if (this.shutdown) {
            this.logger.warn("aggregateRawEvents called after shutdown, ignoring call");
            return false;
        }
        if (!this.checkDatabaseVersion("AggrEventsDb")) {
            this.logger.info("The database and software versions for AggrEventsDb do not match. No event aggregation will be done");
            return false;
        }
        if (!this.checkDatabaseVersion("RawEventsDb")) {
            this.logger.info("The database and software versions for RawEventsDb do not match. No event aggregation will be done");
            return false;
        }
        long aggregateLastRunDelay = (long)((double)this.aggregateRawEventsPeriod * 0.95);
        long aggregateServerBiasDelay = this.aggregateRawEventsPeriod * 4L;
        IClusterLockService.TryLockFunctionResult result = null;
        EventProcessingResult aggrResult = null;
        do {
            if (result != null) {
                this.logger.info("doAggregateRawEvents signaled that not all eligible events were aggregated in a single transaction, running aggregation again.");
                aggregateLastRunDelay = 0L;
            }
            try {
                EventProcessingResult cleanResult;
                IClusterLockService.TryLockFunctionResult cleanAggrResult;
                long start = System.nanoTime();
                result = this.clusterLockService.doInTryLock(PortalRawEventsAggregator.AGGREGATION_LOCK_NAME, LockOptions.builder().lastRunDelay(aggregateLastRunDelay).serverBiasDelay(aggregateServerBiasDelay), (Function)new /* Unavailable Anonymous Inner Class!! */);
                aggrResult = (EventProcessingResult)result.getResult();
                if (result.getLockStatus() == IClusterLockService.LockStatus.EXECUTED && aggrResult == null) {
                    this.logger.warn("doAggregateRawEvents did not execute");
                    continue;
                }
                if (aggrResult == null) continue;
                if (this.logger.isInfoEnabled()) {
                    this.logResult("Aggregated {} events created at {} events/second between {} and {} in {}ms - {} e/s a {}x speedup.", aggrResult, start);
                }
                if (aggrResult.getProcessed() <= 0) continue;
                Map evictedEntities = (Map)this.evictedEntitiesHolder.get();
                if (evictedEntities.size() > 0) {
                    this.portalEventAggregator.evictAggregates(evictedEntities);
                }
                do {
                    start = System.nanoTime();
                    cleanAggrResult = this.clusterLockService.doInTryLock(PortalRawEventsAggregator.AGGREGATION_LOCK_NAME, (Function)new /* Unavailable Anonymous Inner Class!! */);
                    cleanResult = (EventProcessingResult)cleanAggrResult.getResult();
                    if (cleanAggrResult.getLockStatus() == IClusterLockService.LockStatus.EXECUTED && cleanResult == null) {
                        this.logger.warn("doCloseAggregations was not executed");
                        continue;
                    }
                    if (cleanResult == null || !this.logger.isInfoEnabled()) continue;
                    this.logResult("Clean {} unclosed agregations created at {} aggrs/second between {} and {} in {}ms - {} a/s a {}x speedup", cleanResult, start);
                } while (cleanAggrResult.getLockStatus() == IClusterLockService.LockStatus.EXECUTED && cleanResult != null && !cleanResult.isComplete());
            }
            catch (InterruptedException e) {
                this.logger.warn("Interrupted while aggregating", (Throwable)e);
                Thread.currentThread().interrupt();
                boolean bl = false;
                return bl;
            }
            catch (RuntimeException e) {
                this.logger.error("aggregateRawEvents failed", (Throwable)e);
                throw e;
            }
            finally {
                this.evictedEntitiesHolder.remove();
            }
        } while (result.getLockStatus() == IClusterLockService.LockStatus.EXECUTED && aggrResult != null && !aggrResult.isComplete());
        return result != null && result.getLockStatus() == IClusterLockService.LockStatus.EXECUTED && aggrResult != null && aggrResult.isComplete();
    }

    public boolean purgeRawEvents() {
        if (this.shutdown) {
            this.logger.warn("purgeRawEvents called after shutdown, ignoring call");
            return false;
        }
        if (!this.checkDatabaseVersion("RawEventsDb")) {
            this.logger.info("The database and software versions for RawEventsDb do not match. No event purging will be done");
            return false;
        }
        long purgeLastRunDelay = (long)((double)this.purgeRawEventsPeriod * 0.95);
        IClusterLockService.TryLockFunctionResult result = null;
        EventProcessingResult purgeResult = null;
        do {
            if (result != null) {
                this.logger.debug("doPurgeRawEvents signaled that not all eligibe events were purged in a single transaction, running purge again.");
                purgeLastRunDelay = 0L;
            }
            try {
                long start = System.nanoTime();
                result = this.clusterLockService.doInTryLock(PortalEventPurger.PURGE_RAW_EVENTS_LOCK_NAME, LockOptions.builder().lastRunDelay(purgeLastRunDelay), (Function)new /* Unavailable Anonymous Inner Class!! */);
                purgeResult = (EventProcessingResult)result.getResult();
                if (result.getLockStatus() == IClusterLockService.LockStatus.EXECUTED && purgeResult == null) {
                    this.logger.warn("doPurgeRawEvents did not execute");
                    continue;
                }
                if (purgeResult == null || !this.logger.isInfoEnabled()) continue;
                this.logResult("Purged {} events created at {} events/second between {} and {} in {}ms - {} e/s a {}x speedup", purgeResult, start);
            }
            catch (InterruptedException e) {
                this.logger.warn("Interrupted while purging raw events", (Throwable)e);
                Thread.currentThread().interrupt();
                return false;
            }
            catch (RuntimeException e) {
                this.logger.error("purgeRawEvents failed", (Throwable)e);
                throw e;
            }
        } while (result.getLockStatus() == IClusterLockService.LockStatus.EXECUTED && purgeResult != null && !purgeResult.isComplete());
        return result != null && result.getLockStatus() == IClusterLockService.LockStatus.EXECUTED && purgeResult != null && purgeResult.isComplete();
    }

    public boolean purgeEventSessions() {
        if (this.shutdown) {
            this.logger.warn("purgeEventSessions called after shutdown, ignoring call");
            return false;
        }
        if (!this.checkDatabaseVersion("AggrEventsDb")) {
            this.logger.info("The database and software versions for AggrEventsDb do not match. No event session purging will be done");
            return false;
        }
        try {
            long start = System.nanoTime();
            long purgeLastRunDelay = (long)((double)this.purgeEventSessionsPeriod * 0.95);
            IClusterLockService.TryLockFunctionResult result = this.clusterLockService.doInTryLock(PortalEventSessionPurger.PURGE_EVENT_SESSION_LOCK_NAME, LockOptions.builder().lastRunDelay(purgeLastRunDelay), (Function)new /* Unavailable Anonymous Inner Class!! */);
            EventProcessingResult purgeResult = (EventProcessingResult)result.getResult();
            if (result.getLockStatus() == IClusterLockService.LockStatus.EXECUTED && purgeResult == null) {
                this.logger.warn("doPurgeRawEvents did not execute");
            } else if (purgeResult != null && this.logger.isInfoEnabled()) {
                this.logResult("Purged {} event sessions created before {} in {}ms - {} sessions/second", purgeResult, start);
            }
            return result.getLockStatus() == IClusterLockService.LockStatus.EXECUTED && purgeResult != null && purgeResult.isComplete();
        }
        catch (InterruptedException e) {
            this.logger.warn("Interrupted while purging event sessions", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
        catch (RuntimeException e) {
            this.logger.error("purgeEventSessions failed", (Throwable)e);
            throw e;
        }
    }

    public void evictEntity(Class<?> entityClass, Serializable identifier) {
        Map evictedEntities = (Map)this.evictedEntitiesHolder.get();
        ArrayList<Serializable> ids = (ArrayList<Serializable>)evictedEntities.get(entityClass);
        if (ids == null) {
            ids = new ArrayList<Serializable>();
            evictedEntities.put(entityClass, ids);
        }
        ids.add(identifier);
    }

    private boolean checkDatabaseVersion(String databaseName) {
        Version softwareVersion = (Version)this.requiredProductVersions.get(databaseName);
        if (softwareVersion == null) {
            throw new IllegalStateException("No version number is configured for: " + databaseName);
        }
        Version databaseVersion = this.versionDao.getVersion(databaseName);
        if (databaseVersion == null) {
            throw new IllegalStateException("No version number is exists in the database for: " + databaseName);
        }
        return softwareVersion.equals(databaseVersion);
    }

    private void logResult(String message, EventProcessingResult aggrResult, long start) {
        long runTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        double processRate = (double)aggrResult.getProcessed() / ((double)runTime / 1000.0);
        DateTime startDate = aggrResult.getStart();
        if (startDate != null) {
            double creationRate = aggrResult.getCreationRate();
            double processSpeedUp = processRate / creationRate;
            this.logger.info(message, new Object[]{aggrResult.getProcessed(), String.format("%.4f", creationRate), startDate, aggrResult.getEnd(), runTime, String.format("%.4f", processRate), String.format("%.4f", processSpeedUp)});
        } else {
            this.logger.info(message, new Object[]{aggrResult.getProcessed(), aggrResult.getEnd(), runTime, String.format("%.4f", processRate)});
        }
    }

    static /* synthetic */ PortalEventDimensionPopulator access$000(PortalEventProcessingManagerImpl x0) {
        return x0.portalEventDimensionPopulator;
    }

    static /* synthetic */ PortalRawEventsAggregator access$100(PortalEventProcessingManagerImpl x0) {
        return x0.portalEventAggregator;
    }

    static /* synthetic */ PortalEventPurger access$200(PortalEventProcessingManagerImpl x0) {
        return x0.portalEventPurger;
    }

    static /* synthetic */ PortalEventSessionPurger access$300(PortalEventProcessingManagerImpl x0) {
        return x0.portalEventSessionPurger;
    }
}

