/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import org.jasig.portal.IPortalInfoProvider;
import org.jasig.portal.concurrency.locking.IClusterLockService;
import org.jasig.portal.events.aggr.EventProcessingResult;
import org.jasig.portal.events.aggr.IEventAggregatorStatus;
import org.jasig.portal.events.aggr.PortalEventPurger;
import org.jasig.portal.events.aggr.dao.IEventAggregationManagementDao;
import org.jasig.portal.events.handlers.db.IPortalEventDao;
import org.jasig.portal.jpa.BaseAggrEventsJpaDao;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PortalEventPurgerImpl
implements PortalEventPurger {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IEventAggregationManagementDao eventAggregationManagementDao;
    private IPortalInfoProvider portalInfoProvider;
    private IPortalEventDao portalEventDao;
    private IClusterLockService clusterLockService;
    private ReadablePeriod purgeDelay = Period.days((int)1);

    @Autowired
    public void setClusterLockService(IClusterLockService clusterLockService) {
        this.clusterLockService = clusterLockService;
    }

    @Autowired
    public void setEventAggregationManagementDao(IEventAggregationManagementDao eventAggregationManagementDao) {
        this.eventAggregationManagementDao = eventAggregationManagementDao;
    }

    @Autowired
    public void setPortalInfoProvider(IPortalInfoProvider portalInfoProvider) {
        this.portalInfoProvider = portalInfoProvider;
    }

    @Autowired
    public void setPortalEventDao(IPortalEventDao portalEventDao) {
        this.portalEventDao = portalEventDao;
    }

    @Value(value="${org.jasig.portal.events.aggr.PortalEventPurgerImpl.purgeDelay:PT1H}")
    public void setPurgeDelay(ReadablePeriod purgeDelay) {
        this.purgeDelay = purgeDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public EventProcessingResult doPurgeRawEvents() {
        int events;
        DateTime purgeEndLimit;
        if (!this.clusterLockService.isLockOwner(PURGE_RAW_EVENTS_LOCK_NAME)) {
            throw new IllegalStateException("The cluster lock " + PURGE_RAW_EVENTS_LOCK_NAME + " must be owned by the current thread and server");
        }
        IEventAggregatorStatus eventPurgerStatus = this.eventAggregationManagementDao.getEventAggregatorStatus(IEventAggregatorStatus.ProcessingType.PURGING, true);
        String serverName = this.portalInfoProvider.getUniqueServerName();
        eventPurgerStatus.setServerName(serverName);
        eventPurgerStatus.setLastStart(new DateTime());
        IEventAggregatorStatus eventAggregatorStatus = this.eventAggregationManagementDao.getEventAggregatorStatus(IEventAggregatorStatus.ProcessingType.AGGREGATION, false);
        if (eventAggregatorStatus == null || eventAggregatorStatus.getLastEventDate() == null) {
            eventPurgerStatus.setLastEnd(new DateTime());
            this.eventAggregationManagementDao.updateEventAggregatorStatus(eventPurgerStatus);
            return new EventProcessingResult(0, null, null, true);
        }
        boolean complete = true;
        DateTime lastAggregated = eventAggregatorStatus.getLastEventDate();
        DateTime purgeEnd = lastAggregated.minus(this.purgeDelay);
        DateTime oldestEventDate = eventPurgerStatus.getLastEventDate();
        if (oldestEventDate == null) {
            oldestEventDate = this.portalEventDao.getOldestPortalEventTimestamp();
        }
        if ((purgeEndLimit = oldestEventDate.plusHours(1)).isBefore((ReadableInstant)purgeEnd)) {
            purgeEnd = purgeEndLimit;
            complete = false;
        }
        Thread currentThread = Thread.currentThread();
        String currentName = currentThread.getName();
        try {
            currentThread.setName(currentName + "-" + purgeEnd);
            this.logger.debug("Starting purge of events before {}", (Object)purgeEnd);
            events = this.portalEventDao.deletePortalEventsBefore(purgeEnd);
        }
        finally {
            currentThread.setName(currentName);
        }
        purgeEnd = purgeEnd.minusMillis(100);
        eventPurgerStatus.setLastEventDate(purgeEnd);
        eventPurgerStatus.setLastEnd(new DateTime());
        this.eventAggregationManagementDao.updateEventAggregatorStatus(eventPurgerStatus);
        return new EventProcessingResult(events, oldestEventDate, purgeEnd, complete);
    }
}

