/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.lang.mutable.MutableObject;
import org.hibernate.Cache;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.jasig.portal.IPortalInfoProvider;
import org.jasig.portal.concurrency.locking.IClusterLockService;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.aggr.AggregatedIntervalConfig;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.AggregationIntervalHelper;
import org.jasig.portal.events.aggr.AggregationIntervalInfo;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.EventProcessingResult;
import org.jasig.portal.events.aggr.IEventAggregatorStatus;
import org.jasig.portal.events.aggr.IPortalEventAggregator;
import org.jasig.portal.events.aggr.IPortalEventProcessingManager;
import org.jasig.portal.events.aggr.PortalEventDimensionPopulator;
import org.jasig.portal.events.aggr.PortalRawEventsAggregator;
import org.jasig.portal.events.aggr.PortalRawEventsAggregatorImpl;
import org.jasig.portal.events.aggr.dao.DateDimensionDao;
import org.jasig.portal.events.aggr.dao.IEventAggregationManagementDao;
import org.jasig.portal.events.aggr.session.EventSessionDao;
import org.jasig.portal.events.handlers.db.IPortalEventDao;
import org.jasig.portal.jpa.BaseAggrEventsJpaDao;
import org.jasig.portal.jpa.BaseRawEventsJpaDao;
import org.jasig.portal.spring.context.ApplicationEventFilter;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionCallback;

@Service
public class PortalRawEventsAggregatorImpl
extends BaseAggrEventsJpaDao
implements PortalRawEventsAggregator,
DisposableBean {
    private static final String EVENT_SESSION_CACHE_KEY_SOURCE = AggregateEventsHandler.class.getName() + "-EventSession";
    private IClusterLockService clusterLockService;
    private IPortalEventProcessingManager portalEventAggregationManager;
    private PortalEventDimensionPopulator portalEventDimensionPopulator;
    private IEventAggregationManagementDao eventAggregationManagementDao;
    private IPortalInfoProvider portalInfoProvider;
    private IPortalEventDao portalEventDao;
    private AggregationIntervalHelper intervalHelper;
    private EventSessionDao eventSessionDao;
    private DateDimensionDao dateDimensionDao;
    private Set<IPortalEventAggregator<PortalEvent>> portalEventAggregators = Collections.emptySet();
    private List<ApplicationEventFilter<PortalEvent>> applicationEventFilters = Collections.emptyList();
    private int eventAggregationBatchSize = 10000;
    private int intervalAggregationBatchSize = 5;
    private int cleanUnclosedAggregationsBatchSize = 1000;
    private int cleanUnclosedIntervalsBatchSize = 315;
    private ReadablePeriod aggregationDelay = Period.seconds((int)30);
    private final Map<Class<?>, List<String>> entityCollectionRoles = new HashMap();
    private volatile boolean shutdown = false;

    @Autowired
    public void setDateDimensionDao(DateDimensionDao dateDimensionDao) {
        this.dateDimensionDao = dateDimensionDao;
    }

    @Autowired
    public void setPortalEventAggregationManager(IPortalEventProcessingManager portalEventAggregationManager) {
        this.portalEventAggregationManager = portalEventAggregationManager;
    }

    @Autowired
    public void setClusterLockService(IClusterLockService clusterLockService) {
        this.clusterLockService = clusterLockService;
    }

    @Autowired
    public void setPortalEventDimensionPopulator(PortalEventDimensionPopulator portalEventDimensionPopulator) {
        this.portalEventDimensionPopulator = portalEventDimensionPopulator;
    }

    @Autowired
    public void setEventAggregationManagementDao(IEventAggregationManagementDao eventAggregationManagementDao) {
        this.eventAggregationManagementDao = eventAggregationManagementDao;
    }

    @Autowired
    public void setPortalInfoProvider(IPortalInfoProvider portalInfoProvider) {
        this.portalInfoProvider = portalInfoProvider;
    }

    @Autowired
    public void setPortalEventDao(IPortalEventDao portalEventDao) {
        this.portalEventDao = portalEventDao;
    }

    @Autowired
    public void setIntervalHelper(AggregationIntervalHelper intervalHelper) {
        this.intervalHelper = intervalHelper;
    }

    @Autowired
    public void setEventSessionDao(EventSessionDao eventSessionDao) {
        this.eventSessionDao = eventSessionDao;
    }

    @Autowired
    public void setPortalEventAggregators(Set<IPortalEventAggregator<PortalEvent>> portalEventAggregators) {
        this.portalEventAggregators = portalEventAggregators;
    }

    @Resource(name="aggregatorEventFilters")
    public void setApplicationEventFilters(List<ApplicationEventFilter<PortalEvent>> applicationEventFilters) {
        this.applicationEventFilters = applicationEventFilters;
    }

    @Value(value="${org.jasig.portal.events.aggr.PortalRawEventsAggregatorImpl.aggregationDelay:PT30S}")
    public void setAggregationDelay(ReadablePeriod aggregationDelay) {
        this.aggregationDelay = aggregationDelay;
    }

    @Value(value="${org.jasig.portal.events.aggr.PortalRawEventsAggregatorImpl.eventAggregationBatchSize:10000}")
    public void setEventAggregationBatchSize(int eventAggregationBatchSize) {
        this.eventAggregationBatchSize = eventAggregationBatchSize;
    }

    @Value(value="${org.jasig.portal.events.aggr.PortalRawEventsAggregatorImpl.intervalAggregationBatchSize:5}")
    public void setIntervalAggregationBatchSize(int intervalAggregationBatchSize) {
        this.intervalAggregationBatchSize = intervalAggregationBatchSize;
    }

    @Value(value="${org.jasig.portal.events.aggr.PortalRawEventsAggregatorImpl.cleanUnclosedAggregationsBatchSize:1000}")
    public void setCleanUnclosedAggregationsBatchSize(int cleanUnclosedAggregationsBatchSize) {
        this.cleanUnclosedAggregationsBatchSize = cleanUnclosedAggregationsBatchSize;
    }

    @Value(value="${org.jasig.portal.events.aggr.PortalRawEventsAggregatorImpl.cleanUnclosedIntervalsBatchSize:300}")
    public void setCleanUnclosedIntervalsBatchSize(int cleanUnclosedIntervalsBatchSize) {
        this.cleanUnclosedIntervalsBatchSize = cleanUnclosedIntervalsBatchSize;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    public void destroy() throws Exception {
        this.shutdown = true;
    }

    private void checkShutdown() {
        if (this.shutdown) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("uPortal is shutting down, throwing an exception to stop processing");
        }
    }

    @BaseRawEventsJpaDao.RawEventsTransactional
    public EventProcessingResult doAggregateRawEvents() {
        return (EventProcessingResult)this.getTransactionOperations().execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public void evictAggregates(Map<Class<?>, Collection<Serializable>> entitiesToEvict) {
        int evictedEntities = 0;
        int evictedCollections = 0;
        Session session = (Session)this.getEntityManager().unwrap(Session.class);
        SessionFactory sessionFactory = session.getSessionFactory();
        Cache cache = sessionFactory.getCache();
        for (Map.Entry<Class<?>, Collection<Serializable>> evictedEntityEntry : entitiesToEvict.entrySet()) {
            Class<?> entityClass = evictedEntityEntry.getKey();
            List collectionRoles = this.getCollectionRoles(sessionFactory, entityClass);
            for (Serializable id : evictedEntityEntry.getValue()) {
                cache.evictEntity(entityClass, id);
                ++evictedEntities;
                for (String collectionRole : collectionRoles) {
                    cache.evictCollection(collectionRole, id);
                    ++evictedCollections;
                }
            }
        }
        this.logger.debug("Evicted {} entities and {} collections from hibernate caches", (Object)evictedEntities, (Object)evictedCollections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public EventProcessingResult doCloseAggregations() {
        DateTime cleanUnclosedEnd;
        DateTime lastCleanUnclosedDate;
        if (!this.clusterLockService.isLockOwner(AGGREGATION_LOCK_NAME)) {
            throw new IllegalStateException("The cluster lock " + AGGREGATION_LOCK_NAME + " must be owned by the current thread and server");
        }
        IEventAggregatorStatus cleanUnclosedStatus = this.eventAggregationManagementDao.getEventAggregatorStatus(IEventAggregatorStatus.ProcessingType.CLEAN_UNCLOSED, true);
        String serverName = this.portalInfoProvider.getUniqueServerName();
        cleanUnclosedStatus.setServerName(serverName);
        cleanUnclosedStatus.setLastStart(new DateTime());
        IEventAggregatorStatus eventAggregatorStatus = this.eventAggregationManagementDao.getEventAggregatorStatus(IEventAggregatorStatus.ProcessingType.AGGREGATION, false);
        if (eventAggregatorStatus == null || eventAggregatorStatus.getLastEventDate() == null) {
            cleanUnclosedStatus.setLastEnd(new DateTime());
            this.eventAggregationManagementDao.updateEventAggregatorStatus(cleanUnclosedStatus);
            return new EventProcessingResult(0, null, null, true);
        }
        DateTime lastAggregatedDate = eventAggregatorStatus.getLastEventDate();
        if (cleanUnclosedStatus.getLastEventDate() == null) {
            DateDimension oldestDateDimension = this.dateDimensionDao.getOldestDateDimension();
            lastCleanUnclosedDate = oldestDateDimension.getDate().toDateTime();
        } else {
            lastCleanUnclosedDate = cleanUnclosedStatus.getLastEventDate();
        }
        if (!lastCleanUnclosedDate.isBefore((ReadableInstant)lastAggregatedDate)) {
            this.logger.debug("No events aggregated since last unclosed aggregation cleaning, skipping clean: {}", (Object)lastAggregatedDate);
            return new EventProcessingResult(0, lastCleanUnclosedDate, lastAggregatedDate, true);
        }
        EntityManager entityManager = this.getEntityManager();
        entityManager.flush();
        entityManager.setFlushMode(FlushModeType.COMMIT);
        int closedAggregations = 0;
        int cleanedIntervals = 0;
        Thread currentThread = Thread.currentThread();
        String currentName = currentThread.getName();
        try {
            currentThread.setName(currentName + "-" + lastCleanUnclosedDate + "-" + lastAggregatedDate);
            IntervalsForAggregatorHelper intervalsForAggregatorHelper = new IntervalsForAggregatorHelper(this);
            HashMap<AggregationInterval, AggregationIntervalInfo> previousIntervals = new HashMap<AggregationInterval, AggregationIntervalInfo>();
            DateTime nextIntervalDate = lastCleanUnclosedDate;
            do {
                cleanUnclosedEnd = lastAggregatedDate;
                for (AggregationInterval interval : intervalsForAggregatorHelper.getHandledIntervals()) {
                    AggregationIntervalInfo previousInterval = (AggregationIntervalInfo)previousIntervals.get(interval);
                    if (previousInterval != null && nextIntervalDate.isBefore((ReadableInstant)previousInterval.getEnd())) {
                        this.logger.debug("{} interval before {} has already been cleaned during this execution, ignoring", (Object)interval, (Object)previousInterval.getEnd());
                        continue;
                    }
                    AggregationIntervalInfo nextIntervalToClean = this.intervalHelper.getIntervalInfo(interval, nextIntervalDate);
                    previousIntervals.put(interval, nextIntervalToClean);
                    if (nextIntervalToClean == null) continue;
                    DateTime start = nextIntervalToClean.getStart();
                    DateTime end = nextIntervalToClean.getEnd();
                    if (!end.isBefore((ReadableInstant)lastAggregatedDate)) {
                        this.logger.debug("{} interval between {} and {} is still active, ignoring", new Object[]{interval, start, end});
                        continue;
                    }
                    if (end.isBefore((ReadableInstant)cleanUnclosedEnd)) {
                        cleanUnclosedEnd = end;
                    }
                    this.logger.debug("Cleaning unclosed {} aggregations between {} and {}", new Object[]{interval, start, end});
                    for (IPortalEventAggregator portalEventAggregator : this.portalEventAggregators) {
                        this.checkShutdown();
                        Class aggregatorType = this.getClass((Object)portalEventAggregator);
                        AggregatedIntervalConfig aggregatorIntervalConfig = intervalsForAggregatorHelper.getAggregatorIntervalConfig(aggregatorType);
                        if (!aggregatorIntervalConfig.isIncluded((Object)interval)) continue;
                        closedAggregations += portalEventAggregator.cleanUnclosedAggregations(start, end, interval);
                    }
                    ++cleanedIntervals;
                }
                nextIntervalDate = cleanUnclosedEnd;
                this.logger.debug("Closed {} aggregations across {} interval before {} with goal of {}", new Object[]{closedAggregations, cleanedIntervals, cleanUnclosedEnd, lastAggregatedDate});
            } while (closedAggregations <= this.cleanUnclosedAggregationsBatchSize && cleanedIntervals <= this.cleanUnclosedIntervalsBatchSize && cleanUnclosedEnd.isBefore((ReadableInstant)lastAggregatedDate));
        }
        finally {
            currentThread.setName(currentName);
        }
        cleanUnclosedStatus.setLastEventDate(cleanUnclosedEnd);
        cleanUnclosedStatus.setLastEnd(new DateTime());
        this.eventAggregationManagementDao.updateEventAggregatorStatus(cleanUnclosedStatus);
        return new EventProcessingResult(closedAggregations, lastCleanUnclosedDate, lastAggregatedDate, !cleanUnclosedEnd.isBefore((ReadableInstant)lastAggregatedDate));
    }

    protected final <T> Class<T> getClass(T object) {
        return AopProxyUtils.ultimateTargetClass(object);
    }

    private List<String> getCollectionRoles(SessionFactory sessionFactory, Class<?> entityClass) {
        List collectionRoles = (List)this.entityCollectionRoles.get(entityClass);
        if (collectionRoles != null) {
            return collectionRoles;
        }
        ImmutableList.Builder collectionRolesBuilder = ImmutableList.builder();
        ClassMetadata classMetadata = sessionFactory.getClassMetadata(entityClass);
        for (Type type : classMetadata.getPropertyTypes()) {
            if (!type.isCollectionType()) continue;
            collectionRolesBuilder.add((Object)((CollectionType)type).getRole());
        }
        collectionRoles = collectionRolesBuilder.build();
        this.entityCollectionRoles.put(entityClass, collectionRoles);
        return collectionRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventProcessingResult doAggregateRawEventsInternal() {
        boolean complete;
        boolean populatedDimensions;
        if (!this.clusterLockService.isLockOwner(AGGREGATION_LOCK_NAME)) {
            throw new IllegalStateException("The cluster lock " + AGGREGATION_LOCK_NAME + " must be owned by the current thread and server");
        }
        if (!this.portalEventDimensionPopulator.isCheckedDimensions() && !(populatedDimensions = this.portalEventAggregationManager.populateDimensions())) {
            this.logger.warn("Aborting raw event aggregation, populateDimensions returned false so the state of date/time dimensions is unknown");
            return null;
        }
        EntityManager entityManager = this.getEntityManager();
        entityManager.flush();
        entityManager.setFlushMode(FlushModeType.COMMIT);
        IEventAggregatorStatus eventAggregatorStatus = this.eventAggregationManagementDao.getEventAggregatorStatus(IEventAggregatorStatus.ProcessingType.AGGREGATION, true);
        String serverName = this.portalInfoProvider.getUniqueServerName();
        String previousServerName = eventAggregatorStatus.getServerName();
        if (previousServerName != null && !serverName.equals(previousServerName)) {
            this.logger.debug("Last aggregation run on {} clearing all aggregation caches", (Object)previousServerName);
            Session session = (Session)this.getEntityManager().unwrap(Session.class);
            Cache cache = session.getSessionFactory().getCache();
            cache.evictEntityRegions();
        }
        eventAggregatorStatus.setServerName(serverName);
        DateTime lastAggregated = eventAggregatorStatus.getLastEventDate();
        if (lastAggregated == null) {
            lastAggregated = this.portalEventDao.getOldestPortalEventTimestamp();
            if (lastAggregated == null) {
                return new EventProcessingResult(0, null, null, true);
            }
            IEventAggregatorStatus cleanUnclosedStatus = this.eventAggregationManagementDao.getEventAggregatorStatus(IEventAggregatorStatus.ProcessingType.CLEAN_UNCLOSED, true);
            AggregationIntervalInfo oldestMinuteInterval = this.intervalHelper.getIntervalInfo(AggregationInterval.MINUTE, lastAggregated);
            cleanUnclosedStatus.setLastEventDate(oldestMinuteInterval.getStart().minusMinutes(1));
            this.eventAggregationManagementDao.updateEventAggregatorStatus(cleanUnclosedStatus);
        }
        DateTime newestEventTime = DateTime.now().minus(this.aggregationDelay).secondOfMinute().roundFloorCopy();
        Thread currentThread = Thread.currentThread();
        String currentName = currentThread.getName();
        MutableInt events = new MutableInt();
        MutableObject lastEventDate = new MutableObject((Object)newestEventTime);
        try {
            currentThread.setName(currentName + "-" + lastAggregated + "_" + newestEventTime);
            this.logger.debug("Starting aggregation of events between {} (inc) and {} (exc)", (Object)lastAggregated, (Object)newestEventTime);
            eventAggregatorStatus.setLastStart(DateTime.now());
            complete = this.portalEventDao.aggregatePortalEvents(lastAggregated, newestEventTime, this.eventAggregationBatchSize, (Function)new AggregateEventsHandler(this, events, lastEventDate, eventAggregatorStatus, null));
            eventAggregatorStatus.setLastEventDate((DateTime)lastEventDate.getValue());
            eventAggregatorStatus.setLastEnd(DateTime.now());
        }
        finally {
            currentThread.setName(currentName);
        }
        this.eventAggregationManagementDao.updateEventAggregatorStatus(eventAggregatorStatus);
        complete = complete && (this.eventAggregationBatchSize <= 0 || events.intValue() < this.eventAggregationBatchSize);
        return new EventProcessingResult(events.intValue(), lastAggregated, eventAggregatorStatus.getLastEventDate(), complete);
    }

    static /* synthetic */ EventProcessingResult access$000(PortalRawEventsAggregatorImpl x0) {
        return x0.doAggregateRawEventsInternal();
    }

    static /* synthetic */ IEventAggregationManagementDao access$200(PortalRawEventsAggregatorImpl x0) {
        return x0.eventAggregationManagementDao;
    }

    static /* synthetic */ Set access$300(PortalRawEventsAggregatorImpl x0) {
        return x0.portalEventAggregators;
    }

    static /* synthetic */ boolean access$400(PortalRawEventsAggregatorImpl x0) {
        return x0.shutdown;
    }

    static /* synthetic */ Logger access$500(PortalRawEventsAggregatorImpl x0) {
        return x0.logger;
    }

    static /* synthetic */ AggregationIntervalHelper access$600(PortalRawEventsAggregatorImpl x0) {
        return x0.intervalHelper;
    }

    static /* synthetic */ int access$700(PortalRawEventsAggregatorImpl x0) {
        return x0.intervalAggregationBatchSize;
    }

    static /* synthetic */ void access$800(PortalRawEventsAggregatorImpl x0) {
        x0.checkShutdown();
    }

    static /* synthetic */ List access$900(PortalRawEventsAggregatorImpl x0) {
        return x0.applicationEventFilters;
    }

    static /* synthetic */ Logger access$1000(PortalRawEventsAggregatorImpl x0) {
        return x0.logger;
    }

    static /* synthetic */ Logger access$1100(PortalRawEventsAggregatorImpl x0) {
        return x0.logger;
    }

    static /* synthetic */ String access$1200() {
        return EVENT_SESSION_CACHE_KEY_SOURCE;
    }

    static /* synthetic */ EventSessionDao access$1300(PortalRawEventsAggregatorImpl x0) {
        return x0.eventSessionDao;
    }
}

