/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.concuser;

import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.AggregationIntervalInfo;
import org.jasig.portal.events.aggr.BaseAggregationPrivateDao;
import org.jasig.portal.events.aggr.BasePortalEventAggregator;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.EventAggregationContext;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationImpl;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationKey;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationKeyImpl;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationPrivateDao;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;

public class ConcurrentUserAggregator
extends BasePortalEventAggregator<PortalEvent, ConcurrentUserAggregationImpl, ConcurrentUserAggregationKey> {
    private ConcurrentUserAggregationPrivateDao concurrentUserAggregationDao;

    @Autowired
    public void setConcurrentUserAggregationDao(ConcurrentUserAggregationPrivateDao concurrentUserAggregationDao) {
        this.concurrentUserAggregationDao = concurrentUserAggregationDao;
    }

    protected BaseAggregationPrivateDao<ConcurrentUserAggregationImpl, ConcurrentUserAggregationKey> getAggregationDao() {
        return this.concurrentUserAggregationDao;
    }

    public boolean supports(Class<? extends PortalEvent> type) {
        return true;
    }

    protected void updateAggregation(PortalEvent e, EventAggregationContext eventAggregationContext, AggregationIntervalInfo intervalInfo, ConcurrentUserAggregationImpl aggregation) {
        String eventSessionId = e.getEventSessionId();
        int duration = intervalInfo.getDurationTo((ReadableInstant)e.getTimestampAsDate());
        aggregation.setDuration(duration);
        aggregation.countSession(eventSessionId);
    }

    protected ConcurrentUserAggregationKey createAggregationKey(PortalEvent e, EventAggregationContext eventAggregationContext, AggregationIntervalInfo intervalInfo, AggregatedGroupMapping aggregatedGroup) {
        TimeDimension timeDimension = intervalInfo.getTimeDimension();
        DateDimension dateDimension = intervalInfo.getDateDimension();
        AggregationInterval aggregationInterval = intervalInfo.getAggregationInterval();
        return new ConcurrentUserAggregationKeyImpl(dateDimension, timeDimension, aggregationInterval, aggregatedGroup);
    }
}

