/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.dao.jpa;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.metamodel.Attribute;
import org.jasig.portal.events.aggr.AcademicTermDetail;
import org.jasig.portal.events.aggr.AggregatedGroupConfig;
import org.jasig.portal.events.aggr.AggregatedIntervalConfig;
import org.jasig.portal.events.aggr.EventDateTimeUtils;
import org.jasig.portal.events.aggr.IEventAggregatorStatus;
import org.jasig.portal.events.aggr.IPortalEventAggregator;
import org.jasig.portal.events.aggr.QuarterDetail;
import org.jasig.portal.events.aggr.dao.IEventAggregationManagementDao;
import org.jasig.portal.events.aggr.dao.jpa.AcademicTermDetailImpl;
import org.jasig.portal.events.aggr.dao.jpa.AggregatedGroupConfigImpl;
import org.jasig.portal.events.aggr.dao.jpa.AggregatedIntervalConfigImpl;
import org.jasig.portal.events.aggr.dao.jpa.EventAggregatorStatusImpl;
import org.jasig.portal.events.aggr.dao.jpa.EventAggregatorStatusImpl_;
import org.jasig.portal.events.aggr.dao.jpa.QuarterDetailImpl;
import org.jasig.portal.jpa.BaseAggrEventsJpaDao;
import org.jasig.portal.jpa.BaseJpaDao;
import org.jasig.portal.jpa.OpenEntityManager;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.support.TransactionCallback;

@Repository
public class JpaEventAggregationManagementDao
extends BaseAggrEventsJpaDao
implements IEventAggregationManagementDao {
    private static final Class<IPortalEventAggregator> DEFAULT_AGGREGATOR_TYPE = IPortalEventAggregator.class;
    private CriteriaQuery<AggregatedGroupConfigImpl> findAllGroupConfigsQuery;
    private CriteriaQuery<AggregatedGroupConfigImpl> findGroupConfigForAggregatorQuery;
    private CriteriaQuery<AggregatedIntervalConfigImpl> findAllIntervalConfigsQuery;
    private CriteriaQuery<AggregatedIntervalConfigImpl> findIntervalConfigForAggregatorQuery;
    private CriteriaQuery<QuarterDetailImpl> findAllQuarterDetailsQuery;
    private CriteriaQuery<AcademicTermDetailImpl> findAllAcademicTermDetailsQuery;
    private ParameterExpression<Class> aggregatorTypeParameter;

    public void afterPropertiesSet() throws Exception {
        this.aggregatorTypeParameter = this.createParameterExpression(Class.class, "aggregatorType");
        this.findAllGroupConfigsQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findGroupConfigForAggregatorQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findAllIntervalConfigsQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findIntervalConfigForAggregatorQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findAllQuarterDetailsQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findAllAcademicTermDetailsQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    @OpenEntityManager(unitName="AggrEventsDb")
    public IEventAggregatorStatus getEventAggregatorStatus(IEventAggregatorStatus.ProcessingType processingType, boolean create) {
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(EventAggregatorStatusImpl.class);
        query.using((Attribute)EventAggregatorStatusImpl_.processingType, (Object)processingType);
        EventAggregatorStatusImpl status = (EventAggregatorStatusImpl)query.load();
        if (status == null && create) {
            status = (EventAggregatorStatusImpl)this.getTransactionOperations().execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        return status;
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public void updateEventAggregatorStatus(IEventAggregatorStatus eventAggregatorStatus) {
        this.getEntityManager().persist((Object)eventAggregatorStatus);
    }

    public AggregatedGroupConfig getDefaultAggregatedGroupConfig() {
        AggregatedGroupConfig groupConfig = this.getAggregatedGroupConfig(DEFAULT_AGGREGATOR_TYPE);
        if (groupConfig == null) {
            groupConfig = (AggregatedGroupConfig)this.getTransactionOperations().execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        return groupConfig;
    }

    public Set<AggregatedGroupConfig> getAggregatedGroupConfigs() {
        TypedQuery query = this.createCachedQuery(this.findAllGroupConfigsQuery);
        List results = query.getResultList();
        return new LinkedHashSet<AggregatedGroupConfig>(results);
    }

    public AggregatedGroupConfig getAggregatedGroupConfig(Class<? extends IPortalEventAggregator> aggregatorType) {
        TypedQuery query = this.createCachedQuery(this.findGroupConfigForAggregatorQuery);
        query.setParameter((Parameter)this.aggregatorTypeParameter, aggregatorType);
        return (AggregatedGroupConfig)DataAccessUtils.uniqueResult((Collection)query.getResultList());
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public AggregatedGroupConfig createAggregatedGroupConfig(Class<? extends IPortalEventAggregator> aggregatorType) {
        AggregatedGroupConfigImpl aggregatedGroupConfig = new AggregatedGroupConfigImpl(aggregatorType);
        this.getEntityManager().persist((Object)aggregatedGroupConfig);
        return aggregatedGroupConfig;
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public void updateAggregatedGroupConfig(AggregatedGroupConfig aggregatedGroupConfig) {
        this.getEntityManager().persist((Object)aggregatedGroupConfig);
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public void deleteAggregatedGroupConfig(AggregatedGroupConfig aggregatedGroupConfig) {
        this.getEntityManager().remove((Object)aggregatedGroupConfig);
    }

    public Set<AggregatedIntervalConfig> getAggregatedIntervalConfigs() {
        TypedQuery query = this.createCachedQuery(this.findAllIntervalConfigsQuery);
        List results = query.getResultList();
        return new LinkedHashSet<AggregatedIntervalConfig>(results);
    }

    public AggregatedIntervalConfig getDefaultAggregatedIntervalConfig() {
        AggregatedIntervalConfig intervalConfig = this.getAggregatedIntervalConfig(DEFAULT_AGGREGATOR_TYPE);
        if (intervalConfig == null) {
            intervalConfig = (AggregatedIntervalConfig)this.getTransactionOperations().execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        return intervalConfig;
    }

    public AggregatedIntervalConfig getAggregatedIntervalConfig(Class<? extends IPortalEventAggregator> aggregatorType) {
        TypedQuery query = this.createCachedQuery(this.findIntervalConfigForAggregatorQuery);
        query.setParameter((Parameter)this.aggregatorTypeParameter, aggregatorType);
        return (AggregatedIntervalConfig)DataAccessUtils.uniqueResult((Collection)query.getResultList());
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public AggregatedIntervalConfig createAggregatedIntervalConfig(Class<? extends IPortalEventAggregator> aggregatorType) {
        AggregatedIntervalConfigImpl aggregatedIntervalConfig = new AggregatedIntervalConfigImpl(aggregatorType);
        this.getEntityManager().persist((Object)aggregatedIntervalConfig);
        return aggregatedIntervalConfig;
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public void updateAggregatedIntervalConfig(AggregatedIntervalConfig aggregatedIntervalConfig) {
        this.getEntityManager().persist((Object)aggregatedIntervalConfig);
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public void deleteAggregatedIntervalConfig(AggregatedIntervalConfig aggregatedIntervalConfig) {
        this.getEntityManager().remove((Object)aggregatedIntervalConfig);
    }

    public List<QuarterDetail> getQuartersDetails() {
        TypedQuery query = this.createCachedQuery(this.findAllQuarterDetailsQuery);
        List results = query.getResultList();
        if (results.size() == 4) {
            return new ArrayList<QuarterDetail>(results);
        }
        return (List)this.getTransactionOperations().execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public void setQuarterDetails(List<QuarterDetail> newQuarterDetails) {
        newQuarterDetails = EventDateTimeUtils.validateQuarters(newQuarterDetails);
        TypedQuery query = this.createCachedQuery(this.findAllQuarterDetailsQuery);
        HashSet existingQuarterDetails = new HashSet(query.getResultList());
        Iterator newQuarterDetailsItr = newQuarterDetails.iterator();
        while (newQuarterDetailsItr.hasNext()) {
            QuarterDetail quarterDetail = (QuarterDetail)newQuarterDetailsItr.next();
            if (!existingQuarterDetails.remove(quarterDetail)) continue;
            newQuarterDetailsItr.remove();
        }
        EntityManager entityManager = this.getEntityManager();
        for (QuarterDetailImpl existingQuarterDetail : existingQuarterDetails) {
            entityManager.remove((Object)existingQuarterDetail);
        }
        entityManager.flush();
        for (QuarterDetail newQuarterDetail : newQuarterDetails) {
            entityManager.persist((Object)newQuarterDetail);
        }
    }

    public List<AcademicTermDetail> getAcademicTermDetails() {
        TypedQuery query = this.createCachedQuery(this.findAllAcademicTermDetailsQuery);
        return new ArrayList<AcademicTermDetail>(query.getResultList());
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public void setAcademicTermDetails(List<AcademicTermDetail> newAcademicTermDetails) {
        newAcademicTermDetails = EventDateTimeUtils.validateAcademicTerms(newAcademicTermDetails);
        TypedQuery query = this.createCachedQuery(this.findAllAcademicTermDetailsQuery);
        HashSet existingAcademicTermDetails = new HashSet(query.getResultList());
        Iterator newAcademicTermDetailsItr = newAcademicTermDetails.iterator();
        while (newAcademicTermDetailsItr.hasNext()) {
            AcademicTermDetail academicTermDetail = (AcademicTermDetail)newAcademicTermDetailsItr.next();
            if (!existingAcademicTermDetails.remove(academicTermDetail)) continue;
            newAcademicTermDetailsItr.remove();
        }
        EntityManager entityManager = this.getEntityManager();
        for (AcademicTermDetailImpl existingAcademicTermDetail : existingAcademicTermDetails) {
            entityManager.remove((Object)existingAcademicTermDetail);
        }
        entityManager.flush();
        for (AcademicTermDetail newAcademicTermDetail : newAcademicTermDetails) {
            entityManager.persist((Object)newAcademicTermDetail);
        }
    }

    static /* synthetic */ ParameterExpression access$000(JpaEventAggregationManagementDao x0) {
        return x0.aggregatorTypeParameter;
    }

    static /* synthetic */ EntityManager access$100(JpaEventAggregationManagementDao x0) {
        return x0.getEntityManager();
    }

    static /* synthetic */ Class access$200() {
        return DEFAULT_AGGREGATOR_TYPE;
    }
}

