/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.dao.jpa;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Type;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.login.LoginAggregationImpl;
import org.joda.time.LocalTime;

@Entity
@Table(name="UP_TIME_DIMENSION")
@SequenceGenerator(name="UP_TIME_DIMENSION_GEN", sequenceName="UP_TIME_DIMENSION_SEQ", allocationSize=1)
@TableGenerator(name="UP_TIME_DIMENSION_GEN", pkColumnValue="UP_TIME_DIMENSION_PROP", allocationSize=1)
@Immutable
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
public final class TimeDimensionImpl
implements TimeDimension,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_TIME_DIMENSION_GEN")
    @Column(name="TIME_ID")
    private final long id;
    @NaturalId
    @Column(name="TD_TIME", nullable=false)
    @Type(type="localTime")
    private final LocalTime time;
    @Index(name="IDX_UP_TD_HOUR")
    @Column(name="TD_HOUR", nullable=false)
    private final int hour;
    @Index(name="IDX_UP_TD_FIVE_MIN_INCR")
    @Column(name="TD_FIVE_MINUTE_INCREMENT", nullable=false)
    private final int fiveMinuteIncrement;
    @Index(name="IDX_UP_TD_MINUTE")
    @Column(name="TD_MINUTE", nullable=false)
    private final int minute;
    @OneToMany(mappedBy="timeDimension", fetch=FetchType.LAZY)
    private Collection<LoginAggregationImpl> loginAggregations;
    @Transient
    private int hashCode = 0;

    private TimeDimensionImpl() {
        this.id = -1L;
        this.time = null;
        this.hour = -1;
        this.fiveMinuteIncrement = -1;
        this.minute = -1;
    }

    TimeDimensionImpl(LocalTime time) {
        this.id = -1L;
        this.time = time.minuteOfHour().roundFloorCopy();
        this.hour = this.time.getHourOfDay();
        this.minute = this.time.getMinuteOfHour();
        this.fiveMinuteIncrement = this.minute / 5;
    }

    public long getId() {
        return this.id;
    }

    public LocalTime getTime() {
        return this.time;
    }

    public int getHour() {
        return this.hour;
    }

    public int getFiveMinuteIncrement() {
        return this.fiveMinuteIncrement;
    }

    public int getMinute() {
        return this.minute;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            int prime = 31;
            h = 1;
            this.hashCode = h = 31 * h + (this.time == null ? 0 : this.time.hashCode());
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeDimension)) {
            return false;
        }
        TimeDimension other = (TimeDimension)obj;
        return !(this.time == null ? other.getTime() != null : !this.time.equals((Object)other.getTime()));
    }

    public String toString() {
        return this.time.toString();
    }
}

