/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.portletexec;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.JpaBaseAggregationDao;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationImpl;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationImpl_;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationKey;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationPrivateDao;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMapping;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMappingImpl;
import org.jasig.portal.jpa.BaseJpaDao;
import org.springframework.stereotype.Repository;

@Repository
public class JpaPortletExecutionAggregationDao
extends JpaBaseAggregationDao<PortletExecutionAggregationImpl, PortletExecutionAggregationKey>
implements PortletExecutionAggregationPrivateDao {
    private ParameterExpression<Set> portletMappingParameter;
    private ParameterExpression<Set> executionTypeParameter;

    public JpaPortletExecutionAggregationDao() {
        super(PortletExecutionAggregationImpl.class);
    }

    protected void createParameterExpressions() {
        this.portletMappingParameter = this.createParameterExpression(Set.class, "portletMapping");
        this.executionTypeParameter = this.createParameterExpression(Set.class, "executionType");
    }

    protected void addFetches(Root<PortletExecutionAggregationImpl> root) {
        root.fetch(PortletExecutionAggregationImpl_.statisticalSummary, JoinType.LEFT);
    }

    protected void addUnclosedPredicate(CriteriaBuilder cb, Root<PortletExecutionAggregationImpl> root, List<Predicate> keyPredicates) {
        keyPredicates.add(cb.isFalse((Expression)root.get(PortletExecutionAggregationImpl_.complete)));
    }

    protected void addAggregationSpecificKeyPredicate(CriteriaBuilder cb, Root<PortletExecutionAggregationImpl> root, List<Predicate> keyPredicates) {
        keyPredicates.add(root.get(PortletExecutionAggregationImpl_.aggregatedPortlet).in(new Expression[]{this.portletMappingParameter}));
        keyPredicates.add(root.get(PortletExecutionAggregationImpl_.executionType).in(new Expression[]{this.executionTypeParameter}));
    }

    protected void bindAggregationSpecificKeyParameters(TypedQuery<PortletExecutionAggregationImpl> query, Set<PortletExecutionAggregationKey> keys) {
        query.setParameter((Parameter)this.portletMappingParameter, (Object)this.extractAggregatePortletMappings(keys));
        query.setParameter((Parameter)this.executionTypeParameter, (Object)this.extractExecutionTypes(keys));
    }

    private Set<AggregatedPortletMapping> extractAggregatePortletMappings(Set<PortletExecutionAggregationKey> keys) {
        HashSet<AggregatedPortletMapping> portletMappings = new HashSet<AggregatedPortletMapping>();
        for (PortletExecutionAggregationKey key : keys) {
            portletMappings.add(key.getPortletMapping());
        }
        return portletMappings;
    }

    private Set<PortletExecutionAggregationKey.ExecutionType> extractExecutionTypes(Set<PortletExecutionAggregationKey> keys) {
        EnumSet<PortletExecutionAggregationKey.ExecutionType> executionTypes = EnumSet.noneOf(PortletExecutionAggregationKey.ExecutionType.class);
        for (PortletExecutionAggregationKey key : keys) {
            executionTypes.add(key.getExecutionType());
        }
        return executionTypes;
    }

    protected void bindAggregationSpecificKeyParameters(BaseJpaDao.NaturalIdQuery<PortletExecutionAggregationImpl> query, PortletExecutionAggregationKey key) {
        query.using((Attribute)PortletExecutionAggregationImpl_.aggregatedPortlet, (Object)((AggregatedPortletMappingImpl)key.getPortletMapping()));
        query.using((Attribute)PortletExecutionAggregationImpl_.executionType, (Object)key.getExecutionType());
    }

    protected PortletExecutionAggregationImpl createAggregationInstance(PortletExecutionAggregationKey key) {
        TimeDimension timeDimension = key.getTimeDimension();
        DateDimension dateDimension = key.getDateDimension();
        AggregationInterval interval = key.getInterval();
        AggregatedGroupMapping aggregatedGroup = key.getAggregatedGroup();
        AggregatedPortletMapping portletMapping = key.getPortletMapping();
        PortletExecutionAggregationKey.ExecutionType executionType = key.getExecutionType();
        return new PortletExecutionAggregationImpl(timeDimension, dateDimension, interval, aggregatedGroup, portletMapping, executionType);
    }

    protected PortletExecutionAggregationKey getAggregationKey(PortletExecutionAggregationImpl instance) {
        return instance.getAggregationKey();
    }
}

