/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.session;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMappingImpl;
import org.jasig.portal.events.aggr.session.EventSession;
import org.joda.time.DateTime;

@Entity
@javax.persistence.Table(name="UP_EVENT_SESSION")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="UP_EVENT_SESSION_GEN", sequenceName="UP_EVENT_SESSION_SEQ", allocationSize=100)
@TableGenerator(name="UP_EVENT_SESSION_GEN", pkColumnValue="UP_EVENT_SESSION_PROP", allocationSize=100)
@Table(appliesTo="UP_EVENT_SESSION", indexes={@Index(name="IDX_UP_EVENT_SESSION_DATE", columnNames={"LAST_ACCESSED"})})
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class EventSessionImpl
implements EventSession,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_EVENT_SESSION_GEN")
    @Column(name="ID")
    private final long id;
    @NaturalId
    @Column(name="SESSION_ID", length=500, nullable=false, updatable=false)
    private final String eventSessionId;
    @ManyToMany(targetEntity=AggregatedGroupMappingImpl.class, fetch=FetchType.EAGER)
    @JoinTable(name="UP_EVENT_SESSION_GROUPS", inverseJoinColumns={@JoinColumn(name="GROUP_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private final Set<AggregatedGroupMapping> groupMappings;
    @Column(name="LAST_ACCESSED", nullable=false)
    @Type(type="dateTime")
    private DateTime lastAccessed;
    @Transient
    private Set<AggregatedGroupMapping> unmodifiableGroupMappings;

    private EventSessionImpl() {
        this.id = -1L;
        this.eventSessionId = null;
        this.groupMappings = null;
    }

    EventSessionImpl(String eventSessionId, DateTime eventDate, Set<AggregatedGroupMapping> groupMappings) {
        Validate.notNull((Object)eventSessionId);
        Validate.notNull(groupMappings);
        this.id = -1L;
        this.eventSessionId = eventSessionId;
        this.groupMappings = groupMappings;
        this.lastAccessed = eventDate;
    }

    public void recordAccess(DateTime eventDate) {
        this.lastAccessed = eventDate;
    }

    public String getEventSessionId() {
        return this.eventSessionId;
    }

    public Set<AggregatedGroupMapping> getGroupMappings() {
        Set ugm = this.unmodifiableGroupMappings;
        if (ugm == null) {
            this.unmodifiableGroupMappings = ugm = Collections.unmodifiableSet(this.groupMappings);
        }
        return ugm;
    }

    public void addGroupMappings(Set<AggregatedGroupMapping> groupMappings) {
        this.groupMappings.addAll(groupMappings);
        this.unmodifiableGroupMappings = null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventSessionId == null ? 0 : this.eventSessionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventSessionImpl other = (EventSessionImpl)obj;
        return !(this.eventSessionId == null ? other.eventSessionId != null : !this.eventSessionId.equals(other.eventSessionId));
    }

    public String toString() {
        return "EventSessionImpl [id=" + this.id + ", eventSessionId=" + this.eventSessionId + ", lastAccessed=" + this.lastAccessed + "]";
    }
}

