/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.tabrender;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.JpaBaseAggregationDao;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationImpl;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationImpl_;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationKey;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationPrivateDao;
import org.jasig.portal.events.aggr.tabs.AggregatedTabMapping;
import org.jasig.portal.events.aggr.tabs.AggregatedTabMappingImpl;
import org.jasig.portal.jpa.BaseJpaDao;
import org.springframework.stereotype.Repository;

@Repository
public class JpaTabRenderAggregationDao
extends JpaBaseAggregationDao<TabRenderAggregationImpl, TabRenderAggregationKey>
implements TabRenderAggregationPrivateDao {
    private ParameterExpression<Set> tabMappingParameter;

    public JpaTabRenderAggregationDao() {
        super(TabRenderAggregationImpl.class);
    }

    protected void createParameterExpressions() {
        this.tabMappingParameter = this.createParameterExpression(Set.class, "tabMapping");
    }

    protected void addFetches(Root<TabRenderAggregationImpl> root) {
        root.fetch(TabRenderAggregationImpl_.statisticalSummary, JoinType.LEFT);
    }

    protected void addUnclosedPredicate(CriteriaBuilder cb, Root<TabRenderAggregationImpl> root, List<Predicate> keyPredicates) {
        keyPredicates.add(cb.isFalse((Expression)root.get(TabRenderAggregationImpl_.complete)));
    }

    protected void addAggregationSpecificKeyPredicate(CriteriaBuilder cb, Root<TabRenderAggregationImpl> root, List<Predicate> keyPredicates) {
        keyPredicates.add(root.get(TabRenderAggregationImpl_.aggregatedTab).in(new Expression[]{this.tabMappingParameter}));
    }

    protected void bindAggregationSpecificKeyParameters(TypedQuery<TabRenderAggregationImpl> query, Set<TabRenderAggregationKey> keys) {
        query.setParameter((Parameter)this.tabMappingParameter, (Object)this.extractAggregateTabMappings(keys));
    }

    private Set<AggregatedTabMapping> extractAggregateTabMappings(Set<TabRenderAggregationKey> keys) {
        HashSet<AggregatedTabMapping> portletMappings = new HashSet<AggregatedTabMapping>();
        for (TabRenderAggregationKey key : keys) {
            portletMappings.add(key.getTabMapping());
        }
        return portletMappings;
    }

    protected void bindAggregationSpecificKeyParameters(BaseJpaDao.NaturalIdQuery<TabRenderAggregationImpl> query, TabRenderAggregationKey key) {
        query.using((Attribute)TabRenderAggregationImpl_.aggregatedTab, (Object)((AggregatedTabMappingImpl)key.getTabMapping()));
    }

    protected TabRenderAggregationImpl createAggregationInstance(TabRenderAggregationKey key) {
        TimeDimension timeDimension = key.getTimeDimension();
        DateDimension dateDimension = key.getDateDimension();
        AggregationInterval interval = key.getInterval();
        AggregatedGroupMapping aggregatedGroup = key.getAggregatedGroup();
        AggregatedTabMapping tabMapping = key.getTabMapping();
        return new TabRenderAggregationImpl(timeDimension, dateDimension, interval, aggregatedGroup, tabMapping);
    }

    protected TabRenderAggregationKey getAggregationKey(TabRenderAggregationImpl instance) {
        return instance.getAggregationKey();
    }
}

