/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.handlers.db;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import org.hibernate.FlushMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.jasig.portal.concurrency.FunctionWithoutResult;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.handlers.db.IPortalEventDao;
import org.jasig.portal.events.handlers.db.PersistentPortalEvent;
import org.jasig.portal.events.handlers.db.PersistentPortalEvent_;
import org.jasig.portal.jpa.BaseRawEventsJpaDao;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;

@Repository
public class JpaPortalEventStore
extends BaseRawEventsJpaDao
implements IPortalEventDao {
    private ObjectMapper mapper;
    private String deleteQuery;
    private String selectQuery;
    private String selectUnaggregatedQuery;
    private int flushPeriod = 1000;
    private CriteriaQuery<DateTime> findNewestPersistentPortalEventTimestampQuery;
    private CriteriaQuery<DateTime> findOldestPersistentPortalEventTimestampQuery;
    private ParameterExpression<DateTime> startTimeParameter;
    private ParameterExpression<DateTime> endTimeParameter;

    @Autowired
    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Value(value="${org.jasig.portal.events.handlers.db.JpaPortalEventStore.aggregationFlushPeriod:1000}")
    public void setAggregationFlushPeriod(int flushPeriod) {
        this.flushPeriod = flushPeriod;
    }

    public void afterPropertiesSet() throws Exception {
        this.startTimeParameter = this.createParameterExpression(DateTime.class, "startTime");
        this.endTimeParameter = this.createParameterExpression(DateTime.class, "endTime");
        this.selectQuery = "SELECT e FROM " + PersistentPortalEvent.class.getName() + " e " + "WHERE e." + PersistentPortalEvent_.timestamp.getName() + " >= :" + this.startTimeParameter.getName() + " " + "AND e." + PersistentPortalEvent_.timestamp.getName() + " < :" + this.endTimeParameter.getName() + " " + "ORDER BY e." + PersistentPortalEvent_.timestamp.getName() + " ASC";
        this.selectUnaggregatedQuery = "SELECT e FROM " + PersistentPortalEvent.class.getName() + " e " + "WHERE e." + PersistentPortalEvent_.timestamp.getName() + " >= :" + this.startTimeParameter.getName() + " " + "AND e." + PersistentPortalEvent_.timestamp.getName() + " < :" + this.endTimeParameter.getName() + " " + "AND (e." + PersistentPortalEvent_.aggregated.getName() + " is null OR e." + PersistentPortalEvent_.aggregated.getName() + " = false) " + "ORDER BY e." + PersistentPortalEvent_.timestamp.getName() + " ASC";
        this.deleteQuery = "DELETE FROM " + PersistentPortalEvent.class.getName() + " e " + "WHERE e." + PersistentPortalEvent_.timestamp.getName() + " < :" + this.endTimeParameter.getName();
        this.findNewestPersistentPortalEventTimestampQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findOldestPersistentPortalEventTimestampQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    @BaseRawEventsJpaDao.RawEventsTransactional
    public void storePortalEvent(PortalEvent portalEvent) {
        PersistentPortalEvent persistentPortalEvent = this.wrapPortalEvent(portalEvent);
        this.getEntityManager().persist((Object)persistentPortalEvent);
    }

    @BaseRawEventsJpaDao.RawEventsTransactional
    public void storePortalEvents(PortalEvent ... portalEvents) {
        for (PortalEvent portalEvent : portalEvents) {
            try {
                this.storePortalEvent(portalEvent);
            }
            catch (IllegalArgumentException iae) {
                this.logger.warn(portalEvent.getClass().getName() + " is not mapped as a persistent entity and will not be stored. " + portalEvent + " Exception=" + iae.getMessage());
            }
        }
    }

    @BaseRawEventsJpaDao.RawEventsTransactional
    public void storePortalEvents(Iterable<PortalEvent> portalEvents) {
        for (PortalEvent portalEvent : portalEvents) {
            try {
                this.storePortalEvent(portalEvent);
            }
            catch (IllegalArgumentException iae) {
                this.logger.warn(portalEvent.getClass().getName() + " is not mapped as a persistent entity and will not be stored. " + portalEvent + " Exception=" + iae.getMessage());
            }
        }
    }

    public DateTime getOldestPortalEventTimestamp() {
        TypedQuery query = this.createQuery(this.findOldestPersistentPortalEventTimestampQuery);
        List results = query.getResultList();
        return (DateTime)DataAccessUtils.uniqueResult((Collection)results);
    }

    public DateTime getNewestPortalEventTimestamp() {
        TypedQuery query = this.createQuery(this.findNewestPersistentPortalEventTimestampQuery);
        List results = query.getResultList();
        return (DateTime)DataAccessUtils.uniqueResult((Collection)results);
    }

    @BaseRawEventsJpaDao.RawEventsTransactional
    public boolean aggregatePortalEvents(DateTime startTime, DateTime endTime, int maxEvents, Function<PortalEvent, Boolean> handler) {
        Session session = (Session)this.getEntityManager().unwrap(Session.class);
        session.setFlushMode(FlushMode.COMMIT);
        org.hibernate.Query query = session.createQuery(this.selectUnaggregatedQuery);
        query.setParameter(this.startTimeParameter.getName(), (Object)startTime);
        query.setParameter(this.endTimeParameter.getName(), (Object)endTime);
        if (maxEvents > 0) {
            query.setMaxResults(maxEvents);
        }
        int resultCount = 0;
        ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);
        while (results.next()) {
            PortalEvent portalEvent;
            PersistentPortalEvent persistentPortalEvent = (PersistentPortalEvent)results.get(0);
            try {
                portalEvent = this.toPortalEvent(persistentPortalEvent.getEventData(), persistentPortalEvent.getEventType());
            }
            catch (RuntimeException e) {
                this.logger.warn("Failed to convert PersistentPortalEvent to PortalEvent: " + persistentPortalEvent, (Throwable)e);
                persistentPortalEvent.setAggregated(true);
                session.persist((Object)persistentPortalEvent);
                continue;
            }
            Boolean eventHandled = (Boolean)handler.apply((Object)portalEvent);
            if (!eventHandled.booleanValue()) {
                this.logger.debug("Aggregation stop requested before processing event {}", (Object)portalEvent);
                return false;
            }
            persistentPortalEvent.setAggregated(true);
            session.persist((Object)persistentPortalEvent);
            if (++resultCount % this.flushPeriod != 0) continue;
            this.logger.debug("Aggregated {} events, flush and clear {} EntityManager.", (Object)resultCount, (Object)"RawEventsDb");
            session.flush();
            session.clear();
        }
        return true;
    }

    public void getPortalEvents(DateTime startTime, DateTime endTime, FunctionWithoutResult<PortalEvent> handler) {
        this.getPortalEvents(startTime, endTime, -1, handler);
    }

    public void getPortalEvents(DateTime startTime, DateTime endTime, int maxEvents, FunctionWithoutResult<PortalEvent> handler) {
        Session session = (Session)this.getEntityManager().unwrap(Session.class);
        org.hibernate.Query query = session.createQuery(this.selectQuery);
        query.setParameter(this.startTimeParameter.getName(), (Object)startTime);
        query.setParameter(this.endTimeParameter.getName(), (Object)endTime);
        if (maxEvents > 0) {
            query.setMaxResults(maxEvents);
        }
        ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);
        while (results.next()) {
            PersistentPortalEvent persistentPortalEvent = (PersistentPortalEvent)results.get(0);
            PortalEvent portalEvent = this.toPortalEvent(persistentPortalEvent.getEventData(), persistentPortalEvent.getEventType());
            handler.apply((Object)portalEvent);
            persistentPortalEvent.setAggregated(true);
            session.evict((Object)persistentPortalEvent);
        }
    }

    @BaseRawEventsJpaDao.RawEventsTransactional
    public int deletePortalEventsBefore(DateTime time) {
        Query query = this.getEntityManager().createQuery(this.deleteQuery);
        query.setParameter(this.endTimeParameter.getName(), (Object)time);
        return query.executeUpdate();
    }

    protected PersistentPortalEvent wrapPortalEvent(PortalEvent event) {
        String portalEventData = this.toString(event);
        return new PersistentPortalEvent(event, portalEventData);
    }

    protected <E extends PortalEvent> E toPortalEvent(String eventData, Class<E> eventType) {
        try {
            return (E)((PortalEvent)this.mapper.readValue(eventData, eventType));
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Failed to deserialize PortalEvent data", e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException("Failed to deserialize PortalEvent data", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize PortalEvent data", e);
        }
    }

    protected String toString(PortalEvent event) {
        try {
            return this.mapper.writeValueAsString((Object)event);
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Failed to serialize PortalEvent data", e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException("Failed to serialize PortalEvent data", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize PortalEvent data", e);
        }
    }
}

