/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.fragment.subscribe.dao.jpa;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalId;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.fragment.subscribe.IUserFragmentSubscription;
import org.jasig.portal.security.IPerson;

@Entity
@Table(name="UP_USER_FRAGMENT_SUBSCRIPTION")
@SequenceGenerator(name="UP_USER_FRAGMENT_SUBSCRIPTION_GEN", sequenceName="UP_USER_FRAGMENT_SUB_SEQ", allocationSize=10)
@TableGenerator(name="UP_USER_FRAGMENT_SUBSCRIPTION_GEN", pkColumnValue="UP_USER_FRAGMENT_SUBSCRIPTION", allocationSize=10)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class UserFragmentSubscriptionImpl
implements IUserFragmentSubscription {
    @Id
    @GeneratedValue(generator="UP_USER_FRAGMENT_SUBSCRIPTION_GEN")
    @Column(name="USER_FRAGMENT_SUBSCRIPTION_ID")
    private final long userFragmentInfoId;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @NaturalId
    @Column(name="USER_ID", updatable=false, nullable=false)
    @Index(name="IDX_USER_FRAG__USER", columnNames={"USER_ID"})
    private final int userId;
    @NaturalId
    @Column(name="FRAGMENT_OWNER", updatable=false, nullable=false)
    private final String fragmentOwner;
    @Column(name="ACTIVE", updatable=true, nullable=false)
    private boolean active;
    @Column(name="CREATED_BY", updatable=false, nullable=false)
    private String createdBy;
    @Column(name="CREATION_DATE", updatable=false, nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar creationDate;
    @Column(name="LAST_UPDATED_DATE", updatable=true, nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar lastUpdatedDate;
    @Transient
    private EntityIdentifier entityIdentifier = new EntityIdentifier(null, IUserFragmentSubscription.class);

    private UserFragmentSubscriptionImpl() {
        this.userFragmentInfoId = -1L;
        this.entityVersion = -1L;
        this.active = false;
        this.userId = -1;
        this.fragmentOwner = "";
        this.createdBy = "";
    }

    public UserFragmentSubscriptionImpl(IPerson person, IPerson fragmentOwner) {
        this.userFragmentInfoId = -1L;
        this.entityVersion = -1L;
        this.active = true;
        this.fragmentOwner = fragmentOwner.getUserName();
        this.entityIdentifier = new EntityIdentifier(String.valueOf(this.fragmentOwner), IUserFragmentSubscription.class);
        this.userId = person.getID();
        this.createdBy = person.getUserName();
    }

    public int getUserId() {
        return this.userId;
    }

    public String getFragmentOwner() {
        return this.fragmentOwner;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public Calendar getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public long getId() {
        return this.userFragmentInfoId;
    }

    @PreUpdate
    private void setLastUpdatedDate() {
        this.lastUpdatedDate = new GregorianCalendar();
    }

    @PrePersist
    private void setCreationDate() {
        this.creationDate = new GregorianCalendar();
    }

    public void setInactive() {
        this.active = false;
    }

    public EntityIdentifier getEntityIdentifier() {
        return this.entityIdentifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fragmentOwner == null ? 0 : this.fragmentOwner.hashCode());
        result = 31 * result + (int)(this.userFragmentInfoId ^ this.userFragmentInfoId >>> 32);
        result = 31 * result + this.userId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserFragmentSubscriptionImpl)) {
            return false;
        }
        UserFragmentSubscriptionImpl other = (UserFragmentSubscriptionImpl)obj;
        if (this.fragmentOwner == null ? other.fragmentOwner != null : !this.fragmentOwner.equals(other.fragmentOwner)) {
            return false;
        }
        if (this.userFragmentInfoId != other.userFragmentInfoId) {
            return false;
        }
        return this.userId == other.userId;
    }

    public String toString() {
        return "UserFragmentSubscriptionImpl [userFragmentInfoId=" + this.userFragmentInfoId + ", entityVersion=" + this.entityVersion + ", userId=" + this.userId + ", fragmentOwner=" + this.fragmentOwner + ", active=" + this.active + ", createdBy=" + this.createdBy + ", creationDate=" + this.creationDate + ", lastUpdatedDate=" + this.lastUpdatedDate + ", entityIdentifier=" + this.entityIdentifier + "]";
    }
}

