/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.groups.IEntityNameFinder;
import org.jasig.portal.groups.PersonDirNameFinderFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;

public class PersonDirNameFinder
implements IEntityNameFinder {
    private IPersonAttributeDao paDao;
    private Map<String, String> names = new ReferenceMap(0, 1, true);

    PersonDirNameFinder(IPersonAttributeDao pa) {
        this.paDao = pa;
    }

    public String getName(String key) {
        String name = (String)this.names.get(key);
        if (name == null && key != null) {
            name = this.primGetName(key);
            this.names.put(key, name);
        }
        return name;
    }

    public Map<String, String> getNames(String[] keys) {
        HashMap<String, String> selectedNames = new HashMap<String, String>();
        for (int i = 0; i < keys.length; ++i) {
            String name = this.getName(keys[i]);
            selectedNames.put(keys[i], name);
        }
        return selectedNames;
    }

    public Class<IPerson> getType() {
        return IPerson.class;
    }

    private String primGetName(String key) {
        String name = key;
        IPersonAttributes personAttributes = this.paDao.getPerson(name);
        if (personAttributes != null) {
            Object displayName = personAttributes.getAttributeValue("displayName");
            String displayNameStr = "";
            if (displayName != null && StringUtils.isNotEmpty((String)(displayNameStr = String.valueOf(displayName)))) {
                name = displayNameStr;
            }
        }
        return name;
    }

    @Deprecated
    public static IEntityNameFinder singleton() {
        return new PersonDirNameFinderFactory().newFinder();
    }

    public String toString() {
        return "PersonDirNameFinder backed by " + this.paDao;
    }
}

