/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.groups.EntityGroupImpl;
import org.jasig.portal.groups.GroupServiceConfiguration;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityGroupStore;
import org.jasig.portal.groups.IGroupConstants;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.groups.LockableEntityGroupImpl;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.spring.locator.CounterStoreLocator;
import org.jasig.portal.utils.SqlTransaction;

/*
 * Exception performing whole class analysis ignored.
 */
public class RDBMEntityGroupStore
implements IEntityGroupStore,
IGroupConstants {
    private static final Log log = LogFactory.getLog(RDBMEntityGroupStore.class);
    private static RDBMEntityGroupStore singleton;
    private static String EQ;
    private static String QUOTE;
    private static String EQUALS_PARAM;
    private static String GROUP_TABLE;
    private static String GROUP_TABLE_ALIAS;
    private static String GROUP_TABLE_WITH_ALIAS;
    private static String GROUP_ID_COLUMN;
    private static String GROUP_CREATOR_COLUMN;
    private static String GROUP_TYPE_COLUMN;
    private static String GROUP_NAME_COLUMN;
    private static String GROUP_DESCRIPTION_COLUMN;
    private static String allGroupColumns;
    private static String allGroupColumnsWithTableAlias;
    private static String countAMemberGroupSql;
    private static String countMemberGroupsNamedSql;
    private static String countAMemberEntitySql;
    private static String findContainingGroupsForEntitySql;
    private static String findContainingGroupsForGroupSql;
    private static String findGroupSql;
    private static String findGroupsByCreatorSql;
    private static String findMemberGroupKeysSql;
    private static String findMemberGroupsSql;
    private static String insertGroupSql;
    private static String updateGroupSql;
    private static String MEMBER_TABLE;
    private static String MEMBER_TABLE_ALIAS;
    private static String MEMBER_TABLE_WITH_ALIAS;
    private static String MEMBER_GROUP_ID_COLUMN;
    private static String MEMBER_MEMBER_SERVICE_COLUMN;
    private static String MEMBER_MEMBER_KEY_COLUMN;
    private static String MEMBER_IS_GROUP_COLUMN;
    private static String MEMBER_IS_ENTITY;
    private static String MEMBER_IS_GROUP;
    private static String GROUP_NODE_SEPARATOR;
    private static String allMemberColumns;
    private static String deleteMembersInGroupSql;
    private static String deleteMemberGroupSql;
    private static String deleteMemberEntitySql;
    private static String insertMemberSql;
    private static String searchGroupsPartial;
    private static String searchGroups;

    public RDBMEntityGroupStore() {
        this.initialize();
    }

    private void initialize() {
        String sep;
        try {
            sep = GroupServiceConfiguration.getConfiguration().getNodeSeparator();
        }
        catch (Exception ex) {
            sep = ".";
        }
        GROUP_NODE_SEPARATOR = sep;
        if (log.isDebugEnabled()) {
            log.debug((Object)("RDBMEntityGroupStore.initialize(): Node separator set to " + sep));
        }
    }

    protected static void commit(Connection conn) throws SQLException {
        SqlTransaction.commit((Connection)conn);
    }

    public boolean contains(IEntityGroup group, IGroupMember member) throws GroupsException {
        return member.isGroup() ? this.containsGroup(group, (IEntityGroup)member) : this.containsEntity(group, member);
    }

    /*
     * Exception decompiling
     */
    private boolean containsEntity(IEntityGroup group, IGroupMember member) throws GroupsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean containsGroup(IEntityGroup group, IEntityGroup member) throws GroupsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean containsGroupNamed(IEntityGroup containingGroup, String memberName) throws GroupsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void delete(IEntityGroup group) throws GroupsException {
        if (this.existsInDatabase(group)) {
            try {
                this.primDelete(group);
            }
            catch (SQLException sqle) {
                throw new GroupsException("Problem deleting " + group, (Throwable)sqle);
            }
        }
    }

    private boolean existsInDatabase(IEntityGroup group) throws GroupsException {
        IEntityGroup ug = this.find(group.getLocalKey());
        return ug != null;
    }

    public IEntityGroup find(String groupID) throws GroupsException {
        return this.primFind(groupID, false);
    }

    public Iterator findContainingGroups(IEntity ent) throws GroupsException {
        String memberKey = ent.getKey();
        Integer type = EntityTypes.getEntityTypeID((Class)ent.getLeafType());
        return this.findContainingGroupsForEntity(memberKey, type.intValue());
    }

    public Iterator findContainingGroups(IEntityGroup group) throws GroupsException {
        String memberKey = group.getLocalKey();
        String serviceName = group.getServiceName().toString();
        Integer type = EntityTypes.getEntityTypeID((Class)group.getLeafType());
        return this.findContainingGroupsForGroup(serviceName, memberKey, type.intValue());
    }

    public Iterator findContainingGroups(IGroupMember gm) throws GroupsException {
        if (gm.isGroup()) {
            IEntityGroup group = (IEntityGroup)gm;
            return this.findContainingGroups(group);
        }
        IEntity ent = (IEntity)gm;
        return this.findContainingGroups(ent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator findContainingGroupsForEntity(String memberKey, int type) throws GroupsException {
        Connection conn = null;
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>();
        IEntityGroup eg = null;
        try {
            conn = RDBMServices.getConnection();
            String sql = RDBMEntityGroupStore.getFindContainingGroupsForEntitySql();
            PreparedStatement ps = conn.prepareStatement(sql);
            try {
                ps.setString(1, memberKey);
                ps.setInt(2, type);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMEntityGroupStore.findContainingGroupsForEntity(): " + ps + " (" + memberKey + ", " + type + ", memberIsGroup = F)"));
                }
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        eg = this.instanceFromResultSet(rs);
                        groups.add(eg);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                ps.close();
            }
        }
        catch (Exception e) {
            log.error((Object)("RDBMEntityGroupStore.findContainingGroupsForEntity(): " + e));
            throw new GroupsException("Problem retrieving containing groups: " + e);
        }
        finally {
            RDBMServices.releaseConnection((Connection)conn);
        }
        return groups.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator findContainingGroupsForGroup(String serviceName, String memberKey, int type) throws GroupsException {
        Connection conn = null;
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>();
        IEntityGroup eg = null;
        try {
            conn = RDBMServices.getConnection();
            String sql = RDBMEntityGroupStore.getFindContainingGroupsForGroupSql();
            PreparedStatement ps = conn.prepareStatement(sql);
            try {
                ps.setString(1, serviceName);
                ps.setString(2, memberKey);
                ps.setInt(3, type);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMEntityGroupStore.findContainingGroupsForGroup(): " + ps + " (" + serviceName + ", " + memberKey + ", " + type + ", memberIsGroup = T)"));
                }
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        eg = this.instanceFromResultSet(rs);
                        groups.add(eg);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                ps.close();
            }
        }
        catch (Exception e) {
            log.error((Object)("RDBMEntityGroupStore.findContainingGroupsForGroup(): " + e));
            throw new GroupsException("Problem retrieving containing groups: " + e);
        }
        finally {
            RDBMServices.releaseConnection((Connection)conn);
        }
        return groups.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator findEntitiesForGroup(IEntityGroup group) throws GroupsException {
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        Connection conn = null;
        String groupID = group.getLocalKey();
        Class cls = group.getLeafType();
        try {
            conn = RDBMServices.getConnection();
            Statement stmnt = conn.createStatement();
            try {
                String query = "SELECT " + MEMBER_MEMBER_KEY_COLUMN + " FROM " + MEMBER_TABLE + " WHERE " + MEMBER_GROUP_ID_COLUMN + " = '" + groupID + "' AND " + MEMBER_IS_GROUP_COLUMN + " = '" + MEMBER_IS_ENTITY + "'";
                ResultSet rs = stmnt.executeQuery(query);
                try {
                    while (rs.next()) {
                        String key = rs.getString(1);
                        IEntity e = this.newEntity(cls, key);
                        entities.add(e);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmnt.close();
            }
        }
        catch (SQLException sqle) {
            log.error((Object)("Problem retrieving Entities for Group: " + group), (Throwable)sqle);
            throw new GroupsException("Problem retrieving Entities for Group", (Throwable)sqle);
        }
        finally {
            RDBMServices.releaseConnection((Connection)conn);
        }
        return entities.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator findGroupsByCreator(String creatorID) throws GroupsException {
        Connection conn = null;
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>();
        IEntityGroup eg = null;
        try {
            conn = RDBMServices.getConnection();
            String sql = RDBMEntityGroupStore.getFindGroupsByCreatorSql();
            PreparedStatement ps = conn.prepareStatement(sql);
            try {
                ps.setString(1, creatorID);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMEntityGroupStore.findGroupsByCreator(): " + ps));
                }
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        eg = this.instanceFromResultSet(rs);
                        groups.add(eg);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                ps.close();
            }
        }
        catch (Exception e) {
            log.error((Object)("RDBMEntityGroupStore.findGroupsByCreator(): " + e));
            throw new GroupsException("Problem retrieving groups: " + e);
        }
        finally {
            RDBMServices.releaseConnection((Connection)conn);
        }
        return groups.iterator();
    }

    public ILockableEntityGroup findLockable(String groupID) throws GroupsException {
        return (ILockableEntityGroup)this.primFind(groupID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findMemberGroupKeys(IEntityGroup group) throws GroupsException {
        Connection conn = null;
        ArrayList<String> groupKeys = new ArrayList<String>();
        String groupKey = null;
        try {
            conn = RDBMServices.getConnection();
            String sql = RDBMEntityGroupStore.getFindMemberGroupKeysSql();
            PreparedStatement ps = conn.prepareStatement(sql);
            try {
                ps.setString(1, group.getLocalKey());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMEntityGroupStore.findMemberGroupKeys(): " + ps + " (" + group.getLocalKey() + ")"));
                }
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        groupKey = rs.getString(1) + GROUP_NODE_SEPARATOR + rs.getString(2);
                        groupKeys.add(groupKey);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                ps.close();
            }
        }
        catch (Exception sqle) {
            log.error((Object)("RDBMEntityGroupStore.findMemberGroupKeys(): " + sqle));
            throw new GroupsException("Problem retrieving member group keys: " + sqle);
        }
        finally {
            RDBMServices.releaseConnection((Connection)conn);
        }
        return groupKeys.toArray(new String[groupKeys.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator findMemberGroups(IEntityGroup group) throws GroupsException {
        Connection conn = null;
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>();
        IEntityGroup eg = null;
        String serviceName = group.getServiceName().toString();
        String localKey = group.getLocalKey();
        try {
            conn = RDBMServices.getConnection();
            String sql = RDBMEntityGroupStore.getFindMemberGroupsSql();
            PreparedStatement ps = conn.prepareStatement(sql);
            try {
                ps.setString(1, localKey);
                ps.setString(2, serviceName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMEntityGroupStore.findMemberGroups(): " + ps + " (" + localKey + ", " + serviceName + ")"));
                }
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        eg = this.instanceFromResultSet(rs);
                        groups.add(eg);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                ps.close();
            }
        }
        catch (Exception sqle) {
            log.error((Object)("RDBMEntityGroupStore.findMemberGroups(): " + sqle));
            throw new GroupsException("Problem retrieving member groups: " + sqle);
        }
        finally {
            RDBMServices.releaseConnection((Connection)conn);
        }
        return groups.iterator();
    }

    private static String getAllGroupColumns() {
        if (allGroupColumns == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append(GROUP_ID_COLUMN);
            buff.append(", ");
            buff.append(GROUP_CREATOR_COLUMN);
            buff.append(", ");
            buff.append(GROUP_TYPE_COLUMN);
            buff.append(", ");
            buff.append(GROUP_NAME_COLUMN);
            buff.append(", ");
            buff.append(GROUP_DESCRIPTION_COLUMN);
            allGroupColumns = buff.toString();
        }
        return allGroupColumns;
    }

    private static String getAllGroupColumnsWithTableAlias() {
        if (allGroupColumnsWithTableAlias == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append(RDBMEntityGroupStore.groupAlias((String)GROUP_ID_COLUMN));
            buff.append(", ");
            buff.append(RDBMEntityGroupStore.groupAlias((String)GROUP_CREATOR_COLUMN));
            buff.append(", ");
            buff.append(RDBMEntityGroupStore.groupAlias((String)GROUP_TYPE_COLUMN));
            buff.append(", ");
            buff.append(RDBMEntityGroupStore.groupAlias((String)GROUP_NAME_COLUMN));
            buff.append(", ");
            buff.append(RDBMEntityGroupStore.groupAlias((String)GROUP_DESCRIPTION_COLUMN));
            allGroupColumnsWithTableAlias = buff.toString();
        }
        return allGroupColumnsWithTableAlias;
    }

    private static String getAllMemberColumns() {
        if (allMemberColumns == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append(MEMBER_GROUP_ID_COLUMN);
            buff.append(", ");
            buff.append(MEMBER_MEMBER_SERVICE_COLUMN);
            buff.append(", ");
            buff.append(MEMBER_MEMBER_KEY_COLUMN);
            buff.append(", ");
            buff.append(MEMBER_IS_GROUP_COLUMN);
            allMemberColumns = buff.toString();
        }
        return allMemberColumns;
    }

    private static String getCountAMemberEntitySql() {
        if (countAMemberEntitySql == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("SELECT COUNT(*) FROM " + MEMBER_TABLE);
            buff.append(" WHERE " + MEMBER_GROUP_ID_COLUMN + EQUALS_PARAM);
            buff.append(" AND " + MEMBER_MEMBER_KEY_COLUMN + EQUALS_PARAM);
            buff.append(" AND " + MEMBER_IS_GROUP_COLUMN + EQ + RDBMEntityGroupStore.sqlQuote((Object)MEMBER_IS_ENTITY));
            countAMemberEntitySql = buff.toString();
        }
        return countAMemberEntitySql;
    }

    private static String getCountAMemberGroupSql() {
        if (countAMemberGroupSql == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("SELECT COUNT(*) FROM " + MEMBER_TABLE);
            buff.append(" WHERE " + MEMBER_GROUP_ID_COLUMN + EQUALS_PARAM);
            buff.append(" AND " + MEMBER_MEMBER_KEY_COLUMN + EQUALS_PARAM);
            buff.append(" AND " + MEMBER_MEMBER_SERVICE_COLUMN + EQUALS_PARAM);
            buff.append(" AND " + MEMBER_IS_GROUP_COLUMN + EQ + RDBMEntityGroupStore.sqlQuote((Object)MEMBER_IS_GROUP));
            countAMemberGroupSql = buff.toString();
        }
        return countAMemberGroupSql;
    }

    private static String getCountMemberGroupsNamedSql() {
        if (countMemberGroupsNamedSql == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("SELECT COUNT (*) FROM ");
            buff.append(GROUP_TABLE_WITH_ALIAS + ", " + MEMBER_TABLE_WITH_ALIAS);
            buff.append(" WHERE " + RDBMEntityGroupStore.groupAlias((String)GROUP_ID_COLUMN) + EQ);
            buff.append(RDBMEntityGroupStore.memberAlias((String)MEMBER_MEMBER_KEY_COLUMN));
            buff.append(" AND " + RDBMEntityGroupStore.memberAlias((String)MEMBER_GROUP_ID_COLUMN) + EQUALS_PARAM);
            buff.append(" AND " + RDBMEntityGroupStore.groupAlias((String)GROUP_NAME_COLUMN) + EQUALS_PARAM);
            buff.append(" AND " + RDBMEntityGroupStore.memberAlias((String)MEMBER_MEMBER_SERVICE_COLUMN) + EQUALS_PARAM);
            countMemberGroupsNamedSql = buff.toString();
        }
        return countMemberGroupsNamedSql;
    }

    private static String getDeleteGroupSql(IEntityGroup group) {
        StringBuffer buff = new StringBuffer(100);
        buff.append("DELETE FROM ");
        buff.append(GROUP_TABLE);
        buff.append(" WHERE ");
        buff.append(GROUP_ID_COLUMN + EQ + RDBMEntityGroupStore.sqlQuote((Object)group.getLocalKey()));
        return buff.toString();
    }

    private static String getDeleteMemberEntitySql() {
        if (deleteMemberEntitySql == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("DELETE FROM ");
            buff.append(MEMBER_TABLE);
            buff.append(" WHERE ");
            buff.append(MEMBER_GROUP_ID_COLUMN + EQUALS_PARAM);
            buff.append(" AND ");
            buff.append(MEMBER_MEMBER_KEY_COLUMN + EQUALS_PARAM);
            buff.append(" AND ");
            buff.append(MEMBER_IS_GROUP_COLUMN + EQ + RDBMEntityGroupStore.sqlQuote((Object)MEMBER_IS_ENTITY));
            deleteMemberEntitySql = buff.toString();
        }
        return deleteMemberEntitySql;
    }

    private static String getDeleteMemberGroupSql() {
        if (deleteMemberGroupSql == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("DELETE FROM ");
            buff.append(MEMBER_TABLE);
            buff.append(" WHERE ");
            buff.append(MEMBER_GROUP_ID_COLUMN + EQUALS_PARAM);
            buff.append(" AND ");
            buff.append(MEMBER_MEMBER_SERVICE_COLUMN + EQUALS_PARAM);
            buff.append(" AND ");
            buff.append(MEMBER_MEMBER_KEY_COLUMN + EQUALS_PARAM);
            buff.append(" AND ");
            buff.append(MEMBER_IS_GROUP_COLUMN + EQ + RDBMEntityGroupStore.sqlQuote((Object)MEMBER_IS_GROUP));
            deleteMemberGroupSql = buff.toString();
        }
        return deleteMemberGroupSql;
    }

    private static String getDeleteMembersInGroupSql() {
        if (deleteMembersInGroupSql == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("DELETE FROM ");
            buff.append(MEMBER_TABLE);
            buff.append(" WHERE ");
            buff.append(GROUP_ID_COLUMN + EQ);
            deleteMembersInGroupSql = buff.toString();
        }
        return deleteMembersInGroupSql;
    }

    private static String getDeleteMembersInGroupSql(IEntityGroup group) {
        return RDBMEntityGroupStore.getDeleteMembersInGroupSql() + RDBMEntityGroupStore.sqlQuote((Object)group.getLocalKey());
    }

    private static String getFindContainingGroupsForEntitySql() {
        if (findContainingGroupsForEntitySql == null) {
            StringBuffer buff = new StringBuffer(500);
            buff.append("SELECT ");
            buff.append(RDBMEntityGroupStore.getAllGroupColumnsWithTableAlias());
            buff.append(" FROM " + GROUP_TABLE_WITH_ALIAS + ", " + MEMBER_TABLE_WITH_ALIAS);
            buff.append(" WHERE ");
            buff.append(RDBMEntityGroupStore.groupAlias((String)GROUP_ID_COLUMN) + EQ);
            buff.append(RDBMEntityGroupStore.memberAlias((String)MEMBER_GROUP_ID_COLUMN));
            buff.append(" AND ");
            buff.append(RDBMEntityGroupStore.memberAlias((String)MEMBER_MEMBER_KEY_COLUMN) + EQUALS_PARAM);
            buff.append(" AND ");
            buff.append(RDBMEntityGroupStore.groupAlias((String)GROUP_TYPE_COLUMN) + EQUALS_PARAM);
            buff.append(" AND ");
            buff.append(RDBMEntityGroupStore.memberAlias((String)MEMBER_IS_GROUP_COLUMN) + EQ + RDBMEntityGroupStore.sqlQuote((Object)MEMBER_IS_ENTITY));
            findContainingGroupsForEntitySql = buff.toString();
        }
        return findContainingGroupsForEntitySql;
    }

    private static String getFindContainingGroupsForGroupSql() {
        if (findContainingGroupsForGroupSql == null) {
            StringBuffer buff = new StringBuffer(500);
            buff.append("SELECT ");
            buff.append(RDBMEntityGroupStore.getAllGroupColumnsWithTableAlias());
            buff.append(" FROM ");
            buff.append(GROUP_TABLE_WITH_ALIAS);
            buff.append(", ");
            buff.append(MEMBER_TABLE_WITH_ALIAS);
            buff.append(" WHERE ");
            buff.append(RDBMEntityGroupStore.groupAlias((String)GROUP_ID_COLUMN) + EQ);
            buff.append(RDBMEntityGroupStore.memberAlias((String)MEMBER_GROUP_ID_COLUMN));
            buff.append(" AND ");
            buff.append(RDBMEntityGroupStore.memberAlias((String)MEMBER_MEMBER_SERVICE_COLUMN) + EQUALS_PARAM);
            buff.append(" AND ");
            buff.append(RDBMEntityGroupStore.memberAlias((String)MEMBER_MEMBER_KEY_COLUMN) + EQUALS_PARAM);
            buff.append(" AND ");
            buff.append(RDBMEntityGroupStore.groupAlias((String)GROUP_TYPE_COLUMN) + EQUALS_PARAM);
            buff.append(" AND ");
            buff.append(RDBMEntityGroupStore.memberAlias((String)MEMBER_IS_GROUP_COLUMN) + EQ + RDBMEntityGroupStore.sqlQuote((Object)MEMBER_IS_GROUP));
            findContainingGroupsForGroupSql = buff.toString();
        }
        return findContainingGroupsForGroupSql;
    }

    private static String getFindGroupsByCreatorSql() {
        if (findGroupsByCreatorSql == null) {
            StringBuffer buff = new StringBuffer(200);
            buff.append("SELECT ");
            buff.append(RDBMEntityGroupStore.getAllGroupColumns());
            buff.append(" FROM ");
            buff.append(GROUP_TABLE);
            buff.append(" WHERE ");
            buff.append(GROUP_CREATOR_COLUMN + EQUALS_PARAM);
            findGroupsByCreatorSql = buff.toString();
        }
        return findGroupsByCreatorSql;
    }

    private static String getFindGroupSql() {
        if (findGroupSql == null) {
            StringBuffer buff = new StringBuffer(200);
            buff.append("SELECT ");
            buff.append(RDBMEntityGroupStore.getAllGroupColumns());
            buff.append(" FROM ");
            buff.append(GROUP_TABLE);
            buff.append(" WHERE ");
            buff.append(GROUP_ID_COLUMN + EQUALS_PARAM);
            findGroupSql = buff.toString();
        }
        return findGroupSql;
    }

    private static String getFindMemberGroupKeysSql() {
        if (findMemberGroupKeysSql == null) {
            StringBuffer buff = new StringBuffer(200);
            buff.append("SELECT ");
            buff.append(MEMBER_MEMBER_SERVICE_COLUMN + ", " + MEMBER_MEMBER_KEY_COLUMN);
            buff.append(" FROM ");
            buff.append(MEMBER_TABLE);
            buff.append(" WHERE ");
            buff.append(MEMBER_GROUP_ID_COLUMN + EQUALS_PARAM);
            buff.append(" AND ");
            buff.append(MEMBER_IS_GROUP_COLUMN + EQ);
            buff.append(RDBMEntityGroupStore.sqlQuote((Object)MEMBER_IS_GROUP));
            findMemberGroupKeysSql = buff.toString();
        }
        return findMemberGroupKeysSql;
    }

    private static String getFindMemberGroupsSql() {
        if (findMemberGroupsSql == null) {
            StringBuffer buff = new StringBuffer(500);
            buff.append("SELECT ");
            buff.append(RDBMEntityGroupStore.getAllGroupColumnsWithTableAlias());
            buff.append(" FROM ");
            buff.append(GROUP_TABLE + " " + GROUP_TABLE_ALIAS);
            buff.append(", ");
            buff.append(MEMBER_TABLE + " " + MEMBER_TABLE_ALIAS);
            buff.append(" WHERE ");
            buff.append(RDBMEntityGroupStore.groupAlias((String)GROUP_ID_COLUMN) + EQ);
            buff.append(RDBMEntityGroupStore.memberAlias((String)MEMBER_MEMBER_KEY_COLUMN));
            buff.append(" AND ");
            buff.append(RDBMEntityGroupStore.memberAlias((String)MEMBER_IS_GROUP_COLUMN) + EQ);
            buff.append(RDBMEntityGroupStore.sqlQuote((Object)MEMBER_IS_GROUP));
            buff.append(" AND ");
            buff.append(RDBMEntityGroupStore.memberAlias((String)MEMBER_GROUP_ID_COLUMN) + EQUALS_PARAM);
            buff.append(" AND ");
            buff.append(RDBMEntityGroupStore.memberAlias((String)MEMBER_MEMBER_SERVICE_COLUMN) + EQUALS_PARAM);
            findMemberGroupsSql = buff.toString();
        }
        return findMemberGroupsSql;
    }

    private static String getInsertGroupSql() {
        if (insertGroupSql == null) {
            StringBuffer buff = new StringBuffer(200);
            buff.append("INSERT INTO ");
            buff.append(GROUP_TABLE);
            buff.append(" (");
            buff.append(RDBMEntityGroupStore.getAllGroupColumns());
            buff.append(") VALUES (?, ?, ?, ?, ?)");
            insertGroupSql = buff.toString();
        }
        return insertGroupSql;
    }

    private static String getInsertMemberSql() {
        if (insertMemberSql == null) {
            StringBuffer buff = new StringBuffer(200);
            buff.append("INSERT INTO ");
            buff.append(MEMBER_TABLE);
            buff.append(" (");
            buff.append(RDBMEntityGroupStore.getAllMemberColumns());
            buff.append(") VALUES (?, ?, ?, ? )");
            insertMemberSql = buff.toString();
        }
        return insertMemberSql;
    }

    private String getNextKey() throws Exception {
        return Integer.toString(CounterStoreLocator.getCounterStore().getNextId(GROUP_TABLE));
    }

    private static String getUpdateGroupSql() {
        if (updateGroupSql == null) {
            StringBuffer buff = new StringBuffer(200);
            buff.append("UPDATE ");
            buff.append(GROUP_TABLE);
            buff.append(" SET ");
            buff.append(GROUP_CREATOR_COLUMN + EQUALS_PARAM);
            buff.append(", ");
            buff.append(GROUP_TYPE_COLUMN + EQUALS_PARAM);
            buff.append(", ");
            buff.append(GROUP_NAME_COLUMN + EQUALS_PARAM);
            buff.append(", ");
            buff.append(GROUP_DESCRIPTION_COLUMN + EQUALS_PARAM);
            buff.append(" WHERE ");
            buff.append(GROUP_ID_COLUMN + EQUALS_PARAM);
            updateGroupSql = buff.toString();
        }
        return updateGroupSql;
    }

    private IEntityGroup instanceFromResultSet(ResultSet rs) throws SQLException, GroupsException {
        IEntityGroup eg = null;
        String key = rs.getString(1);
        String creatorID = rs.getString(2);
        Integer entityTypeID = new Integer(rs.getInt(3));
        Class entityType = EntityTypes.getEntityType((Integer)entityTypeID);
        String groupName = rs.getString(4);
        String description = rs.getString(5);
        if (key != null) {
            eg = this.newInstance(key, entityType, creatorID, groupName, description);
        }
        return eg;
    }

    private ILockableEntityGroup lockableInstanceFromResultSet(ResultSet rs) throws SQLException, GroupsException {
        ILockableEntityGroup eg = null;
        String key = rs.getString(1);
        String creatorID = rs.getString(2);
        Integer entityTypeID = new Integer(rs.getInt(3));
        Class entityType = EntityTypes.getEntityType((Integer)entityTypeID);
        String groupName = rs.getString(4);
        String description = rs.getString(5);
        if (key != null) {
            eg = this.newLockableInstance(key, entityType, creatorID, groupName, description);
        }
        return eg;
    }

    protected static void logNoTransactionWarning() {
        if (log.isWarnEnabled()) {
            String msg = "You are running the portal on a database that does not support transactions.  This is not a supported production environment for uPortal.  Sooner or later, your database will become corrupt.";
            log.warn((Object)msg);
        }
    }

    public IEntity newEntity(Class type, String key) throws GroupsException {
        if (EntityTypes.getEntityTypeID((Class)type) == null) {
            throw new GroupsException("Invalid group type: " + type);
        }
        return GroupService.getEntity((String)key, (Class)type);
    }

    public IEntityGroup newInstance(Class type) throws GroupsException {
        if (EntityTypes.getEntityTypeID((Class)type) == null) {
            throw new GroupsException("Invalid group type: " + type);
        }
        try {
            return new EntityGroupImpl(this.getNextKey(), type);
        }
        catch (Exception ex) {
            throw new GroupsException("Could not create new group", (Throwable)ex);
        }
    }

    private IEntityGroup newInstance(String newKey, Class newType, String newCreatorID, String newName, String newDescription) throws GroupsException {
        EntityGroupImpl egi = new EntityGroupImpl(newKey, newType);
        egi.setCreatorID(newCreatorID);
        egi.primSetName(newName);
        egi.setDescription(newDescription);
        return egi;
    }

    private ILockableEntityGroup newLockableInstance(String newKey, Class newType, String newCreatorID, String newName, String newDescription) throws GroupsException {
        LockableEntityGroupImpl group = new LockableEntityGroupImpl(newKey, newType);
        group.setCreatorID(newCreatorID);
        group.primSetName(newName);
        group.setDescription(newDescription);
        return group;
    }

    private static String groupAlias(String column) {
        return GROUP_TABLE_ALIAS + "." + column;
    }

    private static String memberAlias(String column) {
        return MEMBER_TABLE_ALIAS + "." + column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primAdd(IEntityGroup group, Connection conn) throws SQLException, GroupsException {
        try {
            PreparedStatement ps = conn.prepareStatement(RDBMEntityGroupStore.getInsertGroupSql());
            try {
                int rc;
                Integer typeID = EntityTypes.getEntityTypeID((Class)group.getLeafType());
                ps.setString(1, group.getLocalKey());
                ps.setString(2, group.getCreatorID());
                ps.setInt(3, typeID);
                ps.setString(4, group.getName());
                ps.setString(5, group.getDescription());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMEntityGroupStore.primAdd(): " + ps + "(" + group.getLocalKey() + ", " + group.getCreatorID() + ", " + typeID + ", " + group.getName() + ", " + group.getDescription() + ")"));
                }
                if ((rc = ps.executeUpdate()) != 1) {
                    String errString = "Problem adding " + group;
                    log.error((Object)errString);
                    throw new GroupsException(errString);
                }
            }
            finally {
                ps.close();
            }
        }
        catch (SQLException sqle) {
            log.error((Object)("Error inserting an entity into the database. Group:" + group), (Throwable)sqle);
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primDelete(IEntityGroup group) throws SQLException {
        Connection conn = null;
        String deleteGroupSql = RDBMEntityGroupStore.getDeleteGroupSql((IEntityGroup)group);
        String deleteMembershipSql = RDBMEntityGroupStore.getDeleteMembersInGroupSql((IEntityGroup)group);
        try {
            conn = RDBMServices.getConnection();
            Statement stmnt = conn.createStatement();
            RDBMEntityGroupStore.setAutoCommit((Connection)conn, (boolean)false);
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMEntityGroupStore.primDelete(): " + deleteMembershipSql));
                }
                stmnt.executeUpdate(deleteMembershipSql);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMEntityGroupStore.primDelete(): " + deleteGroupSql));
                }
                stmnt.executeUpdate(deleteGroupSql);
            }
            finally {
                stmnt.close();
            }
            RDBMEntityGroupStore.commit((Connection)conn);
        }
        catch (SQLException sqle) {
            RDBMEntityGroupStore.rollback((Connection)conn);
            throw sqle;
        }
        finally {
            try {
                RDBMEntityGroupStore.setAutoCommit((Connection)conn, (boolean)true);
            }
            finally {
                RDBMServices.releaseConnection((Connection)conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IEntityGroup primFind(String groupID, boolean lockable) throws GroupsException {
        ILockableEntityGroup eg = null;
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            String sql = RDBMEntityGroupStore.getFindGroupSql();
            PreparedStatement ps = conn.prepareStatement(sql);
            try {
                ps.setString(1, groupID);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMEntityGroupStore.find(): " + ps + " (" + groupID + ")"));
                }
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        eg = lockable ? this.lockableInstanceFromResultSet(rs) : this.instanceFromResultSet(rs);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                ps.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"RDBMEntityGroupStore.find(): ", (Throwable)e);
            throw new GroupsException("Error retrieving " + groupID + ": ", (Throwable)e);
        }
        finally {
            RDBMServices.releaseConnection((Connection)conn);
        }
        return eg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primUpdate(IEntityGroup group, Connection conn) throws SQLException, GroupsException {
        try {
            PreparedStatement ps = conn.prepareStatement(RDBMEntityGroupStore.getUpdateGroupSql());
            try {
                int rc;
                Integer typeID = EntityTypes.getEntityTypeID((Class)group.getLeafType());
                ps.setString(1, group.getCreatorID());
                ps.setInt(2, typeID);
                ps.setString(3, group.getName());
                ps.setString(4, group.getDescription());
                ps.setString(5, group.getLocalKey());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMEntityGroupStore.primUpdate(): " + ps + "(" + group.getCreatorID() + ", " + typeID + ", " + group.getName() + ", " + group.getDescription() + ", " + group.getLocalKey() + ")"));
                }
                if ((rc = ps.executeUpdate()) != 1) {
                    String errString = "Problem updating " + group;
                    log.error((Object)errString);
                    throw new GroupsException(errString);
                }
            }
            finally {
                ps.close();
            }
        }
        catch (SQLException sqle) {
            log.error((Object)("Error updating entity in database. Group: " + group), (Throwable)sqle);
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primUpdateMembers(EntityGroupImpl egi, Connection conn) throws SQLException {
        block26: {
            String groupKey = egi.getLocalKey();
            String serviceName = null;
            try {
                String isGroup;
                String memberKey;
                if (egi.hasDeletes()) {
                    ArrayList<IGroupMember> deletedGroups = new ArrayList<IGroupMember>();
                    ArrayList<IGroupMember> deletedEntities = new ArrayList<IGroupMember>();
                    for (IGroupMember gm : egi.getRemovedMembers().values()) {
                        if (gm.isGroup()) {
                            deletedGroups.add(gm);
                            continue;
                        }
                        deletedEntities.add(gm);
                    }
                    if (!deletedGroups.isEmpty()) {
                        PreparedStatement psDeleteMemberGroup = conn.prepareStatement(RDBMEntityGroupStore.getDeleteMemberGroupSql());
                        try {
                            for (IEntityGroup iEntityGroup : deletedGroups) {
                                memberKey = iEntityGroup.getLocalKey();
                                isGroup = MEMBER_IS_GROUP;
                                serviceName = iEntityGroup.getServiceName().toString();
                                psDeleteMemberGroup.setString(1, groupKey);
                                psDeleteMemberGroup.setString(2, serviceName);
                                psDeleteMemberGroup.setString(3, memberKey);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("RDBMEntityGroupStore.primUpdateMembers(): " + psDeleteMemberGroup + "(" + groupKey + ", " + serviceName + ", " + memberKey + ", isGroup = T)"));
                                }
                                psDeleteMemberGroup.executeUpdate();
                            }
                        }
                        finally {
                            psDeleteMemberGroup.close();
                        }
                    }
                    if (!deletedEntities.isEmpty()) {
                        PreparedStatement psDeleteMemberEntity = conn.prepareStatement(RDBMEntityGroupStore.getDeleteMemberEntitySql());
                        try {
                            for (IGroupMember iGroupMember : deletedEntities) {
                                memberKey = iGroupMember.getUnderlyingEntityIdentifier().getKey();
                                isGroup = MEMBER_IS_ENTITY;
                                psDeleteMemberEntity.setString(1, groupKey);
                                psDeleteMemberEntity.setString(2, memberKey);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("RDBMEntityGroupStore.primUpdateMembers(): " + psDeleteMemberEntity + "(" + groupKey + ", " + memberKey + ", " + "isGroup = F)"));
                                }
                                psDeleteMemberEntity.executeUpdate();
                            }
                        }
                        finally {
                            psDeleteMemberEntity.close();
                        }
                    }
                }
                if (!egi.hasAdds()) break block26;
                PreparedStatement psAdd = conn.prepareStatement(RDBMEntityGroupStore.getInsertMemberSql());
                try {
                    for (IGroupMember addedGM : egi.getAddedMembers().values()) {
                        memberKey = addedGM.getKey();
                        if (addedGM.isGroup()) {
                            IEntityGroup addedGroup = (IEntityGroup)addedGM;
                            isGroup = MEMBER_IS_GROUP;
                            serviceName = addedGroup.getServiceName().toString();
                            memberKey = addedGroup.getLocalKey();
                        } else {
                            isGroup = MEMBER_IS_ENTITY;
                            serviceName = egi.getServiceName().toString();
                            memberKey = addedGM.getUnderlyingEntityIdentifier().getKey();
                        }
                        psAdd.setString(1, groupKey);
                        psAdd.setString(2, serviceName);
                        psAdd.setString(3, memberKey);
                        psAdd.setString(4, isGroup);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("RDBMEntityGroupStore.primUpdateMembers(): " + psAdd + "(" + groupKey + ", " + memberKey + ", " + isGroup + ")"));
                        }
                        psAdd.executeUpdate();
                    }
                }
                finally {
                    psAdd.close();
                }
            }
            catch (SQLException sqle) {
                log.error((Object)"Error inserting/deleting membership rows.", (Throwable)sqle);
                throw sqle;
            }
        }
    }

    protected static void rollback(Connection conn) throws SQLException {
        SqlTransaction.rollback((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityIdentifier[] searchForGroups(String query, int method, Class leaftype) throws GroupsException {
        EntityIdentifier[] r = new EntityIdentifier[]{};
        ArrayList<EntityIdentifier> ar = new ArrayList<EntityIdentifier>();
        Connection conn = null;
        PreparedStatement ps = null;
        int type = EntityTypes.getEntityTypeID((Class)leaftype);
        try {
            conn = RDBMServices.getConnection();
            switch (method) {
                case 1: {
                    ps = conn.prepareStatement(searchGroups);
                    break;
                }
                case 2: {
                    query = query + "%";
                    ps = conn.prepareStatement(searchGroupsPartial);
                    break;
                }
                case 3: {
                    query = "%" + query;
                    ps = conn.prepareStatement(searchGroupsPartial);
                    break;
                }
                case 4: {
                    query = "%" + query + "%";
                    ps = conn.prepareStatement(searchGroupsPartial);
                    break;
                }
                default: {
                    throw new GroupsException("Unknown search type");
                }
            }
            try {
                ps.clearParameters();
                ps.setInt(1, type);
                ps.setString(2, query);
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        ar.add(new EntityIdentifier(rs.getString(1), EntityTypes.GROUP_ENTITY_TYPE));
                    }
                }
                finally {
                    RDBMEntityGroupStore.close((ResultSet)rs);
                }
            }
            finally {
                RDBMEntityGroupStore.close((Statement)ps);
            }
        }
        catch (Exception e) {
            log.error((Object)("RDBMChannelDefSearcher.searchForEntities(): " + ps), (Throwable)e);
        }
        finally {
            RDBMServices.releaseConnection((Connection)conn);
        }
        return ar.toArray(r);
    }

    protected static void setAutoCommit(Connection conn, boolean newValue) throws SQLException {
        SqlTransaction.setAutoCommit((Connection)conn, (boolean)newValue);
    }

    public static synchronized RDBMEntityGroupStore singleton() throws GroupsException {
        if (singleton == null) {
            singleton = new RDBMEntityGroupStore();
        }
        return singleton;
    }

    private static String sqlQuote(Object o) {
        return QUOTE + o + QUOTE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(IEntityGroup group) throws GroupsException {
        Connection conn = null;
        boolean exists = this.existsInDatabase(group);
        try {
            conn = RDBMServices.getConnection();
            RDBMEntityGroupStore.setAutoCommit((Connection)conn, (boolean)false);
            try {
                if (exists) {
                    this.primUpdate(group, conn);
                } else {
                    this.primAdd(group, conn);
                }
                this.primUpdateMembers((EntityGroupImpl)group, conn);
                RDBMEntityGroupStore.commit((Connection)conn);
                return;
            }
            catch (Exception ex) {
                RDBMEntityGroupStore.rollback((Connection)conn);
                throw new GroupsException("Problem updating " + this + ex);
            }
        }
        catch (SQLException sqlex) {
            throw new GroupsException((Throwable)sqlex);
        }
        finally {
            try {
                RDBMEntityGroupStore.setAutoCommit((Connection)conn, (boolean)true);
            }
            catch (SQLException sqle) {
                throw new GroupsException((Throwable)sqle);
            }
            finally {
                RDBMServices.releaseConnection((Connection)conn);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateMembers(IEntityGroup eg) throws GroupsException {
        Connection conn = null;
        EntityGroupImpl egi = (EntityGroupImpl)eg;
        if (!egi.isDirty()) return;
        try {
            conn = RDBMServices.getConnection();
            RDBMEntityGroupStore.setAutoCommit((Connection)conn, (boolean)false);
            try {
                this.primUpdateMembers(egi, conn);
                RDBMEntityGroupStore.commit((Connection)conn);
                return;
            }
            catch (SQLException sqle) {
                RDBMEntityGroupStore.rollback((Connection)conn);
                throw new GroupsException("Problem updating memberships for " + egi, (Throwable)sqle);
            }
        }
        catch (SQLException sqlex) {
            throw new GroupsException((Throwable)sqlex);
        }
        finally {
            try {
                RDBMEntityGroupStore.setAutoCommit((Connection)conn, (boolean)true);
            }
            catch (SQLException sqle) {
                throw new GroupsException((Throwable)sqle);
            }
            finally {
                RDBMServices.releaseConnection((Connection)conn);
            }
        }
    }

    private static final void close(Statement statement) {
        try {
            statement.close();
        }
        catch (SQLException e) {
            log.warn((Object)"problem closing statement", (Throwable)e);
        }
    }

    private static final void close(ResultSet resultset) {
        try {
            resultset.close();
        }
        catch (SQLException e) {
            log.warn((Object)"problem closing resultset", (Throwable)e);
        }
    }

    static {
        EQ = " = ";
        QUOTE = "'";
        EQUALS_PARAM = EQ + "?";
        GROUP_TABLE = "UP_GROUP";
        GROUP_TABLE_ALIAS = "T1";
        GROUP_TABLE_WITH_ALIAS = GROUP_TABLE + " " + GROUP_TABLE_ALIAS;
        GROUP_ID_COLUMN = "GROUP_ID";
        GROUP_CREATOR_COLUMN = "CREATOR_ID";
        GROUP_TYPE_COLUMN = "ENTITY_TYPE_ID";
        GROUP_NAME_COLUMN = "GROUP_NAME";
        GROUP_DESCRIPTION_COLUMN = "DESCRIPTION";
        MEMBER_TABLE = "UP_GROUP_MEMBERSHIP";
        MEMBER_TABLE_ALIAS = "T2";
        MEMBER_TABLE_WITH_ALIAS = MEMBER_TABLE + " " + MEMBER_TABLE_ALIAS;
        MEMBER_GROUP_ID_COLUMN = "GROUP_ID";
        MEMBER_MEMBER_SERVICE_COLUMN = "MEMBER_SERVICE";
        MEMBER_MEMBER_KEY_COLUMN = "MEMBER_KEY";
        MEMBER_IS_GROUP_COLUMN = "MEMBER_IS_GROUP";
        MEMBER_IS_ENTITY = "F";
        MEMBER_IS_GROUP = "T";
        searchGroupsPartial = "SELECT " + GROUP_ID_COLUMN + " FROM " + GROUP_TABLE + " WHERE " + GROUP_TYPE_COLUMN + "=? AND UPPER(" + GROUP_NAME_COLUMN + ") LIKE UPPER(?)";
        searchGroups = "SELECT " + GROUP_ID_COLUMN + " FROM " + GROUP_TABLE + " WHERE " + GROUP_TYPE_COLUMN + "=? AND UPPER(" + GROUP_NAME_COLUMN + ") = UPPER(?)";
    }
}

