/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.concurrency.IEntityLock;
import org.jasig.portal.concurrency.LockingException;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityGroupStore;
import org.jasig.portal.groups.IEntitySearcher;
import org.jasig.portal.groups.IEntityStore;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.IGroupService;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.groups.ILockableGroupService;
import org.jasig.portal.groups.RDBMEntityStore;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.services.EntityCachingService;
import org.jasig.portal.services.EntityLockService;
import org.jasig.portal.spring.locator.ReferenceEntitySearcherLocator;

@Deprecated
public class ReferenceGroupService
implements ILockableGroupService {
    private static final Log log = LogFactory.getLog(ReferenceGroupService.class);
    private static final boolean DEFAULT_USE_CACHE = false;
    protected static IGroupService singleton = null;
    protected IEntityStore entityFactory = null;
    protected IEntityGroupStore groupFactory = null;
    private boolean cacheInUse;

    private ReferenceGroupService() throws GroupsException {
        this.initialize();
    }

    protected void addGroupToCache(IEntityGroup group) throws CachingException {
        EntityCachingService.instance().add((IBasicEntity)group);
    }

    protected boolean cacheInUse() {
        return this.cacheInUse;
    }

    public void deleteGroup(IEntityGroup group) throws GroupsException {
        if (this.cacheInUse()) {
            try {
                this.removeGroupFromCache(group);
            }
            catch (CachingException ce) {
                throw new GroupsException("Problem deleting group " + group.getKey(), (Throwable)ce);
            }
        }
        this.getGroupStore().delete(group);
    }

    public void deleteGroup(ILockableEntityGroup group) throws GroupsException {
        try {
            if (!group.getLock().isValid()) {
                throw new GroupsException("Could not delete group " + group.getKey() + " has invalid lock.");
            }
            this.deleteGroup((IEntityGroup)group);
            group.getLock().release();
        }
        catch (LockingException le) {
            throw new GroupsException("Could not delete group " + group.getKey(), (Throwable)le);
        }
    }

    public Iterator findContainingGroups(IGroupMember gm) throws GroupsException {
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>(10);
        IEntityGroup group = null;
        Iterator it = this.getGroupStore().findContainingGroups(gm);
        while (it.hasNext()) {
            group = (IEntityGroup)it.next();
            groups.add(group);
            if (!this.cacheInUse()) continue;
            try {
                if (this.getGroupFromCache(group.getEntityIdentifier().getKey()) != null) continue;
                this.addGroupToCache(group);
            }
            catch (CachingException ce) {
                throw new GroupsException("Problem finding containing groups", (Throwable)ce);
            }
        }
        return groups.iterator();
    }

    public IEntityGroup findGroup(String key) throws GroupsException {
        return this.cacheInUse() ? this.findGroupWithCache(key) : this.groupFactory.find(key);
    }

    protected IEntityGroup findGroupWithCache(String key) throws GroupsException {
        try {
            IEntityGroup group = this.getGroupFromCache(key);
            if (group == null && (group = this.groupFactory.find(key)) != null) {
                this.addGroupToCache(group);
            }
            return group;
        }
        catch (CachingException ce) {
            throw new GroupsException("Problem retrieving group " + key, (Throwable)ce);
        }
    }

    public ILockableEntityGroup findGroupWithLock(String key, String owner) throws GroupsException {
        return this.findGroupWithLock(key, owner, 0);
    }

    public ILockableEntityGroup findGroupWithLock(String key, String owner, int secs) throws GroupsException {
        Class groupType = EntityTypes.GROUP_ENTITY_TYPE;
        try {
            IEntityLock lock = secs == 0 ? EntityLockService.instance().newWriteLock(groupType, key, owner) : EntityLockService.instance().newWriteLock(groupType, key, owner, secs);
            ILockableEntityGroup group = this.groupFactory.findLockable(key);
            if (group == null) {
                lock.release();
            } else {
                group.setLock(lock);
            }
            return group;
        }
        catch (LockingException le) {
            throw new GroupsException("Problem getting lock for group " + key, (Throwable)le);
        }
    }

    public Iterator findMemberGroups(IEntityGroup eg) throws GroupsException {
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>(10);
        IEntityGroup group = null;
        Iterator it = this.getGroupStore().findMemberGroups(eg);
        while (it.hasNext()) {
            group = (IEntityGroup)it.next();
            groups.add(group);
            if (!this.cacheInUse()) continue;
            try {
                if (this.getGroupFromCache(group.getEntityIdentifier().getKey()) != null) continue;
                this.addGroupToCache(group);
            }
            catch (CachingException ce) {
                throw new GroupsException("Problem finding member groups", (Throwable)ce);
            }
        }
        return groups.iterator();
    }

    public IEntityGroup getDistinguishedGroup(String name) throws GroupsException {
        String key = PropertiesManager.getProperty((String)("org.jasig.portal.groups.ReferenceGroupService.key_" + name), null);
        if (key != null) {
            return this.findGroup(key);
        }
        throw new GroupsException("ReferenceGroupService.getDistinguishedGroup(): no key found to match requested name [" + name + "]");
    }

    public IEntity getEntity(String key, Class type) throws GroupsException {
        return this.entityFactory.newInstance(key, type);
    }

    protected IEntityGroup getGroupFromCache(String key) throws CachingException {
        return (IEntityGroup)EntityCachingService.instance().get(EntityTypes.GROUP_ENTITY_TYPE, key);
    }

    public IGroupMember getGroupMember(EntityIdentifier underlyingEntityIdentifier) throws GroupsException {
        return this.getGroupMember(underlyingEntityIdentifier.getKey(), underlyingEntityIdentifier.getType());
    }

    public IGroupMember getGroupMember(String key, Class type) throws GroupsException {
        Object gm = null;
        gm = type == EntityTypes.GROUP_ENTITY_TYPE ? this.findGroup(key) : this.getEntity(key, type);
        return gm;
    }

    public IEntityGroupStore getGroupStore() throws GroupsException {
        return this.groupFactory;
    }

    public IEntityGroup getRootGroup(Class type) throws GroupsException {
        return this.getDistinguishedGroup(type.getName());
    }

    private void initialize() throws GroupsException {
        String eMsg = null;
        this.entityFactory = new RDBMEntityStore();
        String groupFactoryName = PropertiesManager.getProperty((String)"org.jasig.portal.groups.EntityGroupFactory.implementation", null);
        if (groupFactoryName == null) {
            eMsg = "ReferenceGroupService.initialize(): EntityGroupStoreImpl not specified in portal.properties";
            log.error((Object)eMsg);
            throw new GroupsException(eMsg);
        }
        try {
            this.groupFactory = (IEntityGroupStore)Class.forName(groupFactoryName).newInstance();
        }
        catch (Exception e) {
            eMsg = "ReferenceGroupService.initialize(): Failed to instantiate " + groupFactoryName;
            log.error((Object)eMsg);
            throw new GroupsException(eMsg, (Throwable)e);
        }
        this.cacheInUse = PropertiesManager.getPropertyAsBoolean((String)"org.jasig.portal.groups.IEntityGroupService.useCache", (boolean)false);
    }

    public IEntityGroup newGroup(Class type) throws GroupsException {
        try {
            IEntityGroup group = this.groupFactory.newInstance(type);
            this.addGroupToCache(group);
            return group;
        }
        catch (CachingException e) {
            throw new GroupsException((Throwable)e);
        }
    }

    protected void removeGroupFromCache(IEntityGroup group) throws CachingException {
        EntityCachingService.instance().remove(group.getEntityIdentifier());
    }

    public static synchronized IGroupService singleton() throws GroupsException {
        if (singleton == null) {
            singleton = new ReferenceGroupService();
        }
        return singleton;
    }

    public void updateGroup(IEntityGroup group) throws GroupsException {
        if (this.cacheInUse()) {
            try {
                this.updateGroupInCache(group);
            }
            catch (CachingException ce) {
                throw new GroupsException("Problem updating group " + group.getKey(), (Throwable)ce);
            }
        }
        this.getGroupStore().update(group);
    }

    public void updateGroup(ILockableEntityGroup group) throws GroupsException {
        this.updateGroup(group, false);
    }

    public void updateGroup(ILockableEntityGroup group, boolean renewLock) throws GroupsException {
        try {
            if (!group.getLock().isValid()) {
                throw new GroupsException("Could not update group " + group.getKey() + " has invalid lock.");
            }
            if (!renewLock) {
                this.updateGroup((IEntityGroup)group);
                group.getLock().release();
            } else {
                this.getGroupStore().update((IEntityGroup)group);
                if (this.cacheInUse) {
                    this.removeGroupFromCache((IEntityGroup)group);
                }
                group.getLock().renew();
            }
        }
        catch (LockingException le) {
            throw new GroupsException("Problem updating group " + group.getKey(), (Throwable)le);
        }
        catch (CachingException ce) {
            throw new GroupsException("Problem updating group " + group.getKey(), (Throwable)ce);
        }
    }

    protected void updateGroupInCache(IEntityGroup group) throws CachingException {
        EntityCachingService.instance().update((IBasicEntity)group);
    }

    public void updateGroupMembers(IEntityGroup group) throws GroupsException {
        if (this.cacheInUse()) {
            try {
                EntityCachingService.instance().update((IBasicEntity)group);
            }
            catch (CachingException ce) {
                throw new GroupsException("Problem updating members for group " + group.getKey(), (Throwable)ce);
            }
        }
        this.getGroupStore().updateMembers(group);
    }

    public void updateGroupMembers(ILockableEntityGroup group) throws GroupsException {
        this.updateGroupMembers(group, false);
    }

    public void updateGroupMembers(ILockableEntityGroup group, boolean renewLock) throws GroupsException {
        try {
            if (!group.getLock().isValid()) {
                throw new GroupsException("Could not update group " + group.getKey() + " has invalid lock.");
            }
            if (!renewLock) {
                this.updateGroupMembers((IEntityGroup)group);
                group.getLock().release();
            } else {
                this.getGroupStore().updateMembers((IEntityGroup)group);
                if (this.cacheInUse) {
                    this.removeGroupFromCache((IEntityGroup)group);
                }
                group.getLock().renew();
            }
        }
        catch (LockingException le) {
            throw new GroupsException("Problem updating group " + group.getKey(), (Throwable)le);
        }
        catch (CachingException ce) {
            throw new GroupsException("Problem updating group " + group.getKey(), (Throwable)ce);
        }
    }

    public EntityIdentifier[] searchForGroups(String query, int method, Class leaftype) throws GroupsException {
        return this.removeDuplicates(this.groupFactory.searchForGroups(query, method, leaftype));
    }

    public EntityIdentifier[] searchForGroups(String query, int method, Class leaftype, IEntityGroup ancestor) throws GroupsException {
        return this.filterEntities(this.searchForGroups(query, method, leaftype), ancestor);
    }

    public EntityIdentifier[] searchForEntities(String query, int method, Class type) throws GroupsException {
        IEntitySearcher entitySearcher = ReferenceEntitySearcherLocator.getReferenceEntitySearcher();
        return this.removeDuplicates(entitySearcher.searchForEntities(query, method, type));
    }

    public EntityIdentifier[] searchForEntities(String query, int method, Class type, IEntityGroup ancestor) throws GroupsException {
        return this.filterEntities(this.searchForEntities(query, method, type), ancestor);
    }

    private EntityIdentifier[] filterEntities(EntityIdentifier[] entities, IEntityGroup ancestor) throws GroupsException {
        ArrayList<EntityIdentifier> ar = new ArrayList<EntityIdentifier>(entities.length);
        for (int i = 0; i < entities.length; ++i) {
            IGroupMember gm = this.getGroupMember(entities[i]);
            if (!ancestor.deepContains(gm)) continue;
            ar.add(entities[i]);
        }
        return ar.toArray(new EntityIdentifier[0]);
    }

    private EntityIdentifier[] removeDuplicates(EntityIdentifier[] entities) {
        ArrayList<EntityIdentifier> ar = new ArrayList<EntityIdentifier>(entities.length);
        for (int i = 0; i < entities.length; ++i) {
            if (ar.contains(entities[i])) continue;
            ar.add(entities[i]);
        }
        return ar.toArray(new EntityIdentifier[0]);
    }
}

