/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.local.searchers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.local.ITypedEntitySearcher;
import org.jasig.portal.security.IPerson;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.IUsernameAttributeProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonDirectorySearcher
implements ITypedEntitySearcher {
    private static final Log log = LogFactory.getLog(PersonDirectorySearcher.class);
    private final Class<? extends IBasicEntity> personEntityType = IPerson.class;
    private IPersonAttributeDao personAttributeDao;
    private IUsernameAttributeProvider usernameAttributeProvider;

    @Autowired
    public void setUsernameAttributeProvider(IUsernameAttributeProvider usernameAttributeProvider) {
        this.usernameAttributeProvider = usernameAttributeProvider;
    }

    @Autowired
    public void setPersonAttributeDao(IPersonAttributeDao personAttributeDao) {
        this.personAttributeDao = personAttributeDao;
    }

    public EntityIdentifier[] searchForEntities(String query, int method) throws GroupsException {
        switch (method) {
            case 1: {
                break;
            }
            case 2: {
                query = query + "*";
                break;
            }
            case 3: {
                query = "*" + query;
                break;
            }
            case 4: {
                query = "*" + query + "*";
                break;
            }
            default: {
                throw new GroupsException("Unknown search type");
            }
        }
        log.debug((Object)("Searching for a person directory account matching query string " + query));
        String usernameAttribute = this.usernameAttributeProvider.getUsernameAttribute();
        Map<String, String> queryMap = Collections.singletonMap(usernameAttribute, query);
        Set results = this.personAttributeDao.getPeople(queryMap);
        ArrayList<EntityIdentifier> entityIdentifiers = new ArrayList<EntityIdentifier>(results.size());
        for (IPersonAttributes personAttributes : results) {
            entityIdentifiers.add(new EntityIdentifier(personAttributes.getName(), this.personEntityType));
        }
        return entityIdentifiers.toArray(new EntityIdentifier[entityIdentifiers.size()]);
    }

    public Class<? extends IBasicEntity> getType() {
        return this.personEntityType;
    }
}

