/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.smartldap;

import java.util.LinkedList;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.groups.EntityTestingGroupImpl;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.smartldap.LdapRecord;
import org.jasig.portal.security.IPerson;
import org.springframework.ldap.core.AttributesMapper;

public final class SimpleAttributesMapper
implements AttributesMapper {
    private static final String GROUP_DESCRIPTION = "This group was pulled from the directory server.";
    private String keyAttributeName = null;
    private String groupNameAttributeName = null;
    private String membershipAttributeName = null;
    private final Log log = LogFactory.getLog(this.getClass());

    public Object mapFromAttributes(Attributes attr) {
        LdapRecord rslt;
        if (this.keyAttributeName == null) {
            String msg = "The property 'keyAttributeName' must be set.";
            throw new IllegalStateException(msg);
        }
        if (this.groupNameAttributeName == null) {
            String msg = "The property 'groupNameAttributeName' must be set.";
            throw new IllegalStateException(msg);
        }
        if (this.membershipAttributeName == null) {
            String msg = "The property 'membershipAttributeName' must be set.";
            throw new IllegalStateException(msg);
        }
        if (this.log.isDebugEnabled()) {
            String msg = "SimpleAttributesMapper.mapFromAttributes() :: settings:  keyAttributeName='" + this.keyAttributeName + "', groupNameAttributeName='" + this.groupNameAttributeName + "', groupNameAttributeName='" + this.groupNameAttributeName + "'";
            this.log.debug((Object)msg);
        }
        try {
            String key = (String)attr.get(this.keyAttributeName).get();
            String groupName = (String)attr.get(this.groupNameAttributeName).get();
            EntityTestingGroupImpl g = new EntityTestingGroupImpl(key, IPerson.class);
            g.setCreatorID("System");
            g.setName(groupName);
            g.setDescription(GROUP_DESCRIPTION);
            LinkedList<String> membership = new LinkedList<String>();
            Attribute m = attr.get(this.membershipAttributeName);
            if (m != null) {
                NamingEnumeration<?> en = m.getAll();
                while (en.hasMoreElements()) {
                    membership.add((String)en.nextElement());
                }
            }
            rslt = new LdapRecord((IEntityGroup)g, membership);
            if (this.log.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Record Details:").append("\n\tkey=").append(key).append("\n\tgroupName=").append(groupName).append("\n\tmembers:");
                for (String s : membership) {
                    msg.append("\n\t\t").append(s);
                }
                this.log.debug((Object)msg.toString());
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in SimpleAttributesMapper", t);
            String msg = "SimpleAttributesMapper failed to create a LdapRecord from the specified Attributes:  " + attr;
            throw new RuntimeException(msg, t);
        }
        return rslt;
    }

    public void setKeyAttributeName(String keyAttributeName) {
        this.keyAttributeName = keyAttributeName;
    }

    public void setGroupNameAttributeName(String groupNameAttributeName) {
        this.groupNameAttributeName = groupNameAttributeName;
    }

    public void setMembershipAttributeName(String membershipAttributeName) {
        this.membershipAttributeName = membershipAttributeName;
    }
}

