/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.i18n;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.PortalException;
import org.jasig.portal.i18n.ILocaleStore;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.LocaleResolver;

public class LocaleManagerLocaleResolver
implements LocaleResolver {
    private IUserInstanceManager userInstanceManager;
    private ILocaleStore localeStore;

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setLocaleStore(ILocaleStore localeStore) {
        this.localeStore = localeStore;
    }

    public Locale resolveLocale(HttpServletRequest request) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        LocaleManager localeManager = userInstance.getLocaleManager();
        Locale[] locales = localeManager.getLocales();
        if (locales != null && locales.length > 0) {
            return locales[0];
        }
        return request.getLocale();
    }

    public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        LocaleManager localeManager = userInstance.getLocaleManager();
        localeManager.setSessionLocales(new Locale[]{locale});
        IUserInstance ui = this.userInstanceManager.getUserInstance(request);
        IPerson person = ui.getPerson();
        if (!person.isGuest()) {
            try {
                localeManager.persistUserLocales(new Locale[]{locale});
                this.localeStore.updateUserLocales(person, new Locale[]{locale});
                IUserPreferencesManager upm = ui.getPreferencesManager();
                upm.getUserLayoutManager().loadUserLayout();
            }
            catch (Exception e) {
                throw new PortalException((Throwable)e);
            }
        }
    }
}

