/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.i18n.dao.jpa;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import org.apache.commons.lang.Validate;
import org.jasig.portal.i18n.Message;
import org.jasig.portal.i18n.dao.IMessageDao;
import org.jasig.portal.i18n.dao.jpa.MessageImpl;
import org.jasig.portal.jpa.BasePortalJpaDao;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;

@Repository
public class JpaMessageDao
extends BasePortalJpaDao
implements IMessageDao {
    private CriteriaQuery<MessageImpl> findMessageByCodeAndLocaleQuery;
    private CriteriaQuery<MessageImpl> findMessageByCodeQuery;
    private CriteriaQuery<MessageImpl> findMessageByLocaleQuery;
    private CriteriaQuery<String> findCodes;
    private ParameterExpression<String> codeParameter;
    private ParameterExpression<Locale> localeParameter;

    public void afterPropertiesSet() throws Exception {
        this.codeParameter = this.createParameterExpression(String.class, "code");
        this.localeParameter = this.createParameterExpression(Locale.class, "locale");
        this.findMessageByCodeAndLocaleQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findMessageByCodeQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findMessageByLocaleQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findCodes = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    @BasePortalJpaDao.PortalTransactional
    public Message createMessage(String code, Locale locale, String value) {
        Validate.notNull((Object)code, (String)"code can not be null");
        MessageImpl msg = new MessageImpl(code, locale, value);
        this.getEntityManager().persist((Object)msg);
        return msg;
    }

    @BasePortalJpaDao.PortalTransactional
    public Message updateMessage(Message message) {
        Validate.notNull((Object)message, (String)"message can not be null");
        this.getEntityManager().persist((Object)message);
        return message;
    }

    @BasePortalJpaDao.PortalTransactional
    public void deleteMessage(Message message) {
        Validate.notNull((Object)message, (String)"message can not be null");
        EntityManager entityManager = this.getEntityManager();
        Message msg = entityManager.contains((Object)message) ? message : (Message)entityManager.merge((Object)message);
        entityManager.remove((Object)msg);
    }

    public Message getMessage(String code, Locale locale) {
        TypedQuery query = this.createCachedQuery(this.findMessageByCodeAndLocaleQuery);
        query.setParameter((Parameter)this.codeParameter, (Object)code);
        query.setParameter((Parameter)this.localeParameter, (Object)locale);
        List messages = query.getResultList();
        return (Message)DataAccessUtils.uniqueResult((Collection)messages);
    }

    public Set<Message> getMessagesByLocale(Locale locale) {
        TypedQuery query = this.createCachedQuery(this.findMessageByLocaleQuery);
        query.setParameter((Parameter)this.localeParameter, (Object)locale);
        List messages = query.getResultList();
        return new LinkedHashSet<Message>(messages);
    }

    public Set<Message> getMessagesByCode(String code) {
        TypedQuery query = this.createCachedQuery(this.findMessageByCodeQuery);
        query.setParameter((Parameter)this.codeParameter, (Object)code);
        List messages = query.getResultList();
        return new LinkedHashSet<Message>(messages);
    }

    public Set<String> getCodes() {
        TypedQuery query = this.createCachedQuery(this.findCodes);
        List codes = query.getResultList();
        return new LinkedHashSet<String>(codes);
    }

    static /* synthetic */ ParameterExpression access$000(JpaMessageDao x0) {
        return x0.codeParameter;
    }

    static /* synthetic */ ParameterExpression access$100(JpaMessageDao x0) {
        return x0.localeParameter;
    }
}

