/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io;

import org.danann.cernunnos.EntityConfig;
import org.danann.cernunnos.Formula;
import org.danann.cernunnos.Phrase;
import org.danann.cernunnos.Reagent;
import org.danann.cernunnos.ReagentType;
import org.danann.cernunnos.SimpleFormula;
import org.danann.cernunnos.SimpleReagent;
import org.danann.cernunnos.TaskRequest;
import org.danann.cernunnos.TaskResponse;
import org.jasig.portal.spring.locator.CounterStoreLocator;
import org.jasig.portal.utils.ICounterStore;

public class SequenceGeneratorPhrase
implements Phrase {
    public static final Reagent SEQ_NAME = new SimpleReagent("SEQ_NAME", "descendant-or-self::text()", ReagentType.PHRASE, String.class, "Name of the sequence to return the next id for");
    private Phrase seqNamePhrase;

    public void init(EntityConfig config) {
        this.seqNamePhrase = (Phrase)config.getValue(SEQ_NAME);
    }

    public Formula getFormula() {
        return new SimpleFormula(SequenceGeneratorPhrase.class, new Reagent[]{SEQ_NAME});
    }

    public Object evaluate(TaskRequest req, TaskResponse res) {
        String seqName = (String)this.seqNamePhrase.evaluate(req, res);
        ICounterStore counterStore = CounterStoreLocator.getCounterStore();
        try {
            return counterStore.getNextId(seqName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve next sequence in for sequance '" + seqName + "'", e);
        }
    }

    protected String getSafeFileName(String name) {
        name = name.replaceAll("/|\\\\", ".");
        name = name.replaceAll("[^a-zA-Z0-9_.-]", "_");
        return name;
    }
}

