/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml;

import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import org.apache.commons.lang.Validate;
import org.jasig.portal.io.xml.IPortalDataType;
import org.jasig.portal.io.xml.PortalDataKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPortalDataType
implements IPortalDataType {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final QName defaultQName;

    public AbstractPortalDataType(QName defaultQName) {
        Validate.notNull((Object)defaultQName);
        this.defaultQName = defaultQName;
    }

    public String getTypeId() {
        return this.defaultQName.getLocalPart();
    }

    public String getTitleCode() {
        return this.defaultQName.getLocalPart();
    }

    public String getDescriptionCode() {
        return null;
    }

    public Set<PortalDataKey> postProcessPortalDataKey(String systemId, PortalDataKey portalDataKey, XMLEventReader reader) {
        PortalDataKey singlePortalDataKey = this.postProcessSinglePortalDataKey(systemId, portalDataKey, reader);
        return Collections.singleton(singlePortalDataKey);
    }

    protected PortalDataKey postProcessSinglePortalDataKey(String systemId, PortalDataKey portalDataKey, XMLEventReader reader) {
        return portalDataKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getTypeId() == null ? 0 : this.getTypeId().hashCode());
        result = 31 * result + (this.getDataKeyImportOrder() == null ? 0 : this.getDataKeyImportOrder().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPortalDataType other = (IPortalDataType)obj;
        if (this.getTypeId() == null ? other.getTypeId() != null : !this.getTypeId().equals(other.getTypeId())) {
            return false;
        }
        return !(this.getDataKeyImportOrder() == null ? other.getDataKeyImportOrder() != null : !this.getDataKeyImportOrder().equals(other.getDataKeyImportOrder()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [QName=" + this.defaultQName + ", supportedDataKeys=" + this.getDataKeyImportOrder() + "]";
    }
}

