/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml;

import com.google.common.base.Function;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.StartElement;
import org.apache.commons.io.IOUtils;
import org.jasig.portal.io.xml.IPortalDataHandlerService;
import org.jasig.portal.io.xml.IPortalDataType;
import org.jasig.portal.io.xml.PortalDataKey;
import org.jasig.portal.utils.ConcurrentMapUtils;
import org.jasig.portal.utils.ResourceUtils;
import org.jasig.portal.xml.StaxUtils;
import org.jasig.portal.xml.stream.BufferedXMLEventReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public final class PortalDataKeyFileProcessor
implements Function<Resource, Object> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicLong count = new AtomicLong();
    private final ConcurrentMap<PortalDataKey, Queue<Resource>> dataToImport = new ConcurrentHashMap();
    private final Map<PortalDataKey, IPortalDataType> dataKeyTypes;
    private final XMLInputFactory xmlInputFactory;
    private final IPortalDataHandlerService.BatchImportOptions options;

    PortalDataKeyFileProcessor(Map<PortalDataKey, IPortalDataType> dataKeyTypes, IPortalDataHandlerService.BatchImportOptions options) {
        this.dataKeyTypes = dataKeyTypes;
        this.options = options;
        this.xmlInputFactory = XMLInputFactory.newFactory();
        this.xmlInputFactory.setProperty("com.ctc.wstx.inputBufferLength", 2000);
        this.xmlInputFactory.setProperty("com.ctc.wstx.lazyParsing", true);
        this.xmlInputFactory.setProperty("javax.xml.stream.isValidating", false);
        this.xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
    }

    public long getResourceCount() {
        return this.count.get();
    }

    public ConcurrentMap<PortalDataKey, Queue<Resource>> getDataToImport() {
        return this.dataToImport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object apply(Resource input) {
        PortalDataKey portalDataKey;
        BufferedXMLEventReader xmlEventReader;
        InputStream fis;
        try {
            fis = input.getInputStream();
        }
        catch (IOException e) {
            if (this.options == null || this.options.isFailOnError()) {
                throw new RuntimeException("Failed to create InputStream for: " + input, e);
            }
            this.logger.warn("Failed to create InputStream, resource will be ignored: {}", (Object)input);
            return null;
        }
        try {
            xmlEventReader = new BufferedXMLEventReader(this.xmlInputFactory.createXMLEventReader(fis), -1);
            StartElement rootElement = StaxUtils.getRootElement((XMLEventReader)xmlEventReader);
            portalDataKey = new PortalDataKey(rootElement);
        }
        catch (Exception e) {
            if (this.options != null && !this.options.isIngoreNonDataFiles()) {
                throw new RuntimeException("Failed to parse: " + input, e);
            }
            this.logger.warn("Failed to parse resource, it will be ignored: {}", (Object)input);
            Object var6_8 = null;
            return var6_8;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
        xmlEventReader.reset();
        IPortalDataType portalDataType = (IPortalDataType)this.dataKeyTypes.get(portalDataKey);
        if (portalDataType == null) {
            this.logger.warn("No IPortalDataType configured for {}, the resource will be ignored: {}", (Object)portalDataKey, (Object)input);
            return null;
        }
        String resourceUri = ResourceUtils.getResourceUri((Resource)input);
        Set processedPortalDataKeys = portalDataType.postProcessPortalDataKey(resourceUri, portalDataKey, (XMLEventReader)xmlEventReader);
        xmlEventReader.reset();
        for (PortalDataKey processedPortalDataKey : processedPortalDataKeys) {
            Queue queue = (Queue)this.dataToImport.get(processedPortalDataKey);
            if (queue == null) {
                queue = (Queue)ConcurrentMapUtils.putIfAbsent((ConcurrentMap)this.dataToImport, (Object)processedPortalDataKey, new ConcurrentLinkedQueue());
            }
            queue.offer(input);
            this.count.incrementAndGet();
        }
        return null;
    }
}

