/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml.layout;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.jasig.portal.io.xml.IPortalData;
import org.jasig.portal.io.xml.IPortalDataType;
import org.jasig.portal.layout.dlm.ConfigurationLoader;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class LayoutsDataFunction
implements Function<IPortalDataType, Iterable<? extends IPortalData>>,
InitializingBean {
    private ConfigurationLoader configurationLoader;
    private DataSource dataSource;
    private NamedParameterJdbcOperations jdbcOperations;

    @Resource(name="PortalDb")
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Autowired
    public void setConfigurationLoader(ConfigurationLoader configurationLoader) {
        this.configurationLoader = configurationLoader;
    }

    public void afterPropertiesSet() throws Exception {
        this.jdbcOperations = new NamedParameterJdbcTemplate(this.dataSource);
    }

    public Iterable<? extends IPortalData> apply(IPortalDataType input) {
        List fragments = this.configurationLoader.getFragments();
        LinkedHashSet<String> fragmentOwners = new LinkedHashSet<String>();
        for (FragmentDefinition fragmentDefinition : fragments) {
            fragmentOwners.add(fragmentDefinition.getOwnerId());
        }
        List userList = this.jdbcOperations.queryForList("SELECT USER_NAME FROM UP_USER WHERE USER_NAME NOT IN (:userNames)", Collections.singletonMap("userNames", fragmentOwners), String.class);
        return Lists.transform((List)userList, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }
}

