/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml.portlettype;

import java.util.Collections;
import java.util.Set;
import org.jasig.portal.io.xml.AbstractJaxbDataHandler;
import org.jasig.portal.io.xml.IPortalData;
import org.jasig.portal.io.xml.IPortalDataType;
import org.jasig.portal.io.xml.PortalDataKey;
import org.jasig.portal.io.xml.portlettype.ExternalPortletType;
import org.jasig.portal.io.xml.portlettype.PortletTypePortalDataType;
import org.jasig.portal.portlet.om.IPortletType;
import org.jasig.portal.portlet.registry.IPortletTypeRegistry;
import org.jasig.portal.utils.SafeFilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class PortletTypeImporterExporter
extends AbstractJaxbDataHandler<ExternalPortletType> {
    private PortletTypePortalDataType typePortalDataType;
    private IPortletTypeRegistry portletTypeRegistry;

    @Autowired
    public void setTypePortalDataType(PortletTypePortalDataType typePortalDataType) {
        this.typePortalDataType = typePortalDataType;
    }

    @Autowired
    public void setPortletTypeRegistry(IPortletTypeRegistry portletTypeRegistry) {
        this.portletTypeRegistry = portletTypeRegistry;
    }

    public Set<PortalDataKey> getImportDataKeys() {
        return Collections.singleton(PortletTypePortalDataType.IMPORT_40_DATA_KEY);
    }

    public IPortalDataType getPortalDataType() {
        return this.typePortalDataType;
    }

    public Iterable<? extends IPortalData> getPortalData() {
        return this.portletTypeRegistry.getPortletTypes();
    }

    @Transactional
    public void importData(ExternalPortletType data) {
        String name = data.getName();
        IPortletType portletType = this.portletTypeRegistry.getPortletType(name);
        if (portletType == null) {
            portletType = this.portletTypeRegistry.createPortletType(name, data.getUri());
        } else {
            portletType.setCpdUri(data.getUri());
        }
        portletType.setDescription(data.getDescription());
        this.portletTypeRegistry.savePortletType(portletType);
    }

    public ExternalPortletType exportData(String id) {
        IPortletType portletType = this.portletTypeRegistry.getPortletType(Integer.parseInt(id));
        if (null == portletType) {
            return null;
        }
        return this.convert(portletType);
    }

    public String getFileName(ExternalPortletType data) {
        return SafeFilenameUtils.makeSafeFilename((String)data.getName());
    }

    @Transactional
    public ExternalPortletType deleteData(String id) {
        IPortletType portletType = this.portletTypeRegistry.getPortletType(Integer.parseInt(id));
        if (null == portletType) {
            return null;
        }
        ExternalPortletType result = this.convert(portletType);
        this.portletTypeRegistry.deleteChannelType(portletType);
        return result;
    }

    protected ExternalPortletType convert(IPortletType portletType) {
        ExternalPortletType result = new ExternalPortletType();
        result.setUri(portletType.getCpdUri());
        result.setDescription(portletType.getDescription());
        result.setName(portletType.getName());
        return result;
    }
}

