/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml.profile;

import org.jasig.portal.layout.dao.IStylesheetDescriptorDao;
import org.jasig.portal.layout.dao.IStylesheetUserPreferencesDao;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.layout.om.IStylesheetUserPreferences;

public class ProfileImportHelper {
    private final IStylesheetUserPreferencesDao stylesheetUserPreferencesDao;
    private final IStylesheetDescriptor structureStylesheetDescriptor;
    private final IStylesheetDescriptor themeStylesheetDescriptor;
    private final int personId;
    private final int profileId;
    private IStylesheetUserPreferences structureStylesheetUserPreferences;
    private IStylesheetUserPreferences themeStylesheetUserPreferences;

    public ProfileImportHelper(IStylesheetDescriptorDao stylesheetDescriptorDao, IStylesheetUserPreferencesDao stylesheetUserPreferencesDao, long structureStylesheetId, long themeStylesheetId, int personId, int profileId) {
        this.stylesheetUserPreferencesDao = stylesheetUserPreferencesDao;
        this.structureStylesheetDescriptor = stylesheetDescriptorDao.getStylesheetDescriptor(structureStylesheetId);
        this.themeStylesheetDescriptor = stylesheetDescriptorDao.getStylesheetDescriptor(themeStylesheetId);
        this.personId = personId;
        this.profileId = profileId;
    }

    public void addStructureParameter(String name, String value) {
        if (this.structureStylesheetUserPreferences == null) {
            this.structureStylesheetUserPreferences = this.getCreateStylesheetUserPreferences(this.structureStylesheetDescriptor);
        }
        this.structureStylesheetUserPreferences.setStylesheetParameter(name, value);
    }

    public void addThemeParameter(String name, String value) {
        if (this.themeStylesheetUserPreferences == null) {
            this.themeStylesheetUserPreferences = this.getCreateStylesheetUserPreferences(this.themeStylesheetDescriptor);
        }
        this.themeStylesheetUserPreferences.setStylesheetParameter(name, value);
    }

    public void save() {
        if (this.structureStylesheetUserPreferences != null) {
            this.stylesheetUserPreferencesDao.storeStylesheetUserPreferences(this.structureStylesheetUserPreferences);
        }
        if (this.themeStylesheetUserPreferences != null) {
            this.stylesheetUserPreferencesDao.storeStylesheetUserPreferences(this.themeStylesheetUserPreferences);
        }
    }

    protected IStylesheetUserPreferences getCreateStylesheetUserPreferences(IStylesheetDescriptor stylesheetDescriptor) {
        IStylesheetUserPreferences stylesheetUserPreferences = this.stylesheetUserPreferencesDao.getStylesheetUserPreferences(stylesheetDescriptor, this.personId, this.profileId);
        if (stylesheetUserPreferences != null) {
            return stylesheetUserPreferences;
        }
        return this.stylesheetUserPreferencesDao.createStylesheetUserPreferences(stylesheetDescriptor, this.personId, this.profileId);
    }
}

