/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class JavaManagementServerBean {
    private static final String JMX_ENABLED_PROPERTY = "com.sun.management.jmxremote";
    private static final String JMX_SSL_PROPERTY = "com.sun.management.jmxremote.ssl";
    private static final String JMX_PASSWORD_FILE_PROPERTY = "com.sun.management.jmxremote.password.file";
    private static final String JMX_ACCESS_FILE_PROPERTY = "com.sun.management.jmxremote.access.file";
    private static final String JMX_REMOTE_X_ACCESS_FILE = "jmx.remote.x.access.file";
    private static final String JMX_REMOTE_X_PASSWORD_FILE = "jmx.remote.x.password.file";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String host = null;
    private int portOne = -1;
    private int portTwo = -1;
    private boolean failOnException = false;
    private JMXConnectorServer jmxConnectorServer;

    public boolean isFailOnException() {
        return this.failOnException;
    }

    public void setFailOnException(boolean failOnException) {
        this.failOnException = failOnException;
    }

    public int getPortTwo() {
        return this.portTwo;
    }

    public void setPortTwo(int portTwo) {
        this.portTwo = portTwo;
    }

    public int getPortOne() {
        return this.portOne;
    }

    @Required
    public void setPortOne(int portOne) {
        Validate.isTrue((portOne > 0 ? 1 : 0) != 0, (String)"portOne must be greater than 0");
        this.portOne = portOne;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void startServer() {
        if (!System.getProperties().containsKey(JMX_ENABLED_PROPERTY)) {
            this.logger.info((Object)"System Property 'com.sun.management.jmxremote' is not set, skipping initialization.");
            return;
        }
        try {
            int portOne = this.getPortOne();
            int portTwo = this.calculatePortTwo(portOne);
            try {
                LocateRegistry.createRegistry(portOne);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Started RMI Registry on port " + portOne));
                }
            }
            catch (RemoteException re) {
                throw new IllegalStateException("Could not create RMI Registry on port " + portOne, re);
            }
            JMXServiceURL jmxServiceUrl = this.getServiceUrl(portOne, portTwo);
            Map jmxEnv = this.getJmxServerEnvironment();
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                this.jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jmxServiceUrl, jmxEnv, mbeanServer);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Created JMXConnectorServer for JMXServiceURL='" + jmxServiceUrl + "', jmxEnv='" + jmxEnv + "' MBeanServer='" + mbeanServer + "'"));
                }
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Failed to create a new JMXConnectorServer for JMXServiceURL='" + jmxServiceUrl + "', jmxEnv='" + jmxEnv + "' MBeanServer='" + mbeanServer + "'", ioe);
            }
            try {
                this.jmxConnectorServer.start();
                this.logger.info((Object)("Started JMXConnectorServer. Listening on '" + jmxServiceUrl + "'"));
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Failed to start the JMXConnectorServer", ioe);
            }
        }
        catch (RuntimeException re) {
            if (this.failOnException) {
                throw re;
            }
            this.logger.error((Object)"Failed to initialize the JMX Server", (Throwable)re);
        }
    }

    public void stopServer() {
        if (this.jmxConnectorServer == null) {
            this.logger.info((Object)"No JMXConnectorServer to stop");
            return;
        }
        try {
            try {
                this.jmxConnectorServer.stop();
                this.logger.info((Object)"Stopped JMXConnectorServer");
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Failed to stop the JMXConnectorServer", ioe);
            }
            this.jmxConnectorServer = null;
        }
        catch (RuntimeException re) {
            if (this.failOnException) {
                throw re;
            }
            this.logger.error((Object)"Failed to shutdown the JMX Server", (Throwable)re);
        }
    }

    protected int calculatePortTwo(int portOne) {
        int portTwo = this.portTwo;
        if (portTwo <= 0) {
            portTwo = portOne + 1;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using " + portTwo + " for portTwo."));
        }
        return portTwo;
    }

    protected JMXServiceURL getServiceUrl(int portOne, int portTwo) {
        JMXServiceURL jmxServiceUrl;
        String jmxHost;
        if (this.host == null) {
            InetAddress inetHost;
            try {
                inetHost = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                throw new IllegalStateException("Cannot resolve localhost InetAddress.", uhe);
            }
            jmxHost = inetHost.getHostName();
        } else {
            jmxHost = this.host;
        }
        String jmxUrl = "service:jmx:rmi://" + jmxHost + ":" + portTwo + "/jndi/rmi://" + jmxHost + ":" + portOne + "/server";
        try {
            jmxServiceUrl = new JMXServiceURL(jmxUrl);
        }
        catch (MalformedURLException mue) {
            throw new IllegalStateException("Failed to create JMXServiceURL for url String '" + jmxUrl + "'", mue);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generated JMXServiceURL='" + jmxServiceUrl + "' from String " + jmxUrl + "'."));
        }
        return jmxServiceUrl;
    }

    protected Map<String, Object> getJmxServerEnvironment() {
        String accessFile;
        String passwordFile;
        HashMap<String, Object> jmxEnv = new HashMap<String, Object>();
        String enableSSL = System.getProperty(JMX_SSL_PROPERTY);
        if (Boolean.getBoolean(enableSSL)) {
            SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
            jmxEnv.put("jmx.remote.rmi.client.socket.factory", csf);
            SslRMIServerSocketFactory ssf = new SslRMIServerSocketFactory();
            jmxEnv.put("jmx.remote.rmi.server.socket.factory", ssf);
        }
        if ((passwordFile = System.getProperty(JMX_PASSWORD_FILE_PROPERTY)) != null) {
            jmxEnv.put(JMX_REMOTE_X_PASSWORD_FILE, passwordFile);
        }
        if ((accessFile = System.getProperty(JMX_ACCESS_FILE_PROPERTY)) != null) {
            jmxEnv.put(JMX_REMOTE_X_ACCESS_FILE, accessFile);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Configured JMX Server Environment = '" + jmxEnv + "'"));
        }
        return jmxEnv;
    }
}

