/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.json.rendering;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.rendering.IPortalRenderingPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class JsonRenderingController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPortalRenderingPipeline portalRenderingPipeline;
    private IPortletWindowRegistry portletWindowRegistry;

    @Autowired
    @Qualifier(value="json")
    public void setPortalRenderingPipeline(IPortalRenderingPipeline portalRenderingPipeline) {
        this.portalRenderingPipeline = portalRenderingPipeline;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @RequestMapping(value={"/layout.json"})
    public void renderRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.portletWindowRegistry.disablePersistentWindowStates(request);
        this.portalRenderingPipeline.renderState(request, response);
    }
}

