/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.layout.IProfileMapper;
import org.jasig.portal.security.IPerson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ServerNameGuestChainingProfileMapper
implements IProfileMapper,
InitializingBean {
    protected Logger logger = LoggerFactory.getLogger(ServerNameGuestChainingProfileMapper.class);
    private static final String SEPARATOR = "-";
    private String defaultProfileName = "default";
    private Map<String, String> authorizedServerNames;
    private List<IProfileMapper> subMappers = Collections.emptyList();

    public String getProfileFname(IPerson person, HttpServletRequest request) {
        StringBuilder fname = new StringBuilder(64);
        if (person.isGuest()) {
            String serverName = (String)this.authorizedServerNames.get(request.getServerName());
            fname.append("guest-");
            if (StringUtils.hasText((String)serverName)) {
                fname.append(serverName);
                fname.append(SEPARATOR);
            }
        }
        boolean subFnameFound = false;
        for (IProfileMapper mapper : this.subMappers) {
            String subFname = mapper.getProfileFname(person, request);
            if (!StringUtils.hasText((String)subFname)) continue;
            fname.append(subFname);
            subFnameFound = true;
            break;
        }
        if (!subFnameFound) {
            fname.append(this.defaultProfileName);
        }
        this.logger.debug("Profile fname: [{}].", (Object)fname.toString());
        return fname.toString();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty((Map)this.authorizedServerNames, (String)"No authorized server name provided !");
    }

    public void setDefaultProfileName(String defaultProfileName) {
        this.defaultProfileName = defaultProfileName;
    }

    public void setSubMappers(List<IProfileMapper> subMappers) {
        this.subMappers = subMappers;
    }

    public void setAuthorizedServerNames(Map<String, String> authorizedServerNames) {
        this.authorizedServerNames = authorizedServerNames;
    }
}

