/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.layout.IStylesheetUserPreferencesService;
import org.jasig.portal.layout.IUserLayout;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.StylesheetUserPreferencesServiceImpl;
import org.jasig.portal.layout.dao.IStylesheetDescriptorDao;
import org.jasig.portal.layout.dao.IStylesheetUserPreferencesDao;
import org.jasig.portal.layout.om.ILayoutAttributeDescriptor;
import org.jasig.portal.layout.om.IOutputPropertyDescriptor;
import org.jasig.portal.layout.om.IStylesheetData;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.layout.om.IStylesheetParameterDescriptor;
import org.jasig.portal.layout.om.IStylesheetUserPreferences;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.utils.Populator;
import org.jasig.portal.utils.web.PortalWebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.WebUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StylesheetUserPreferencesServiceImpl
implements IStylesheetUserPreferencesService {
    private static final String OUTPUT_PROPERTIES_KEY = StylesheetUserPreferencesServiceImpl.class.getName() + ".OUTPUT_PROPERTIES";
    private static final String STYLESHEET_PARAMETERS_KEY = StylesheetUserPreferencesServiceImpl.class.getName() + ".STYLESHEET_PARAMETERS";
    private static final String LAYOUT_ATTRIBUTES_KEY = StylesheetUserPreferencesServiceImpl.class.getName() + ".LAYOUT_ATTRIBUTES";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IUserInstanceManager userInstanceManager;
    private IStylesheetDescriptorDao stylesheetDescriptorDao;
    private IStylesheetUserPreferencesDao stylesheetUserPreferencesDao;
    private static final String NO_PERSISTENT_IStylesheetUserPreferences = StylesheetUserPreferencesServiceImpl.class.getName() + ".NO_PERSISTENT_IStylesheetUserPreferences";

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setStylesheetDescriptorDao(IStylesheetDescriptorDao stylesheetDescriptorDao) {
        this.stylesheetDescriptorDao = stylesheetDescriptorDao;
    }

    @Autowired
    public void setStylesheetUserPreferencesDao(IStylesheetUserPreferencesDao stylesheetUserPreferencesDao) {
        this.stylesheetUserPreferencesDao = stylesheetUserPreferencesDao;
    }

    protected final StylesheetPreferencesKey getStylesheetPreferencesKey(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IPerson person = userInstance.getPerson();
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserProfile userProfile = preferencesManager.getUserProfile();
        int stylesheetId = prefScope.getStylesheetId(userProfile);
        IStylesheetDescriptor stylesheetDescriptor = this.stylesheetDescriptorDao.getStylesheetDescriptor((long)stylesheetId);
        return new StylesheetPreferencesKey(person, userProfile, stylesheetDescriptor, null);
    }

    protected final IStylesheetUserPreferences getDistributedStylesheetUserPreferences(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        IUserLayout userLayout = userLayoutManager.getUserLayout();
        return prefScope.getDistributedIStylesheetUserPreferences(userLayout);
    }

    protected final IStylesheetData.Scope getWriteScope(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, StylesheetPreferencesKey stylesheetPreferencesKey, IStylesheetData descriptor) {
        IStylesheetData.Scope scope = descriptor.getScope();
        boolean persistentScopeReadOnly = this.isPersistentScopeReadOnly(request, prefScope, stylesheetPreferencesKey);
        if (persistentScopeReadOnly && IStylesheetData.Scope.PERSISTENT == scope) {
            return IStylesheetData.Scope.SESSION;
        }
        return scope;
    }

    protected boolean isPersistentScopeReadOnly(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, StylesheetPreferencesKey stylesheetPreferencesKey) {
        return StylesheetPreferencesKey.access$100((StylesheetPreferencesKey)stylesheetPreferencesKey).isGuest();
    }

    protected final boolean compareValues(String value, String defaultValue) {
        return value == defaultValue || value != null && value.equals(defaultValue);
    }

    protected final <T> T getDataValue(HttpServletRequest request, StylesheetPreferencesKey stylesheetPreferencesKey, IStylesheetData.Scope scope, String mapKey, String name) {
        switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
            case 1: {
                HttpSession session = request.getSession(false);
                if (session == null) {
                    return null;
                }
                ConcurrentMap outputProperties = PortalWebUtils.getMapSessionAttribute((HttpSession)session, (String)(mapKey + stylesheetPreferencesKey.toString()), (boolean)false);
                if (outputProperties == null) {
                    return null;
                }
                return (T)outputProperties.get(name);
            }
            case 2: {
                ConcurrentMap outputProperties = PortalWebUtils.getMapRequestAttribute((ServletRequest)request, (String)(mapKey + stylesheetPreferencesKey.toString()), (boolean)false);
                if (outputProperties == null) {
                    return null;
                }
                return (T)outputProperties.get(name);
            }
        }
        return null;
    }

    protected final <T> T putDataValue(HttpServletRequest request, StylesheetPreferencesKey stylesheetPreferencesKey, IStylesheetData.Scope scope, String mapKey, String name, T value) {
        switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
            case 1: {
                HttpSession session = request.getSession();
                ConcurrentMap outputProperties = PortalWebUtils.getMapSessionAttribute((HttpSession)session, (String)(mapKey + stylesheetPreferencesKey.toString()));
                return outputProperties.put(name, value);
            }
            case 2: {
                ConcurrentMap outputProperties = PortalWebUtils.getMapRequestAttribute((ServletRequest)request, (String)(mapKey + stylesheetPreferencesKey.toString()));
                return outputProperties.put(name, value);
            }
        }
        return null;
    }

    protected final <T> T removeDataValue(HttpServletRequest request, StylesheetPreferencesKey stylesheetPreferencesKey, IStylesheetData.Scope scope, String mapKey, String name) {
        switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
            case 1: {
                HttpSession session = request.getSession(false);
                if (session == null) {
                    return null;
                }
                ConcurrentMap outputProperties = PortalWebUtils.getMapSessionAttribute((HttpSession)session, (String)(mapKey + stylesheetPreferencesKey.toString()), (boolean)false);
                if (outputProperties == null) {
                    return null;
                }
                return (T)outputProperties.remove(name);
            }
            case 2: {
                ConcurrentMap outputProperties = PortalWebUtils.getMapRequestAttribute((ServletRequest)request, (String)(mapKey + stylesheetPreferencesKey.toString()), (boolean)false);
                if (outputProperties == null) {
                    return null;
                }
                return (T)outputProperties.remove(name);
            }
        }
        return null;
    }

    public IStylesheetDescriptor getStylesheetDescriptor(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserProfile userProfile = preferencesManager.getUserProfile();
        int stylesheetId = prefScope.getStylesheetId(userProfile);
        return this.stylesheetDescriptorDao.getStylesheetDescriptor((long)stylesheetId);
    }

    public String getOutputProperty(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, String name) {
        String value;
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetDescriptor stylesheetDescriptor = StylesheetPreferencesKey.access$200((StylesheetPreferencesKey)stylesheetPreferencesKey);
        IOutputPropertyDescriptor outputPropertyDescriptor = stylesheetDescriptor.getOutputPropertyDescriptor(name);
        if (outputPropertyDescriptor == null) {
            this.logger.warn("Attempted to get output property {} but no such output property is defined in stylesheet descriptor {}. null will be returned", new Object[]{name, stylesheetDescriptor.getName()});
            return null;
        }
        IStylesheetData.Scope scope = outputPropertyDescriptor.getScope();
        switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
            case 3: {
                IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
                if (stylesheetUserPreferences == null) {
                    return null;
                }
                value = stylesheetUserPreferences.getOutputProperty(name);
                break;
            }
            default: {
                value = (String)this.getDataValue(request, stylesheetPreferencesKey, scope, OUTPUT_PROPERTIES_KEY, name);
            }
        }
        if (value == null) {
            return null;
        }
        if (this.compareValues(value, outputPropertyDescriptor.getDefaultValue())) {
            this.removeOutputProperty(request, prefScope, name);
            return null;
        }
        return value;
    }

    @Transactional
    public String setOutputProperty(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, String name, String value) {
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetDescriptor stylesheetDescriptor = StylesheetPreferencesKey.access$200((StylesheetPreferencesKey)stylesheetPreferencesKey);
        IOutputPropertyDescriptor outputPropertyDescriptor = stylesheetDescriptor.getOutputPropertyDescriptor(name);
        if (outputPropertyDescriptor == null) {
            this.logger.warn("Attempted to set output property {}={} but no such output property is defined in stylesheet descriptor {}. It will be ignored", new Object[]{name, value, stylesheetDescriptor.getName()});
            return null;
        }
        if (this.compareValues(value, outputPropertyDescriptor.getDefaultValue())) {
            return this.removeOutputProperty(request, prefScope, name);
        }
        IStylesheetData.Scope scope = this.getWriteScope(request, prefScope, stylesheetPreferencesKey, (IStylesheetData)outputPropertyDescriptor);
        switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
            case 3: {
                IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
                if (stylesheetUserPreferences == null) {
                    stylesheetUserPreferences = this.stylesheetUserPreferencesDao.createStylesheetUserPreferences(stylesheetDescriptor, StylesheetPreferencesKey.access$100((StylesheetPreferencesKey)stylesheetPreferencesKey), StylesheetPreferencesKey.access$300((StylesheetPreferencesKey)stylesheetPreferencesKey));
                    this.clearStylesheetUserPreferencesCache(request, stylesheetPreferencesKey);
                }
                String oldValue = stylesheetUserPreferences.setOutputProperty(name, value);
                this.stylesheetUserPreferencesDao.storeStylesheetUserPreferences(stylesheetUserPreferences);
                return oldValue;
            }
        }
        return (String)this.putDataValue(request, stylesheetPreferencesKey, scope, OUTPUT_PROPERTIES_KEY, name, (Object)value);
    }

    @Transactional
    public String removeOutputProperty(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, String name) {
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetDescriptor stylesheetDescriptor = StylesheetPreferencesKey.access$200((StylesheetPreferencesKey)stylesheetPreferencesKey);
        IOutputPropertyDescriptor outputPropertyDescriptor = stylesheetDescriptor.getOutputPropertyDescriptor(name);
        if (outputPropertyDescriptor == null) {
            this.logger.warn("Attempted to remove output property {} but no such output property is defined in stylesheet descriptor {}. It will be ignored", new Object[]{name, stylesheetDescriptor.getName()});
            return null;
        }
        IStylesheetData.Scope scope = this.getWriteScope(request, prefScope, stylesheetPreferencesKey, (IStylesheetData)outputPropertyDescriptor);
        switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
            case 3: {
                IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
                if (stylesheetUserPreferences == null) {
                    return null;
                }
                String oldValue = stylesheetUserPreferences.removeOutputProperty(name);
                this.stylesheetUserPreferencesDao.storeStylesheetUserPreferences(stylesheetUserPreferences);
                this.clearStylesheetUserPreferencesCache(request, stylesheetPreferencesKey);
                return oldValue;
            }
        }
        return (String)this.removeDataValue(request, stylesheetPreferencesKey, scope, OUTPUT_PROPERTIES_KEY, name);
    }

    public <P extends Populator<String, String>> P populateOutputProperties(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, P properties) {
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetDescriptor stylesheetDescriptor = StylesheetPreferencesKey.access$200((StylesheetPreferencesKey)stylesheetPreferencesKey);
        IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
        HttpSession session = request.getSession(false);
        ConcurrentMap sessionOutputProperties = session == null ? null : PortalWebUtils.getMapSessionAttribute((HttpSession)session, (String)(OUTPUT_PROPERTIES_KEY + stylesheetPreferencesKey.toString()), (boolean)false);
        ConcurrentMap requestOutputProperties = PortalWebUtils.getMapRequestAttribute((ServletRequest)request, (String)(OUTPUT_PROPERTIES_KEY + stylesheetPreferencesKey.toString()), (boolean)false);
        for (IOutputPropertyDescriptor outputPropertyDescriptor : stylesheetDescriptor.getOutputPropertyDescriptors()) {
            String value;
            String name = outputPropertyDescriptor.getName();
            IStylesheetData.Scope scope = outputPropertyDescriptor.getScope();
            switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
                case 3: {
                    if (stylesheetUserPreferences == null) {
                        value = null;
                        break;
                    }
                    value = stylesheetUserPreferences.getOutputProperty(name);
                    break;
                }
                case 1: {
                    if (sessionOutputProperties == null) {
                        value = null;
                        break;
                    }
                    value = (String)sessionOutputProperties.get(name);
                    break;
                }
                case 2: {
                    if (requestOutputProperties == null) {
                        value = null;
                        break;
                    }
                    value = (String)requestOutputProperties.get(name);
                    break;
                }
                default: {
                    value = null;
                }
            }
            if (value == null) continue;
            if (this.compareValues(value, outputPropertyDescriptor.getDefaultValue())) {
                this.removeOutputProperty(request, prefScope, name);
                continue;
            }
            properties.put((Object)name, (Object)value);
        }
        return properties;
    }

    @Transactional
    public void clearOutputProperties(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope) {
        HttpSession session;
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
        if (stylesheetUserPreferences != null) {
            stylesheetUserPreferences.clearOutputProperties();
            this.stylesheetUserPreferencesDao.storeStylesheetUserPreferences(stylesheetUserPreferences);
        }
        if ((session = request.getSession(false)) != null) {
            session.removeAttribute(OUTPUT_PROPERTIES_KEY + stylesheetPreferencesKey.toString());
        }
        request.removeAttribute(OUTPUT_PROPERTIES_KEY + stylesheetPreferencesKey.toString());
    }

    public String getStylesheetParameter(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, String name) {
        String value;
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetDescriptor stylesheetDescriptor = StylesheetPreferencesKey.access$200((StylesheetPreferencesKey)stylesheetPreferencesKey);
        IStylesheetParameterDescriptor stylesheetParameterDescriptor = stylesheetDescriptor.getStylesheetParameterDescriptor(name);
        if (stylesheetParameterDescriptor == null) {
            this.logger.warn("Attempted to get stylesheet parameter {} but no such stylesheet parameter is defined in stylesheet descriptor {}. null will be returned", new Object[]{name, stylesheetDescriptor.getName()});
            return null;
        }
        IStylesheetData.Scope scope = stylesheetParameterDescriptor.getScope();
        switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
            case 3: {
                IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
                if (stylesheetUserPreferences == null) {
                    return null;
                }
                value = stylesheetUserPreferences.getStylesheetParameter(name);
                break;
            }
            default: {
                value = (String)this.getDataValue(request, stylesheetPreferencesKey, scope, STYLESHEET_PARAMETERS_KEY, name);
            }
        }
        if (value == null) {
            return null;
        }
        if (this.compareValues(value, stylesheetParameterDescriptor.getDefaultValue())) {
            this.removeStylesheetParameter(request, prefScope, name);
            return null;
        }
        return value;
    }

    @Transactional
    public String setStylesheetParameter(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, String name, String value) {
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetDescriptor stylesheetDescriptor = StylesheetPreferencesKey.access$200((StylesheetPreferencesKey)stylesheetPreferencesKey);
        IStylesheetParameterDescriptor stylesheetParameterDescriptor = stylesheetDescriptor.getStylesheetParameterDescriptor(name);
        if (stylesheetParameterDescriptor == null) {
            this.logger.warn("Attempted to set stylesheet parameter {}={} but no such stylesheet parameter is defined in stylesheet descriptor {}. It will be ignored", new Object[]{name, value, stylesheetDescriptor.getName()});
            return null;
        }
        if (this.compareValues(value, stylesheetParameterDescriptor.getDefaultValue())) {
            return this.removeStylesheetParameter(request, prefScope, name);
        }
        IStylesheetData.Scope scope = this.getWriteScope(request, prefScope, stylesheetPreferencesKey, (IStylesheetData)stylesheetParameterDescriptor);
        switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
            case 3: {
                IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
                if (stylesheetUserPreferences == null) {
                    stylesheetUserPreferences = this.stylesheetUserPreferencesDao.createStylesheetUserPreferences(stylesheetDescriptor, StylesheetPreferencesKey.access$100((StylesheetPreferencesKey)stylesheetPreferencesKey), StylesheetPreferencesKey.access$300((StylesheetPreferencesKey)stylesheetPreferencesKey));
                    this.clearStylesheetUserPreferencesCache(request, stylesheetPreferencesKey);
                }
                String oldValue = stylesheetUserPreferences.setStylesheetParameter(name, value);
                this.stylesheetUserPreferencesDao.storeStylesheetUserPreferences(stylesheetUserPreferences);
                return oldValue;
            }
        }
        return (String)this.putDataValue(request, stylesheetPreferencesKey, scope, STYLESHEET_PARAMETERS_KEY, name, (Object)value);
    }

    @Transactional
    public String removeStylesheetParameter(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, String name) {
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetDescriptor stylesheetDescriptor = StylesheetPreferencesKey.access$200((StylesheetPreferencesKey)stylesheetPreferencesKey);
        IStylesheetParameterDescriptor stylesheetParameterDescriptor = stylesheetDescriptor.getStylesheetParameterDescriptor(name);
        if (stylesheetParameterDescriptor == null) {
            this.logger.warn("Attempted to remove stylesheet parameter {} but no such stylesheet parameter is defined in stylesheet descriptor {}. It will be ignored", new Object[]{name, stylesheetDescriptor.getName()});
            return null;
        }
        IStylesheetData.Scope scope = this.getWriteScope(request, prefScope, stylesheetPreferencesKey, (IStylesheetData)stylesheetParameterDescriptor);
        switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
            case 3: {
                IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
                if (stylesheetUserPreferences == null) {
                    return null;
                }
                String oldValue = stylesheetUserPreferences.removeStylesheetParameter(name);
                this.stylesheetUserPreferencesDao.storeStylesheetUserPreferences(stylesheetUserPreferences);
                return oldValue;
            }
        }
        return (String)this.removeDataValue(request, stylesheetPreferencesKey, scope, STYLESHEET_PARAMETERS_KEY, name);
    }

    public Iterable<String> getStylesheetParameterNames(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope) {
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetDescriptor stylesheetDescriptor = StylesheetPreferencesKey.access$200((StylesheetPreferencesKey)stylesheetPreferencesKey);
        Collection stylesheetParameterDescriptors = stylesheetDescriptor.getStylesheetParameterDescriptors();
        return Collections2.transform((Collection)stylesheetParameterDescriptors, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public <P extends Populator<String, String>> P populateStylesheetParameters(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, P stylesheetParameters) {
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetDescriptor stylesheetDescriptor = StylesheetPreferencesKey.access$200((StylesheetPreferencesKey)stylesheetPreferencesKey);
        IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
        HttpSession session = request.getSession(false);
        ConcurrentMap sessionStylesheetParameters = session == null ? null : PortalWebUtils.getMapSessionAttribute((HttpSession)session, (String)(STYLESHEET_PARAMETERS_KEY + stylesheetPreferencesKey.toString()), (boolean)false);
        ConcurrentMap requestStylesheetParameters = PortalWebUtils.getMapRequestAttribute((ServletRequest)request, (String)(STYLESHEET_PARAMETERS_KEY + stylesheetPreferencesKey.toString()), (boolean)false);
        for (IStylesheetParameterDescriptor stylesheetParameterDescriptor : stylesheetDescriptor.getStylesheetParameterDescriptors()) {
            String value;
            String name = stylesheetParameterDescriptor.getName();
            IStylesheetData.Scope scope = stylesheetParameterDescriptor.getScope();
            switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
                case 3: {
                    if (stylesheetUserPreferences == null) {
                        value = null;
                        break;
                    }
                    value = stylesheetUserPreferences.getStylesheetParameter(name);
                    break;
                }
                case 1: {
                    if (sessionStylesheetParameters == null) {
                        value = null;
                        break;
                    }
                    value = (String)sessionStylesheetParameters.get(name);
                    break;
                }
                case 2: {
                    if (requestStylesheetParameters == null) {
                        value = null;
                        break;
                    }
                    value = (String)requestStylesheetParameters.get(name);
                    break;
                }
                default: {
                    value = null;
                }
            }
            if (value == null) continue;
            if (this.compareValues(value, stylesheetParameterDescriptor.getDefaultValue())) {
                this.removeStylesheetParameter(request, prefScope, name);
                continue;
            }
            stylesheetParameters.put((Object)name, (Object)value);
        }
        return stylesheetParameters;
    }

    @Transactional
    public void clearStylesheetParameters(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope) {
        HttpSession session;
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
        if (stylesheetUserPreferences != null) {
            stylesheetUserPreferences.clearStylesheetParameters();
            this.stylesheetUserPreferencesDao.storeStylesheetUserPreferences(stylesheetUserPreferences);
        }
        if ((session = request.getSession(false)) != null) {
            session.removeAttribute(STYLESHEET_PARAMETERS_KEY + stylesheetPreferencesKey.toString());
        }
        request.removeAttribute(STYLESHEET_PARAMETERS_KEY + stylesheetPreferencesKey.toString());
    }

    public String getLayoutAttribute(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, String nodeId, String name) {
        String value;
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetDescriptor stylesheetDescriptor = StylesheetPreferencesKey.access$200((StylesheetPreferencesKey)stylesheetPreferencesKey);
        ILayoutAttributeDescriptor layoutAttributeDescriptor = stylesheetDescriptor.getLayoutAttributeDescriptor(name);
        if (layoutAttributeDescriptor == null) {
            this.logger.warn("Attempted to get layout attribute {} for ID=\"{}\" but no such stylesheet parameter is defined in stylesheet descriptor {}. Null will be returned", new Object[]{name, nodeId, stylesheetDescriptor.getName()});
            return null;
        }
        String defaultValue = null;
        IStylesheetUserPreferences distributedStylesheetUserPreferences = this.getDistributedStylesheetUserPreferences(request, prefScope);
        if (distributedStylesheetUserPreferences != null && this.compareValues(defaultValue = distributedStylesheetUserPreferences.getLayoutAttribute(nodeId, name), layoutAttributeDescriptor.getDefaultValue())) {
            distributedStylesheetUserPreferences.removeLayoutAttribute(nodeId, name);
            defaultValue = null;
        }
        IStylesheetData.Scope scope = layoutAttributeDescriptor.getScope();
        switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
            case 3: {
                IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
                if (stylesheetUserPreferences == null) {
                    value = null;
                    break;
                }
                value = stylesheetUserPreferences.getLayoutAttribute(nodeId, name);
                break;
            }
            default: {
                Map nodeAttributes = (Map)this.getDataValue(request, stylesheetPreferencesKey, scope, LAYOUT_ATTRIBUTES_KEY, nodeId);
                if (nodeAttributes == null) {
                    value = null;
                    break;
                }
                value = (String)nodeAttributes.get(name);
                break;
            }
        }
        if (value == null) {
            return defaultValue;
        }
        if (this.compareValues(value, layoutAttributeDescriptor.getDefaultValue()) || defaultValue != null && this.compareValues(value, defaultValue)) {
            this.removeLayoutAttribute(request, prefScope, nodeId, name);
            return null;
        }
        return value;
    }

    private String getCacheKey(StylesheetPreferencesKey stylesheetPreferencesKey) {
        return NO_PERSISTENT_IStylesheetUserPreferences + "." + stylesheetPreferencesKey.toString();
    }

    private IStylesheetUserPreferences getStylesheetUserPreferences(HttpServletRequest request, StylesheetPreferencesKey stylesheetPreferencesKey) {
        String key = this.getCacheKey(stylesheetPreferencesKey);
        if (request.getAttribute(key) != null) {
            return null;
        }
        HttpSession session = request.getSession();
        if (session.getAttribute(key) != null) {
            request.setAttribute(key, (Object)Boolean.TRUE);
            return null;
        }
        IStylesheetUserPreferences stylesheetUserPreferences = this.stylesheetUserPreferencesDao.getStylesheetUserPreferences(StylesheetPreferencesKey.access$200((StylesheetPreferencesKey)stylesheetPreferencesKey), StylesheetPreferencesKey.access$100((StylesheetPreferencesKey)stylesheetPreferencesKey), StylesheetPreferencesKey.access$300((StylesheetPreferencesKey)stylesheetPreferencesKey));
        if (stylesheetUserPreferences == null) {
            session.setAttribute(key, (Object)Boolean.TRUE);
            request.setAttribute(key, (Object)Boolean.TRUE);
        }
        return stylesheetUserPreferences;
    }

    private void clearStylesheetUserPreferencesCache(HttpServletRequest request, StylesheetPreferencesKey stylesheetPreferencesKey) {
        String key = this.getCacheKey(stylesheetPreferencesKey);
        request.removeAttribute(key);
        HttpSession session = request.getSession();
        session.removeAttribute(key);
    }

    protected ConcurrentMap<String, Map<String, String>> getRequestLayoutAttributes(HttpServletRequest request, StylesheetPreferencesKey stylesheetPreferencesKey) {
        return PortalWebUtils.getMapRequestAttribute((ServletRequest)request, (String)(LAYOUT_ATTRIBUTES_KEY + stylesheetPreferencesKey.toString()), (boolean)false);
    }

    protected ConcurrentMap<String, Map<String, String>> getSessionLayoutAttributes(HttpSession session, StylesheetPreferencesKey stylesheetPreferencesKey) {
        return PortalWebUtils.getMapSessionAttribute((HttpSession)session, (String)(LAYOUT_ATTRIBUTES_KEY + stylesheetPreferencesKey.toString()), (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public String setLayoutAttribute(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, String nodeId, String name, String value) {
        ConcurrentHashMap<String, String> nodeAttributes;
        Object mutex;
        String defaultValue;
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetDescriptor stylesheetDescriptor = StylesheetPreferencesKey.access$200((StylesheetPreferencesKey)stylesheetPreferencesKey);
        ILayoutAttributeDescriptor layoutAttributeDescriptor = stylesheetDescriptor.getLayoutAttributeDescriptor(name);
        if (layoutAttributeDescriptor == null) {
            this.logger.warn("Attempted to set layout attribute {}={} on node with ID=\"{}\" but no such stylesheet parameter is defined in stylesheet descriptor {}. It will be ignored.", new Object[]{name, value, nodeId, stylesheetDescriptor.getName()});
            return null;
        }
        if (this.compareValues(value, layoutAttributeDescriptor.getDefaultValue())) {
            return this.removeLayoutAttribute(request, prefScope, nodeId, name);
        }
        IStylesheetUserPreferences distributedStylesheetUserPreferences = this.getDistributedStylesheetUserPreferences(request, prefScope);
        if (distributedStylesheetUserPreferences != null && this.compareValues(value, defaultValue = distributedStylesheetUserPreferences.getLayoutAttribute(nodeId, name))) {
            return this.removeLayoutAttribute(request, prefScope, nodeId, name);
        }
        IStylesheetData.Scope scope = this.getWriteScope(request, prefScope, stylesheetPreferencesKey, (IStylesheetData)layoutAttributeDescriptor);
        switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
            case 3: {
                IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
                if (stylesheetUserPreferences == null) {
                    stylesheetUserPreferences = this.stylesheetUserPreferencesDao.createStylesheetUserPreferences(stylesheetDescriptor, StylesheetPreferencesKey.access$100((StylesheetPreferencesKey)stylesheetPreferencesKey), StylesheetPreferencesKey.access$300((StylesheetPreferencesKey)stylesheetPreferencesKey));
                    this.clearStylesheetUserPreferencesCache(request, stylesheetPreferencesKey);
                }
                String oldValue = stylesheetUserPreferences.setLayoutAttribute(nodeId, name, value);
                this.stylesheetUserPreferencesDao.storeStylesheetUserPreferences(stylesheetUserPreferences);
                return oldValue;
            }
        }
        switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
            case 2: {
                mutex = PortalWebUtils.getRequestAttributeMutex((ServletRequest)request);
                break;
            }
            case 1: {
                HttpSession session = request.getSession();
                mutex = WebUtils.getSessionMutex((HttpSession)session);
                break;
            }
            default: {
                mutex = new Object();
            }
        }
        Object object = mutex;
        synchronized (object) {
            nodeAttributes = (ConcurrentHashMap<String, String>)this.getDataValue(request, stylesheetPreferencesKey, scope, LAYOUT_ATTRIBUTES_KEY, nodeId);
            if (nodeAttributes == null) {
                nodeAttributes = new ConcurrentHashMap<String, String>();
                this.putDataValue(request, stylesheetPreferencesKey, scope, LAYOUT_ATTRIBUTES_KEY, nodeId, nodeAttributes);
            }
        }
        return nodeAttributes.put(name, value);
    }

    @Transactional
    public String removeLayoutAttribute(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, String nodeId, String name) {
        IStylesheetUserPreferences distributedStylesheetUserPreferences;
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetDescriptor stylesheetDescriptor = StylesheetPreferencesKey.access$200((StylesheetPreferencesKey)stylesheetPreferencesKey);
        ILayoutAttributeDescriptor layoutAttributeDescriptor = stylesheetDescriptor.getLayoutAttributeDescriptor(name);
        if (layoutAttributeDescriptor == null) {
            this.logger.warn("Attempted to remove layout attribute {} for ID=\"{}\" but no such stylesheet parameter is defined in stylesheet descriptor {}. It will be ignored.", new Object[]{name, nodeId, stylesheetDescriptor.getName()});
            return null;
        }
        IStylesheetData.Scope scope = this.getWriteScope(request, prefScope, stylesheetPreferencesKey, (IStylesheetData)layoutAttributeDescriptor);
        switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
            case 3: {
                IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
                if (stylesheetUserPreferences == null) break;
                String oldValue = stylesheetUserPreferences.removeLayoutAttribute(nodeId, name);
                if (oldValue != null) {
                    this.stylesheetUserPreferencesDao.storeStylesheetUserPreferences(stylesheetUserPreferences);
                    return oldValue;
                }
            }
            default: {
                String oldValue;
                Map nodeAttributes = (Map)this.getDataValue(request, stylesheetPreferencesKey, scope, LAYOUT_ATTRIBUTES_KEY, nodeId);
                if (nodeAttributes == null || (oldValue = (String)nodeAttributes.remove(name)) == null) break;
                return oldValue;
            }
        }
        if ((distributedStylesheetUserPreferences = this.getDistributedStylesheetUserPreferences(request, prefScope)) != null) {
            return distributedStylesheetUserPreferences.removeLayoutAttribute(nodeId, name);
        }
        return null;
    }

    public Iterable<String> getAllLayoutAttributeNodeIds(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope) {
        IStylesheetUserPreferences distributedStylesheetUserPreferences;
        ConcurrentMap requestLayoutAttributes;
        ConcurrentMap sessionLayoutAttributes;
        HttpSession session;
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        LinkedHashSet<String> allNodeIds = new LinkedHashSet<String>();
        IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
        if (stylesheetUserPreferences != null) {
            allNodeIds.addAll(stylesheetUserPreferences.getAllLayoutAttributeNodeIds());
        }
        if ((session = request.getSession(false)) != null && (sessionLayoutAttributes = this.getSessionLayoutAttributes(session, stylesheetPreferencesKey)) != null) {
            allNodeIds.addAll(sessionLayoutAttributes.keySet());
        }
        if ((requestLayoutAttributes = this.getRequestLayoutAttributes(request, stylesheetPreferencesKey)) != null) {
            allNodeIds.addAll(requestLayoutAttributes.keySet());
        }
        if ((distributedStylesheetUserPreferences = this.getDistributedStylesheetUserPreferences(request, prefScope)) != null) {
            allNodeIds.addAll(distributedStylesheetUserPreferences.getAllLayoutAttributeNodeIds());
        }
        return allNodeIds;
    }

    public Map<String, String> getAllNodesAndValuesForAttribute(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, String name) {
        ConcurrentMap requestLayoutAttributes;
        HttpSession session;
        Map allNodesAndValuesForAttribute;
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
        ImmutableMap.Builder result = ImmutableMap.builder();
        IStylesheetUserPreferences distributedStylesheetUserPreferences = this.getDistributedStylesheetUserPreferences(request, prefScope);
        if (distributedStylesheetUserPreferences != null) {
            allNodesAndValuesForAttribute = distributedStylesheetUserPreferences.getAllNodesAndValuesForAttribute(name);
            result.putAll(allNodesAndValuesForAttribute);
        }
        if (stylesheetUserPreferences != null) {
            allNodesAndValuesForAttribute = stylesheetUserPreferences.getAllNodesAndValuesForAttribute(name);
            result.putAll(allNodesAndValuesForAttribute);
        }
        if ((session = request.getSession(false)) != null) {
            ConcurrentMap sessionLayoutAttributes = this.getSessionLayoutAttributes(session, stylesheetPreferencesKey);
            this.getAllNodesAndValuesForAttribute((Map)sessionLayoutAttributes, name, result);
        }
        if ((requestLayoutAttributes = this.getRequestLayoutAttributes(request, stylesheetPreferencesKey)) != null) {
            this.getAllNodesAndValuesForAttribute((Map)requestLayoutAttributes, name, result);
        }
        return result.build();
    }

    protected void getAllNodesAndValuesForAttribute(Map<String, Map<String, String>> layoutAttributes, String name, ImmutableMap.Builder<String, String> result) {
        if (layoutAttributes == null) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> layoutNodeAttributesEntry : layoutAttributes.entrySet()) {
            Map<String, String> layoutNodeAttribute = layoutNodeAttributesEntry.getValue();
            String value = layoutNodeAttribute.get(name);
            if (value == null) continue;
            String nodeId = layoutNodeAttributesEntry.getKey();
            result.put((Object)nodeId, (Object)value);
        }
    }

    public <P extends Populator<String, String>> P populateLayoutAttributes(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, String nodeId, P layoutAttributes) {
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetDescriptor stylesheetDescriptor = StylesheetPreferencesKey.access$200((StylesheetPreferencesKey)stylesheetPreferencesKey);
        IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
        HttpSession session = request.getSession(false);
        ConcurrentMap sessionLayoutAttributes = session == null ? null : this.getSessionLayoutAttributes(session, stylesheetPreferencesKey);
        ConcurrentMap requestLayoutAttributes = this.getRequestLayoutAttributes(request, stylesheetPreferencesKey);
        IStylesheetUserPreferences distributedStylesheetUserPreferences = this.getDistributedStylesheetUserPreferences(request, prefScope);
        if (distributedStylesheetUserPreferences != null) {
            distributedStylesheetUserPreferences.populateLayoutAttributes(nodeId, layoutAttributes);
        }
        for (ILayoutAttributeDescriptor layoutAttributeDescriptor : stylesheetDescriptor.getLayoutAttributeDescriptors()) {
            String value;
            String name = layoutAttributeDescriptor.getName();
            IStylesheetData.Scope scope = layoutAttributeDescriptor.getScope();
            switch (2.$SwitchMap$org$jasig$portal$layout$om$IStylesheetData$Scope[scope.ordinal()]) {
                case 3: {
                    if (stylesheetUserPreferences == null) {
                        value = null;
                        break;
                    }
                    value = stylesheetUserPreferences.getLayoutAttribute(nodeId, name);
                    break;
                }
                case 1: {
                    if (sessionLayoutAttributes == null) {
                        value = null;
                        break;
                    }
                    Map nodeAttributes = (Map)sessionLayoutAttributes.get(nodeId);
                    if (nodeAttributes == null) {
                        value = null;
                        break;
                    }
                    value = (String)nodeAttributes.get(name);
                    break;
                }
                case 2: {
                    if (requestLayoutAttributes == null) {
                        value = null;
                        break;
                    }
                    Map nodeAttributes = (Map)requestLayoutAttributes.get(nodeId);
                    if (nodeAttributes == null) {
                        value = null;
                        break;
                    }
                    value = (String)nodeAttributes.get(name);
                    break;
                }
                default: {
                    value = null;
                }
            }
            if (value == null) continue;
            if (this.compareValues(value, layoutAttributeDescriptor.getDefaultValue())) {
                this.removeLayoutAttribute(request, prefScope, nodeId, name);
                continue;
            }
            layoutAttributes.put((Object)name, (Object)value);
        }
        return layoutAttributes;
    }

    @Transactional
    public void clearLayoutAttributes(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope, String nodeId) {
        ConcurrentMap requestLayoutAttributes;
        ConcurrentMap sessionLayoutAttributes;
        HttpSession session;
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
        if (stylesheetUserPreferences != null) {
            stylesheetUserPreferences.clearLayoutAttributes(nodeId);
            this.stylesheetUserPreferencesDao.storeStylesheetUserPreferences(stylesheetUserPreferences);
        }
        if ((session = request.getSession(false)) != null && (sessionLayoutAttributes = this.getSessionLayoutAttributes(session, stylesheetPreferencesKey)) != null) {
            sessionLayoutAttributes.remove(nodeId);
        }
        if ((requestLayoutAttributes = this.getRequestLayoutAttributes(request, stylesheetPreferencesKey)) != null) {
            requestLayoutAttributes.remove(nodeId);
        }
    }

    @Transactional
    public void clearAllLayoutAttributes(HttpServletRequest request, IStylesheetUserPreferencesService.PreferencesScope prefScope) {
        HttpSession session;
        StylesheetPreferencesKey stylesheetPreferencesKey = this.getStylesheetPreferencesKey(request, prefScope);
        IStylesheetUserPreferences stylesheetUserPreferences = this.getStylesheetUserPreferences(request, stylesheetPreferencesKey);
        if (stylesheetUserPreferences != null) {
            stylesheetUserPreferences.clearAllLayoutAttributes();
            this.stylesheetUserPreferencesDao.storeStylesheetUserPreferences(stylesheetUserPreferences);
        }
        if ((session = request.getSession(false)) != null) {
            session.removeAttribute(LAYOUT_ATTRIBUTES_KEY + stylesheetPreferencesKey.toString());
        }
        request.removeAttribute(LAYOUT_ATTRIBUTES_KEY + stylesheetPreferencesKey.toString());
    }
}

