/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayout;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.TransientUserLayoutXMLEventReader;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.layout.node.UserLayoutChannelDescription;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionParameter;
import org.jasig.portal.spring.locator.PortletDefinitionRegistryLocator;
import org.w3c.dom.Document;

public class TransientUserLayoutManagerWrapper
implements IUserLayoutManager {
    private static final Log log = LogFactory.getLog(TransientUserLayoutManagerWrapper.class);
    public static final String TRANSIENT_FOLDER_ID = "ft1";
    public static final String SUBSCRIBE_PREFIX = "ctf";
    private IUserLayoutManager man = null;
    private Map<String, String> mFnameMap = Collections.synchronizedMap(new HashMap());
    private Map<String, String> mSubIdMap = Collections.synchronizedMap(new HashMap());
    private Map<String, IPortletDefinition> mChanMap = Collections.synchronizedMap(new HashMap());
    private String mFocusedId = "";
    private int mSubId = 0;

    public TransientUserLayoutManagerWrapper(IUserLayoutManager manager) throws PortalException {
        this.man = manager;
        if (this.man == null) {
            throw new PortalException("Cannot wrap a null IUserLayoutManager !");
        }
    }

    public IUserLayoutManager getOriginalLayoutManager() throws PortalException {
        return this.man;
    }

    public void setOriginalLayoutManager(IUserLayoutManager man) throws PortalException {
        this.man = man;
    }

    public IUserLayout getUserLayout() throws PortalException {
        return this.man.getUserLayout();
    }

    public XMLEventReader getUserLayoutReader() {
        XMLEventReader userLayoutReader = this.man.getUserLayoutReader();
        return new TransientUserLayoutXMLEventReader(this, userLayoutReader);
    }

    public Document getUserLayoutDOM() throws PortalException {
        return this.man.getUserLayoutDOM();
    }

    public void loadUserLayout() throws PortalException {
        this.man.loadUserLayout();
    }

    public void loadUserLayout(boolean reload) throws PortalException {
        this.man.loadUserLayout(reload);
    }

    public void saveUserLayout() throws PortalException {
        this.man.saveUserLayout();
    }

    public Set<String> getAllSubscribedChannels() {
        LinkedHashSet<String> allSubscribedChannels = new LinkedHashSet<String>(this.man.getAllSubscribedChannels());
        for (String subscribeId : this.mSubIdMap.keySet()) {
            allSubscribedChannels.add(subscribeId);
        }
        return allSubscribedChannels;
    }

    public IUserLayoutNodeDescription getNode(String nodeId) throws PortalException {
        IUserLayoutNodeDescription ulnd;
        block3: {
            ulnd = null;
            try {
                ulnd = this.man.getNode(nodeId);
            }
            catch (PortalException pe) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Node '" + nodeId + "' is not in layout, " + "checking for a transient node..."));
            }
        }
        if (null == ulnd) {
            ulnd = this.getTransientNode(nodeId);
        }
        return ulnd;
    }

    public IUserLayoutNodeDescription addNode(IUserLayoutNodeDescription node, String parentId, String nextSiblingId) throws PortalException {
        return this.man.addNode(node, parentId, nextSiblingId);
    }

    public boolean moveNode(String nodeId, String parentId, String nextSiblingId) throws PortalException {
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.moveNode(nodeId, parentId, nextSiblingId);
        }
        return false;
    }

    public boolean deleteNode(String nodeId) throws PortalException {
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.deleteNode(nodeId);
        }
        return false;
    }

    public boolean updateNode(IUserLayoutNodeDescription node) throws PortalException {
        String nodeId = node.getId();
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.updateNode(node);
        }
        return false;
    }

    public boolean canAddNode(IUserLayoutNodeDescription node, String parentId, String nextSiblingId) throws PortalException {
        return this.man.canAddNode(node, parentId, nextSiblingId);
    }

    public boolean canMoveNode(String nodeId, String parentId, String nextSiblingId) throws PortalException {
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.canMoveNode(nodeId, parentId, nextSiblingId);
        }
        return false;
    }

    public boolean canDeleteNode(String nodeId) throws PortalException {
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.canDeleteNode(nodeId);
        }
        return false;
    }

    public boolean canUpdateNode(IUserLayoutNodeDescription node) throws PortalException {
        String nodeId = node.getId();
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.canUpdateNode(node);
        }
        return false;
    }

    public void markAddTargets(IUserLayoutNodeDescription node) throws PortalException {
        this.man.markAddTargets(node);
    }

    public void markMoveTargets(String nodeId) throws PortalException {
        this.man.markMoveTargets(nodeId);
    }

    public String getParentId(String nodeId) throws PortalException {
        if (this.mChanMap.containsKey(nodeId) || TRANSIENT_FOLDER_ID.equals(nodeId)) {
            return null;
        }
        return this.man.getParentId(nodeId);
    }

    public Enumeration getChildIds(String nodeId) throws PortalException {
        return this.man.getChildIds(nodeId);
    }

    public String getNextSiblingId(String nodeId) throws PortalException {
        return this.man.getNextSiblingId(nodeId);
    }

    public String getPreviousSiblingId(String nodeId) throws PortalException {
        return this.man.getPreviousSiblingId(nodeId);
    }

    public String getCacheKey() throws PortalException {
        return this.man.getCacheKey();
    }

    public int getLayoutId() {
        return this.man.getLayoutId();
    }

    public String getRootFolderId() {
        return this.man.getRootFolderId();
    }

    public int getDepth(String nodeId) throws PortalException {
        return this.man.getDepth(nodeId);
    }

    public IUserLayoutNodeDescription createNodeDescription(IUserLayoutNodeDescription.LayoutNodeType nodeType) throws PortalException {
        return this.man.createNodeDescription(nodeType);
    }

    protected IPortletDefinition getChannelDefinition(String subId) throws PortalException {
        IPortletDefinition chanDef = (IPortletDefinition)this.mChanMap.get(subId);
        if (null == chanDef) {
            String fname = this.getFname(subId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("TransientUserLayoutManagerWrapper>>getChannelDefinition, attempting to get a channel definition using functional name: " + fname));
            }
            try {
                chanDef = PortletDefinitionRegistryLocator.getPortletDefinitionRegistry().getPortletDefinitionByFname(fname);
            }
            catch (Exception e) {
                throw new PortalException("Failed to get channel information for subscribeId: " + subId);
            }
            this.mChanMap.put(subId, chanDef);
        }
        return chanDef;
    }

    public String getFname(String subId) {
        return (String)this.mSubIdMap.get(subId);
    }

    public boolean isTransientChannel(String subId) {
        return this.mSubIdMap.containsKey(subId);
    }

    public String getSubscribeId(String fname) throws PortalException {
        String subId = (String)this.mFnameMap.get(fname);
        if (subId == null) {
            subId = this.man.getSubscribeId(fname);
        }
        if (subId == null) {
            try {
                IPortletDefinition chanDef = PortletDefinitionRegistryLocator.getPortletDefinitionRegistry().getPortletDefinitionByFname(fname);
                if (chanDef != null) {
                    subId = this.getNextSubscribeId();
                    this.mFnameMap.put(fname, subId);
                    this.mSubIdMap.put(subId, fname);
                    this.mChanMap.put(subId, chanDef);
                }
            }
            catch (Exception e) {
                log.error((Object)("TransientUserLayoutManagerWrapper::getSubscribeId() : an exception encountered while trying to obtain ChannelDefinition for fname \"" + fname + "\" : " + e));
                subId = null;
            }
        }
        return subId;
    }

    public String getSubscribeId(String parentFolderId, String fname) {
        return this.man.getSubscribeId(parentFolderId, fname);
    }

    public String getFocusedId() {
        return this.mFocusedId;
    }

    public void setFocusedId(String subscribeId) {
        this.mFocusedId = subscribeId;
    }

    private IUserLayoutChannelDescription getTransientNode(String nodeId) throws PortalException {
        String fname = this.getFname(nodeId);
        if (null == fname || fname.equals("")) {
            return null;
        }
        try {
            IPortletDefinition chanDef = (IPortletDefinition)this.mChanMap.get(nodeId);
            if (null == chanDef) {
                chanDef = PortletDefinitionRegistryLocator.getPortletDefinitionRegistry().getPortletDefinitionByFname(fname);
                this.mChanMap.put(nodeId, chanDef);
            }
            return this.createUserLayoutChannelDescription(nodeId, chanDef);
        }
        catch (Exception e) {
            throw new PortalException("Failed to obtain channel definition using fname: " + fname);
        }
    }

    protected IUserLayoutChannelDescription createUserLayoutChannelDescription(String nodeId, IPortletDefinition chanDef) {
        UserLayoutChannelDescription ulnd = new UserLayoutChannelDescription();
        ulnd.setId(nodeId);
        ulnd.setName(chanDef.getName());
        ulnd.setUnremovable(true);
        ulnd.setImmutable(true);
        ulnd.setHidden(false);
        ulnd.setTitle(chanDef.getTitle());
        ulnd.setDescription(chanDef.getDescription());
        ulnd.setChannelPublishId("" + chanDef.getPortletDefinitionId().getStringId());
        ulnd.setChannelTypeId("" + chanDef.getType().getId());
        ulnd.setFunctionalName(chanDef.getFName());
        ulnd.setTimeout((long)chanDef.getTimeout());
        Set parms = chanDef.getParameters();
        for (IPortletDefinitionParameter parm : parms) {
            ulnd.setParameterValue(parm.getName(), parm.getValue());
        }
        return ulnd;
    }

    private synchronized String getNextSubscribeId() {
        ++this.mSubId;
        return SUBSCRIBE_PREFIX + this.mSubId;
    }
}

