/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dao.jpa;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Type;
import org.jasig.portal.dao.usertype.FunctionalNameType;
import org.jasig.portal.layout.dao.jpa.LayoutAttributeDescriptorImpl;
import org.jasig.portal.layout.dao.jpa.OutputPropertyDescriptorImpl;
import org.jasig.portal.layout.dao.jpa.StylesheetDescriptorImpl;
import org.jasig.portal.layout.dao.jpa.StylesheetParameterDescriptorImpl;
import org.jasig.portal.layout.dao.jpa.StylesheetUserPreferencesImpl;
import org.jasig.portal.layout.om.ILayoutAttributeDescriptor;
import org.jasig.portal.layout.om.IOutputPropertyDescriptor;
import org.jasig.portal.layout.om.IStylesheetData;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.layout.om.IStylesheetParameterDescriptor;
import org.jasig.portal.layout.om.IStylesheetUserPreferences;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="UP_SS_DESC")
@SequenceGenerator(name="UP_SS_DESC_GEN", sequenceName="UP_SS_DESC_SEQ", allocationSize=5)
@TableGenerator(name="UP_SS_DESC_GEN", pkColumnValue="UP_SS_DESC", allocationSize=5)
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class StylesheetDescriptorImpl
implements IStylesheetDescriptor {
    @Id
    @GeneratedValue(generator="UP_SS_DESC_GEN")
    @Column(name="SS_DESC_ID")
    private final long id;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @OneToMany(mappedBy="stylesheetDescriptor", targetEntity=StylesheetUserPreferencesImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    private Set<IStylesheetUserPreferences> stylesheetUserPreferences = null;
    @NaturalId
    @Column(name="SS_NAME", length=100, nullable=false)
    @Type(type="fname")
    private final String name;
    @Column(name="URL_SYNTAX_HELPER_NAME", length=100)
    private String urlNodeSyntaxHelperName;
    @Column(name="DESCRIPTION", length=2000)
    private String description;
    @Column(name="STYLESHEET", length=2000, nullable=false)
    private String stylesheetResource;
    @OneToMany(targetEntity=OutputPropertyDescriptorImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    @JoinColumn(name="SS_DESC_ID", nullable=false)
    @MapKey(name="name")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private Map<String, IOutputPropertyDescriptor> outputProperties = new LinkedHashMap(0);
    @OneToMany(targetEntity=StylesheetParameterDescriptorImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    @MapKey(name="name")
    @JoinColumn(name="SS_DESC_ID", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private Map<String, IStylesheetParameterDescriptor> stylesheetParameters = new LinkedHashMap(0);
    @OneToMany(targetEntity=LayoutAttributeDescriptorImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    @MapKey(name="name")
    @JoinColumn(name="SS_DESC_ID", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private Map<String, ILayoutAttributeDescriptor> layoutAttributes = new LinkedHashMap(0);
    private static final StylesheetDataUpdater<ILayoutAttributeDescriptor> LAYOUT_ATTRIBUTE_DESCRIPTOR_UPDATER = new /* Unavailable Anonymous Inner Class!! */;

    private StylesheetDescriptorImpl() {
        this.id = -1L;
        this.entityVersion = -1L;
        this.name = null;
    }

    StylesheetDescriptorImpl(String name, String stylesheetResource) {
        FunctionalNameType.validate((String)name);
        this.id = -1L;
        this.entityVersion = -1L;
        this.name = name;
        this.setStylesheetResource(stylesheetResource);
    }

    public String getDataId() {
        return this.getName();
    }

    public String getDataTitle() {
        return this.getName();
    }

    public String getDataDescription() {
        return this.getDescription();
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setStylesheetResource(String stylesheetResource) {
        Validate.notEmpty((String)stylesheetResource);
        this.stylesheetResource = stylesheetResource;
    }

    public String getStylesheetResource() {
        return this.stylesheetResource;
    }

    public void setUrlNodeSyntaxHelperName(String urlNodeSyntaxHelperName) {
        this.urlNodeSyntaxHelperName = urlNodeSyntaxHelperName;
    }

    public String getUrlNodeSyntaxHelperName() {
        return this.urlNodeSyntaxHelperName;
    }

    public Collection<IOutputPropertyDescriptor> getOutputPropertyDescriptors() {
        return Collections.unmodifiableCollection(this.outputProperties.values());
    }

    public void setOutputPropertyDescriptors(Collection<IOutputPropertyDescriptor> outputPropertyDescriptors) {
        this.setMap(this.outputProperties, outputPropertyDescriptors, (Updater)StylesheetDataUpdater.getInstance());
    }

    public IOutputPropertyDescriptor getOutputPropertyDescriptor(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        return (IOutputPropertyDescriptor)this.outputProperties.get(name);
    }

    public IOutputPropertyDescriptor setOutputPropertyDescriptor(IOutputPropertyDescriptor outputPropertyDescriptor) {
        return this.outputProperties.put(outputPropertyDescriptor.getName(), outputPropertyDescriptor);
    }

    public IOutputPropertyDescriptor removeOutputPropertyDescriptor(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        return (IOutputPropertyDescriptor)this.outputProperties.remove(name);
    }

    public Collection<IStylesheetParameterDescriptor> getStylesheetParameterDescriptors() {
        return Collections.unmodifiableCollection(this.stylesheetParameters.values());
    }

    public void setStylesheetParameterDescriptors(Collection<IStylesheetParameterDescriptor> stylesheetParameterDescriptors) {
        this.setMap(this.stylesheetParameters, stylesheetParameterDescriptors, (Updater)StylesheetDataUpdater.getInstance());
    }

    public IStylesheetParameterDescriptor getStylesheetParameterDescriptor(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        return (IStylesheetParameterDescriptor)this.stylesheetParameters.get(name);
    }

    public IStylesheetParameterDescriptor setStylesheetParameterDescriptor(IStylesheetParameterDescriptor stylesheetParameterDescriptor) {
        return this.stylesheetParameters.put(stylesheetParameterDescriptor.getName(), stylesheetParameterDescriptor);
    }

    public IStylesheetParameterDescriptor removeStylesheetParameterDescriptor(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        return (IStylesheetParameterDescriptor)this.stylesheetParameters.remove(name);
    }

    public Collection<ILayoutAttributeDescriptor> getLayoutAttributeDescriptors() {
        return Collections.unmodifiableCollection(this.layoutAttributes.values());
    }

    public void setLayoutAttributeDescriptors(Collection<ILayoutAttributeDescriptor> layoutAttributeDescriptors) {
        this.setMap(this.layoutAttributes, layoutAttributeDescriptors, (Updater)LAYOUT_ATTRIBUTE_DESCRIPTOR_UPDATER);
    }

    public ILayoutAttributeDescriptor getLayoutAttributeDescriptor(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        return (ILayoutAttributeDescriptor)this.layoutAttributes.get(name);
    }

    public ILayoutAttributeDescriptor setLayoutAttributeDescriptor(ILayoutAttributeDescriptor layoutAttributeDescriptor) {
        return this.layoutAttributes.put(layoutAttributeDescriptor.getName(), layoutAttributeDescriptor);
    }

    public ILayoutAttributeDescriptor removeLayoutAttributeDescriptor(String name) {
        return (ILayoutAttributeDescriptor)this.layoutAttributes.remove(name);
    }

    protected <T extends IStylesheetData> void setMap(Map<String, T> dataMap, Collection<T> dataCollection, Updater<T> updater) {
        HashSet<String> oldDataKeys = new HashSet<String>(dataMap.keySet());
        for (IStylesheetData newData : dataCollection) {
            String name = newData.getName();
            oldDataKeys.remove(name);
            IStylesheetData oldData = (IStylesheetData)dataMap.get(name);
            if (oldData != null) {
                newData = (IStylesheetData)updater.update((Object)oldData, (Object)newData);
            }
            dataMap.put(name, newData);
        }
        dataMap.keySet().remove(oldDataKeys);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StylesheetDescriptorImpl other = (StylesheetDescriptorImpl)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "StylesheetDescriptorImpl [id=" + this.id + ", entityVersion=" + this.entityVersion + ", name=" + this.name + ", urlNodeSyntaxHelperName=" + this.urlNodeSyntaxHelperName + ", description=" + this.description + ", stylesheetResource=" + this.stylesheetResource + "]";
    }
}

