/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.PortalException;
import org.jasig.portal.events.IPortalLayoutEventFactory;
import org.jasig.portal.layout.IFolderLocalNameResolver;
import org.jasig.portal.layout.IUserLayout;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.PortletSubscribeIdResolver;
import org.jasig.portal.layout.dlm.ChannelDescription;
import org.jasig.portal.layout.dlm.DistributedUserLayout;
import org.jasig.portal.layout.dlm.FragmentChannelInfo;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.layout.dlm.FragmentNodeInfo;
import org.jasig.portal.layout.dlm.HandlerUtils;
import org.jasig.portal.layout.dlm.ILayoutCachingService;
import org.jasig.portal.layout.dlm.ILayoutProcessingAction;
import org.jasig.portal.layout.dlm.LPAAddParameter;
import org.jasig.portal.layout.dlm.LPAChangeAttribute;
import org.jasig.portal.layout.dlm.LPAChangeParameter;
import org.jasig.portal.layout.dlm.LPAEditRestriction;
import org.jasig.portal.layout.dlm.LPARemoveParameter;
import org.jasig.portal.layout.dlm.LPAResetAttribute;
import org.jasig.portal.layout.dlm.LPAResetParameter;
import org.jasig.portal.layout.dlm.MovementRules;
import org.jasig.portal.layout.dlm.RDBMDistributedLayoutStore;
import org.jasig.portal.layout.dlm.TabColumnPrefsHandler;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.layout.node.IUserLayoutFolderDescription;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.layout.node.UserLayoutFolderDescription;
import org.jasig.portal.layout.simple.SimpleLayout;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionParameter;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.security.AdminEvaluator;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.spring.locator.PortletDefinitionRegistryLocator;
import org.jasig.portal.spring.locator.UserIdentityStoreLocator;
import org.jasig.portal.xml.XmlUtilities;
import org.jasig.portal.xml.xpath.XPathOperations;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DistributedLayoutManager
implements IUserLayoutManager,
IFolderLocalNameResolver,
InitializingBean {
    public static final String RCS_ID = "@(#) $Header$";
    private static final Log LOG = LogFactory.getLog(DistributedLayoutManager.class);
    private XmlUtilities xmlUtilities;
    private ILayoutCachingService layoutCachingService;
    private IUserLayoutStore distributedLayoutStore;
    private XPathOperations xpathOperations;
    private IPortalLayoutEventFactory portalEventFactory;
    private IAuthorizationService authorizationService;
    protected final IPerson owner;
    protected final IUserProfile profile;
    static final String FOLDER_LABEL_POLICY = "FolderLabelPolicy";
    protected static final Random rnd = new Random();
    protected String cacheKey = "initialKey";
    protected String rootNodeId = null;
    private boolean channelsAdded = false;
    private boolean isFragmentOwner = false;

    public DistributedLayoutManager(IPerson owner, IUserProfile profile) throws PortalException {
        if (owner == null) {
            throw new PortalException("Unable to instantiate DistributedLayoutManager. A non-null owner must to be specified.");
        }
        if (profile == null) {
            throw new PortalException("Unable to instantiate DistributedLayoutManager for " + owner.getAttribute("username") + ". A " + "non-null profile must to be specified.");
        }
        owner.setAttribute("UserProfile", (Object)profile);
        this.owner = owner;
        this.profile = profile;
    }

    @Autowired
    public void setAuthorizationService(IAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Autowired
    public void setXpathOperations(XPathOperations xpathOperations) {
        this.xpathOperations = xpathOperations;
    }

    @Autowired
    public void setXmlUtilities(XmlUtilities xmlUtilities) {
        this.xmlUtilities = xmlUtilities;
    }

    @Autowired
    public void setLayoutCachingService(ILayoutCachingService layoutCachingService) {
        this.layoutCachingService = layoutCachingService;
    }

    @Autowired
    public void setDistributedLayoutStore(IUserLayoutStore distributedLayoutStore) {
        this.distributedLayoutStore = distributedLayoutStore;
    }

    @Autowired
    public void setPortalEventFactory(IPortalLayoutEventFactory portalEventFactory) {
        this.portalEventFactory = portalEventFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.owner.isGuest()) {
            this.layoutCachingService.removeCachedLayout(this.owner, this.profile);
        }
        this.loadUserLayout();
        this.getRootFolderId();
    }

    private void setUserLayoutDOM(DistributedUserLayout userLayout) {
        this.layoutCachingService.cacheLayout(this.owner, this.profile, userLayout);
        this.updateCacheKey();
        Element layout = userLayout.getLayout().getDocumentElement();
        Attr attr = layout.getAttributeNodeNS("http://www.uportal.org/layout/dlm", "fragmentName");
        this.isFragmentOwner = attr != null;
    }

    @Deprecated
    public Document getUserLayoutDOM() {
        DistributedUserLayout userLayout = this.getDistributedUserLayout();
        return userLayout.getLayout();
    }

    protected DistributedUserLayout getDistributedUserLayout() {
        DistributedUserLayout userLayout = this.layoutCachingService.getCachedLayout(this.owner, this.profile);
        if (null == userLayout) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Load from store for " + this.owner.getAttribute("username")));
            }
            userLayout = this.distributedLayoutStore.getUserLayout(this.owner, this.profile);
            Document userLayoutDocument = userLayout.getLayout();
            IAuthorizationPrincipal principal = this.authorizationService.newPrincipal(this.owner.getUserName(), IPerson.class);
            NodeList nodes = userLayoutDocument.getElementsByTagName("folder");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element fd = (Element)nodes.item(i);
                String type = fd.getAttribute("type");
                if (type == null || !type.equals("header") && !type.equals("footer") && !type.equals("sidebar")) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RDBMUserLayoutStore examining the '" + type + "' folder of user '" + this.owner.getUserName() + "' for non-authorized channels."));
                }
                NodeList channels = fd.getElementsByTagName("channel");
                for (int j = 0; j < channels.getLength(); ++j) {
                    Element ch = (Element)channels.item(j);
                    try {
                        String chanId = ch.getAttribute("chanID");
                        if (principal.canRender(chanId)) continue;
                        fd.removeChild(ch);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("RDBMUserLayoutStore removing channel '" + ch.getAttribute("fname") + "' from the header or footer of user '" + this.owner.getUserName() + "' because he/she isn't authorized to render it."));
                        continue;
                    }
                    catch (Throwable t) {
                        LOG.warn((Object)("RDBMUserLayoutStore was unable to analyze channel element with Id=" + ch.getAttribute("chanID")), t);
                    }
                }
            }
            this.setUserLayoutDOM(userLayout);
        }
        return userLayout;
    }

    public XMLEventReader getUserLayoutReader() {
        Document ul = this.getUserLayoutDOM();
        if (ul == null) {
            throw new PortalException("User layout has not been initialized for " + this.owner.getAttribute("username"));
        }
        XMLInputFactory xmlInputFactory = this.xmlUtilities.getXmlInputFactory();
        DOMSource layoutSoure = new DOMSource(ul);
        try {
            return xmlInputFactory.createXMLEventReader(layoutSoure);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to create Layout XMLStreamReader for user: " + this.owner.getAttribute("username"), e);
        }
    }

    private Transformer getEmptyTransformer() throws PortalException {
        Transformer xfrmr = null;
        try {
            xfrmr = TransformerFactory.newInstance().newTransformer();
        }
        catch (Exception e) {
            throw new PortalException("Unable to instantiate transformer.", (Throwable)e);
        }
        return xfrmr;
    }

    public synchronized void loadUserLayout() throws PortalException {
        this.loadUserLayout(false);
    }

    public synchronized void loadUserLayout(boolean reload) throws PortalException {
        Document uli = null;
        try {
            if (reload) {
                this.layoutCachingService.removeCachedLayout(this.owner, this.profile);
            }
            uli = this.getUserLayoutDOM();
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered while reading a layout for userId=" + this.owner.getID() + ", profileId=" + this.profile.getProfileId(), (Throwable)e);
        }
        if (uli == null) {
            throw new PortalException("Null user layout returned for ownerId=\"" + this.owner.getID() + "\", profileId=\"" + this.profile.getProfileId() + "\", layoutId=\"" + this.profile.getLayoutId() + "\"");
        }
    }

    public synchronized void saveUserLayout() throws PortalException {
        Document uld = this.getUserLayoutDOM();
        if (uld == null) {
            throw new PortalException("UserLayout has not been initialized for " + this.owner.getAttribute("username") + ".");
        }
        try {
            this.distributedLayoutStore.setUserLayout(this.owner, this.profile, uld, this.channelsAdded);
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered while saving layout for userId=" + this.owner.getID() + ", profileId=" + this.profile.getProfileId(), (Throwable)e);
        }
        this.channelsAdded = false;
    }

    public Set<String> getAllSubscribedChannels() {
        Document uld = this.getUserLayoutDOM();
        if (uld == null) {
            throw new PortalException("UserLayout has not been initialized for " + this.owner.getAttribute("username"));
        }
        NodeList channelElements = uld.getElementsByTagName("channel");
        LinkedHashSet<String> allSubscribedChannels = new LinkedHashSet<String>(channelElements.getLength());
        for (int nodeIndex = 0; nodeIndex < channelElements.getLength(); ++nodeIndex) {
            Element channelElement = (Element)channelElements.item(nodeIndex);
            String subscribeId = channelElement.getAttribute("ID");
            allSubscribedChannels.add(subscribeId);
        }
        return allSubscribedChannels;
    }

    public IUserLayoutNodeDescription getNode(String nodeId) throws PortalException {
        if (nodeId == null) {
            return null;
        }
        Document uld = this.getUserLayoutDOM();
        if (uld == null) {
            throw new PortalException("UserLayout has not been initialized for " + this.owner.getAttribute("username") + ".");
        }
        Element element = uld.getElementById(nodeId);
        if (element == null) {
            throw new PortalException("Element with ID=\"" + nodeId + "\" doesn't exist for " + this.owner.getAttribute("username") + ".");
        }
        IUserLayoutNodeDescription desc = this.createNodeDescription(element);
        if (nodeId.startsWith("u") && desc instanceof ChannelDescription) {
            FragmentChannelInfo info = this.distributedLayoutStore.getFragmentChannelInfo(nodeId);
            ((ChannelDescription)desc).setFragmentChannelInfo(info);
        }
        return desc;
    }

    public IUserLayoutNodeDescription addNode(IUserLayoutNodeDescription node, String parentId, String nextSiblingId) throws PortalException {
        boolean isChannel = false;
        IUserLayoutNodeDescription parent = this.getNode(parentId);
        if (this.canAddNode(node, parent, nextSiblingId)) {
            try {
                if (node instanceof IUserLayoutChannelDescription) {
                    isChannel = true;
                    node.setId(this.distributedLayoutStore.generateNewChannelSubscribeId(this.owner));
                } else {
                    node.setId(this.distributedLayoutStore.generateNewFolderId(this.owner));
                }
            }
            catch (Exception e) {
                throw new PortalException("Exception encountered while generating new user layout node Id for  for " + this.owner.getAttribute("username"), (Throwable)e);
            }
            Document uld = this.getUserLayoutDOM();
            Element childElement = node.getXML(uld);
            Element parentElement = uld.getElementById(parentId);
            if (nextSiblingId == null) {
                parentElement.appendChild(childElement);
            } else {
                Element nextSibling = uld.getElementById(nextSiblingId);
                parentElement.insertBefore(childElement, nextSibling);
            }
            childElement.setIdAttribute("ID", true);
            childElement.setAttribute("ID", node.getId());
            this.updateCacheKey();
            HandlerUtils.createPlfNodeAndPath((Element)childElement, (boolean)isChannel, (IPerson)this.owner);
            int layoutId = this.getLayoutId();
            if (isChannel) {
                this.channelsAdded = true;
                String fname = ((IUserLayoutChannelDescription)node).getFunctionalName();
                this.portalEventFactory.publishPortletAddedToLayoutPortalEvent((Object)this, this.owner, (long)layoutId, parent.getId(), fname);
            } else {
                this.portalEventFactory.publishFolderAddedToLayoutPortalEvent((Object)this, this.owner, (long)layoutId, node.getId());
            }
            return node;
        }
        return null;
    }

    public boolean moveNode(String nodeId, String parentId, String nextSiblingId) throws PortalException {
        IUserLayoutNodeDescription parent = this.getNode(parentId);
        IUserLayoutNodeDescription node = this.getNode(nodeId);
        String oldParentNodeId = this.getParentId(nodeId);
        if (this.canMoveNode(node, parent, nextSiblingId)) {
            Document uld = this.getUserLayoutDOM();
            Element childElement = uld.getElementById(nodeId);
            Element parentElement = uld.getElementById(parentId);
            if (nextSiblingId == null) {
                parentElement.appendChild(childElement);
            } else {
                Element nextSibling = uld.getElementById(nextSiblingId);
                parentElement.insertBefore(childElement, nextSibling);
            }
            this.updateCacheKey();
            Element oldParent = uld.getElementById(oldParentNodeId);
            TabColumnPrefsHandler.moveElement((Element)childElement, (Element)oldParent, (IPerson)this.owner);
            int layoutId = this.getLayoutId();
            if (node instanceof IUserLayoutChannelDescription) {
                this.channelsAdded = true;
                String fname = ((IUserLayoutChannelDescription)node).getFunctionalName();
                this.portalEventFactory.publishPortletMovedInLayoutPortalEvent((Object)this, this.owner, (long)layoutId, oldParentNodeId, parent.getId(), fname);
            } else {
                this.portalEventFactory.publishFolderMovedInLayoutPortalEvent((Object)this, this.owner, (long)layoutId, oldParentNodeId, parent.getId());
            }
            return true;
        }
        return false;
    }

    public boolean deleteNode(String nodeId) throws PortalException {
        if (this.canDeleteNode(nodeId)) {
            IUserLayoutNodeDescription nodeDescription = this.getNode(nodeId);
            String parentNodeId = this.getParentId(nodeId);
            Document uld = this.getUserLayoutDOM();
            Element ilfNode = uld.getElementById(nodeId);
            Node parent = ilfNode.getParentNode();
            if (parent == null) {
                throw new PortalException("Node \"" + nodeId + "\" has a NULL parent for layout of " + this.owner.getAttribute("username") + ".");
            }
            parent.removeChild(ilfNode);
            this.updateCacheKey();
            TabColumnPrefsHandler.deleteNode((Element)ilfNode, (Element)((Element)parent), (IPerson)this.owner);
            int layoutId = this.getLayoutId();
            if (nodeDescription instanceof IUserLayoutChannelDescription) {
                IUserLayoutChannelDescription userLayoutChannelDescription = (IUserLayoutChannelDescription)nodeDescription;
                this.portalEventFactory.publishPortletDeletedFromLayoutPortalEvent((Object)this, this.owner, (long)layoutId, parentNodeId, userLayoutChannelDescription.getFunctionalName());
            } else {
                this.portalEventFactory.publishFolderDeletedFromLayoutPortalEvent((Object)this, this.owner, (long)layoutId, parentNodeId, nodeDescription.getId(), nodeDescription.getName());
            }
            return true;
        }
        return false;
    }

    public synchronized boolean updateNode(IUserLayoutNodeDescription node) throws PortalException {
        if (this.canUpdateNode(node)) {
            String nodeId = node.getId();
            IUserLayoutNodeDescription oldNode = this.getNode(nodeId);
            if (oldNode instanceof IUserLayoutChannelDescription) {
                IUserLayoutChannelDescription oldChanDesc = (IUserLayoutChannelDescription)oldNode;
                if (!(node instanceof IUserLayoutChannelDescription)) {
                    throw new PortalException("Change channel to folder is not allowed by updateNode() method! Occurred in layout for " + this.owner.getAttribute("username") + ".");
                }
                IUserLayoutChannelDescription newChanDesc = (IUserLayoutChannelDescription)node;
                this.updateChannelNode(nodeId, newChanDesc, oldChanDesc);
            } else {
                IUserLayoutFolderDescription oldFolderDesc = (IUserLayoutFolderDescription)oldNode;
                if (oldFolderDesc.getId().equals(this.getRootFolderId())) {
                    throw new PortalException("Update of root node is not currently allowed!");
                }
                if (node instanceof IUserLayoutFolderDescription) {
                    IUserLayoutFolderDescription newFolderDesc = (IUserLayoutFolderDescription)node;
                    this.updateFolderNode(nodeId, newFolderDesc, oldFolderDesc);
                }
            }
            this.updateCacheKey();
            return true;
        }
        return false;
    }

    private void updateFolderNode(String nodeId, IUserLayoutFolderDescription newFolderDesc, IUserLayoutFolderDescription oldFolderDesc) throws PortalException {
        Element ilfNode = this.getUserLayoutDOM().getElementById(nodeId);
        ArrayList<LPAEditRestriction> pendingActions = new ArrayList<LPAEditRestriction>();
        if (this.isFragmentOwner && (newFolderDesc.isDeleteAllowed() != oldFolderDesc.isDeleteAllowed() || newFolderDesc.isEditAllowed() != oldFolderDesc.isEditAllowed() || newFolderDesc.isAddChildAllowed() != oldFolderDesc.isAddChildAllowed() || newFolderDesc.isMoveAllowed() != oldFolderDesc.isMoveAllowed())) {
            pendingActions.add(new LPAEditRestriction(this.owner, ilfNode, newFolderDesc.isMoveAllowed(), newFolderDesc.isDeleteAllowed(), newFolderDesc.isEditAllowed(), newFolderDesc.isAddChildAllowed()));
        }
        this.updateNodeAttribute(ilfNode, nodeId, "name", newFolderDesc.getName(), oldFolderDesc.getName(), pendingActions);
        for (ILayoutProcessingAction iLayoutProcessingAction : pendingActions) {
            iLayoutProcessingAction.perform();
        }
    }

    private void updateNodeAttribute(Element ilfNode, String nodeId, String attName, String newVal, String oldVal, List<ILayoutProcessingAction> pendingActions) throws PortalException {
        if (newVal == null && oldVal != null || newVal != null && oldVal == null || newVal != null && oldVal != null && !newVal.equals(oldVal)) {
            boolean isIncorporated = nodeId.startsWith("u");
            if (isIncorporated) {
                FragmentNodeInfo fragNodeInf = this.distributedLayoutStore.getFragmentNodeInfo(nodeId);
                if (fragNodeInf == null) {
                    pendingActions.add((ILayoutProcessingAction)new LPAChangeAttribute(nodeId, attName, newVal, this.owner, ilfNode, this.isFragmentOwner));
                } else {
                    if (!fragNodeInf.canOverrideAttributes()) {
                        throw new PortalException("Layout element '" + fragNodeInf.getAttributeValue(attName) + "' does not allow overriding attribute '" + attName + "'.");
                    }
                    if (!fragNodeInf.getAttributeValue(attName).equals(newVal)) {
                        pendingActions.add((ILayoutProcessingAction)new LPAChangeAttribute(nodeId, attName, newVal, this.owner, ilfNode, this.isFragmentOwner));
                    } else {
                        pendingActions.add((ILayoutProcessingAction)new LPAResetAttribute(nodeId, attName, fragNodeInf.getAttributeValue(attName), this.owner, ilfNode));
                    }
                }
            } else {
                pendingActions.add((ILayoutProcessingAction)new LPAChangeAttribute(nodeId, attName, newVal, this.owner, ilfNode, this.isFragmentOwner));
            }
        }
    }

    private void updateChannelNode(String nodeId, IUserLayoutChannelDescription newChanDesc, IUserLayoutChannelDescription oldChanDesc) throws PortalException {
        String name;
        Element ilfNode = this.getUserLayoutDOM().getElementById(nodeId);
        ArrayList<Object> pendingActions = new ArrayList<Object>();
        boolean isIncorporated = nodeId.startsWith("u");
        if (this.isFragmentOwner && (newChanDesc.isDeleteAllowed() != oldChanDesc.isDeleteAllowed() || newChanDesc.isEditAllowed() != oldChanDesc.isEditAllowed() || newChanDesc.isMoveAllowed() != oldChanDesc.isMoveAllowed())) {
            pendingActions.add(new LPAEditRestriction(this.owner, ilfNode, newChanDesc.isMoveAllowed(), newChanDesc.isDeleteAllowed(), newChanDesc.isEditAllowed(), newChanDesc.isAddChildAllowed()));
        }
        FragmentChannelInfo fragChanInf = null;
        Map pubParms = this.getPublishedChannelParametersMap(newChanDesc.getChannelPublishId());
        if (isIncorporated) {
            fragChanInf = this.distributedLayoutStore.getFragmentChannelInfo(nodeId);
        }
        HashMap oldParms = new HashMap(oldChanDesc.getParameterMap());
        for (Map.Entry entry : newChanDesc.getParameterMap().entrySet()) {
            name = (String)entry.getKey();
            String newVal = (String)entry.getValue();
            String oldVal = (String)oldParms.remove(name);
            if (oldVal == null) {
                pendingActions.add(new LPAAddParameter(nodeId, name, newVal, this.owner, ilfNode));
                continue;
            }
            if (oldVal.equals(newVal)) continue;
            if (isIncorporated) {
                String fragValue = fragChanInf.getParameterValue(name);
                if (fragValue == null) {
                    IPortletDefinitionParameter cp = (IPortletDefinitionParameter)pubParms.get(name);
                    if (cp != null && cp.getValue().equals(newVal)) {
                        pendingActions.add(new LPARemoveParameter(nodeId, name, this.owner, ilfNode));
                        continue;
                    }
                    pendingActions.add(new LPAChangeParameter(nodeId, name, newVal, this.owner, ilfNode));
                    continue;
                }
                if (!fragValue.equals(newVal)) {
                    pendingActions.add(new LPAChangeParameter(nodeId, name, newVal, this.owner, ilfNode));
                    continue;
                }
                pendingActions.add(new LPAResetParameter(nodeId, name, fragValue, this.owner, ilfNode));
                continue;
            }
            IPortletDefinitionParameter cp = (IPortletDefinitionParameter)pubParms.get(name);
            if (cp != null && cp.getValue().equals(newVal)) {
                pendingActions.add(new LPARemoveParameter(nodeId, name, this.owner, ilfNode));
                continue;
            }
            pendingActions.add(new LPAChangeParameter(nodeId, name, newVal, this.owner, ilfNode));
        }
        for (Map.Entry entry : oldParms.entrySet()) {
            name = (String)entry.getKey();
            pendingActions.add(new LPARemoveParameter(nodeId, name, this.owner, ilfNode));
        }
        for (ILayoutProcessingAction iLayoutProcessingAction : pendingActions) {
            iLayoutProcessingAction.perform();
        }
    }

    private Map getPublishedChannelParametersMap(String channelPublishId) throws PortalException {
        try {
            IPortletDefinitionRegistry registry = PortletDefinitionRegistryLocator.getPortletDefinitionRegistry();
            IPortletDefinition def = registry.getPortletDefinition(channelPublishId);
            return def.getParametersAsUnmodifiableMap();
        }
        catch (Exception e) {
            throw new PortalException("Unable to acquire channel definition.", (Throwable)e);
        }
    }

    public boolean canAddNode(IUserLayoutNodeDescription node, String parentId, String nextSiblingId) throws PortalException {
        return this.canAddNode(node, this.getNode(parentId), nextSiblingId);
    }

    protected boolean canAddNode(IUserLayoutNodeDescription node, IUserLayoutNodeDescription parent, String nextSiblingId) throws PortalException {
        if (nextSiblingId != null && !nextSiblingId.equals("")) {
            IUserLayoutNodeDescription sibling = this.getNode(nextSiblingId);
            if (sibling == null) {
                throw new PortalException("Unable to find a sibling node with id=\"" + nextSiblingId + "\".  Occurred " + "in layout for " + this.owner.getAttribute("username") + ".");
            }
            if (!parent.getId().equals(this.getParentId(nextSiblingId))) {
                throw new PortalException("Given sibling (\"" + nextSiblingId + "\") is not a child of a given parentId (\"" + parent.getId() + "\"). Occurred " + "in layout for " + this.owner.getAttribute("username") + ".");
            }
        }
        if (parent == null || !node.isMoveAllowed()) {
            return false;
        }
        if (parent instanceof IUserLayoutFolderDescription && !((IUserLayoutFolderDescription)parent).isAddChildAllowed()) {
            return false;
        }
        if (nextSiblingId == null || nextSiblingId.equals("")) {
            return true;
        }
        Enumeration sibIds = this.getVisibleChildIds(parent.getId());
        ArrayList sibs = Collections.list(sibIds);
        if (sibs.size() == 0) {
            return true;
        }
        for (int idx = sibs.size() - 1; idx >= 0; --idx) {
            IUserLayoutNodeDescription prev = this.getNode((String)sibs.get(idx));
            if (!MovementRules.canHopLeft((IUserLayoutNodeDescription)node, (IUserLayoutNodeDescription)prev)) {
                return false;
            }
            if (!prev.getId().equals(nextSiblingId)) continue;
            return true;
        }
        return false;
    }

    public boolean canMoveNode(String nodeId, String parentId, String nextSiblingId) throws PortalException {
        return this.canMoveNode(this.getNode(nodeId), this.getNode(parentId), nextSiblingId);
    }

    protected boolean canMoveNode(IUserLayoutNodeDescription node, IUserLayoutNodeDescription parent, String nextSiblingId) throws PortalException {
        if (!this.getParentId(node.getId()).equals(parent.getId())) {
            return node.isMoveAllowed() && this.canAddNode(node, parent, nextSiblingId);
        }
        Document uld = this.getUserLayoutDOM();
        Element parentE = uld.getElementById(parent.getId());
        int idx = 0;
        int nodeIdx = -1;
        int sibIdx = -1;
        for (Element child = (Element)parentE.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
            String id = child.getAttribute("ID");
            if (id.equals(node.getId())) {
                nodeIdx = idx;
            }
            if (id.equals(nextSiblingId)) {
                sibIdx = idx;
            }
            ++idx;
        }
        if (nodeIdx == -1 || nextSiblingId != null && sibIdx == -1) {
            return false;
        }
        if (nodeIdx < sibIdx || sibIdx == -1) {
            return this.canMoveRight(node.getId(), nextSiblingId);
        }
        return this.canMoveLeft(node.getId(), nextSiblingId);
    }

    private boolean canMoveRight(String nodeId, String targetNextSibId) throws PortalException {
        IUserLayoutNodeDescription node = this.getNode(nodeId);
        Enumeration sibIds = this.getVisibleChildIds(this.getParentId(nodeId));
        ArrayList sibs = Collections.list(sibIds);
        for (int idx = sibs.indexOf(nodeId) + 1; idx > 0 && idx < sibs.size(); ++idx) {
            String nextSibId = (String)sibs.get(idx);
            IUserLayoutNodeDescription next = this.getNode(nextSibId);
            if (nextSibId != null && next.getId().equals(targetNextSibId)) {
                return true;
            }
            if (MovementRules.canHopRight((IUserLayoutNodeDescription)node, (IUserLayoutNodeDescription)next)) continue;
            return false;
        }
        return targetNextSibId == null;
    }

    private boolean canMoveLeft(String nodeId, String targetNextSibId) throws PortalException {
        IUserLayoutNodeDescription node = this.getNode(nodeId);
        Enumeration sibIds = this.getVisibleChildIds(this.getParentId(nodeId));
        ArrayList sibs = Collections.list(sibIds);
        for (int idx = sibs.indexOf(nodeId) - 1; idx >= 0; --idx) {
            String prevSibId = (String)sibs.get(idx);
            IUserLayoutNodeDescription prev = this.getNode(prevSibId);
            if (!MovementRules.canHopLeft((IUserLayoutNodeDescription)node, (IUserLayoutNodeDescription)prev)) {
                return false;
            }
            if (targetNextSibId == null || !prev.getId().equals(targetNextSibId)) continue;
            return true;
        }
        return false;
    }

    public boolean canDeleteNode(String nodeId) throws PortalException {
        return this.canDeleteNode(this.getNode(nodeId));
    }

    protected boolean canDeleteNode(IUserLayoutNodeDescription node) throws PortalException {
        if (node == null) {
            return false;
        }
        return node.isDeleteAllowed();
    }

    public boolean canUpdateNode(String nodeId) throws PortalException {
        return this.canUpdateNode(this.getNode(nodeId));
    }

    public boolean canUpdateNode(IUserLayoutNodeDescription node) {
        if (node == null) {
            return false;
        }
        return this.isFragmentOwner || node.isEditAllowed() || node instanceof IUserLayoutChannelDescription;
    }

    public void markAddTargets(IUserLayoutNodeDescription node) {
        throw new UnsupportedOperationException("Use an appropriate processor for adding targets.");
    }

    public void markMoveTargets(String nodeId) throws PortalException {
        throw new UnsupportedOperationException("Use an appropriate processor for adding targets.");
    }

    public String getParentId(String nodeId) throws PortalException {
        Document uld = this.getUserLayoutDOM();
        Element nelement = uld.getElementById(nodeId);
        if (nelement != null) {
            Node parent = nelement.getParentNode();
            if (parent != null) {
                if (parent.getNodeType() != 1) {
                    throw new PortalException("Node with id=\"" + nodeId + "\" is attached to something other then an element node.");
                }
                Element e = (Element)parent;
                return e.getAttribute("ID");
            }
            return null;
        }
        throw new PortalException("Node with id=\"" + nodeId + "\" doesn't exist. Occurred in layout for " + this.owner.getAttribute("username") + ".");
    }

    public String getNextSiblingId(String nodeId) throws PortalException {
        Document uld = this.getUserLayoutDOM();
        Element nelement = uld.getElementById(nodeId);
        if (nelement != null) {
            Node nsibling;
            for (nsibling = nelement.getNextSibling(); nsibling != null && nsibling.getNodeType() != 1; nsibling = nsibling.getNextSibling()) {
            }
            if (nsibling != null) {
                Element e = (Element)nsibling;
                return e.getAttribute("ID");
            }
            return null;
        }
        throw new PortalException("Node with id=\"" + nodeId + "\" doesn't exist. Occurred " + "in layout for " + this.owner.getAttribute("username") + ".");
    }

    public String getPreviousSiblingId(String nodeId) throws PortalException {
        Document uld = this.getUserLayoutDOM();
        Element nelement = uld.getElementById(nodeId);
        if (nelement != null) {
            Node nsibling;
            for (nsibling = nelement.getPreviousSibling(); nsibling != null && nsibling.getNodeType() != 1; nsibling = nsibling.getNextSibling()) {
            }
            if (nsibling != null) {
                Element e = (Element)nsibling;
                return e.getAttribute("ID");
            }
            return null;
        }
        throw new PortalException("Node with id=\"" + nodeId + "\" doesn't exist. Occurred in layout for " + this.owner.getAttribute("username") + ".");
    }

    public Enumeration<String> getChildIds(String nodeId) throws PortalException {
        return this.getChildIds(nodeId, false);
    }

    private Enumeration<String> getVisibleChildIds(String nodeId) throws PortalException {
        return this.getChildIds(nodeId, true);
    }

    private Enumeration<String> getChildIds(String nodeId, boolean visibleOnly) throws PortalException {
        Vector<String> v = new Vector<String>();
        IUserLayoutNodeDescription node = this.getNode(nodeId);
        if (node instanceof IUserLayoutFolderDescription) {
            Document uld = this.getUserLayoutDOM();
            Element felement = uld.getElementById(nodeId);
            for (Node n = felement.getFirstChild(); n != null; n = n.getNextSibling()) {
                Element e;
                if (n.getNodeType() != 1 || visibleOnly && (!visibleOnly || !((Element)n).getAttribute("hidden").equals("false")) || (e = (Element)n).getAttribute("ID") == null) continue;
                v.add(e.getAttribute("ID"));
            }
        }
        return v.elements();
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    private void updateCacheKey() {
        this.cacheKey = Long.toString(rnd.nextLong());
    }

    public int getLayoutId() {
        return this.profile.getLayoutId();
    }

    public String getSubscribeId(String fname) {
        Document userLayout = this.getUserLayoutDOM();
        return new PortletSubscribeIdResolver(fname).traverseDocument(userLayout);
    }

    public String getSubscribeId(String parentFolderId, String fname) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("parentFolderId", parentFolderId);
        variables.put("fname", fname);
        Document userLayout = this.getUserLayoutDOM();
        Element fnameNode = (Element)this.xpathOperations.evaluate("//folder[@ID=$parentFolderId]/descendant::channel[@fname=$fname]", variables, (Object)userLayout, XPathConstants.NODE);
        if (fnameNode != null) {
            return fnameNode.getAttribute("ID");
        }
        return null;
    }

    public IUserLayout getUserLayout() throws PortalException {
        return new SimpleLayout(this.getDistributedUserLayout(), String.valueOf(this.profile.getLayoutId()), this.cacheKey);
    }

    public String getRootFolderId() {
        if (this.rootNodeId == null) {
            Document layout = this.getUserLayoutDOM();
            Element rootNode = (Element)this.xpathOperations.evaluate("//layout/folder", (Object)layout, XPathConstants.NODE);
            if (rootNode == null || !rootNode.getAttribute("type").equals("root")) {
                LOG.error((Object)("Unable to locate root node in layout of " + this.owner.getAttribute("username") + ". Resetting corrupted layout."));
                this.resetLayout((String)null);
                rootNode = (Element)this.xpathOperations.evaluate("//layout/folder", (Object)layout, XPathConstants.NODE);
                if (rootNode == null || !rootNode.getAttribute("type").equals("root")) {
                    throw new PortalException("Corrupted layout detected for " + this.owner.getAttribute("username") + " and resetting layout failed.");
                }
            }
            this.rootNodeId = rootNode.getAttribute("ID");
        }
        return this.rootNodeId;
    }

    public int getDepth(String nodeId) throws PortalException {
        return 0;
    }

    public IUserLayoutNodeDescription createNodeDescription(IUserLayoutNodeDescription.LayoutNodeType nodeType) throws PortalException {
        if (nodeType == IUserLayoutNodeDescription.LayoutNodeType.FOLDER) {
            return new UserLayoutFolderDescription();
        }
        return new ChannelDescription();
    }

    public boolean resetLayout(String loginId) {
        boolean resetCurrentUserLayout;
        boolean resetSuccess = false;
        boolean bl = resetCurrentUserLayout = null == loginId;
        if (resetCurrentUserLayout || !resetCurrentUserLayout && AdminEvaluator.isAdmin((IPerson)this.owner)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reset layout requested for user with id " + loginId + "."));
            }
            int portalID = -1;
            IPerson person = null;
            if (resetCurrentUserLayout || loginId.equals(this.owner.getAttribute("username"))) {
                person = this.owner;
                portalID = this.owner.getID();
            } else {
                person = PersonFactory.createPerson();
                person.setAttribute("username", (Object)loginId);
                try {
                    IUserIdentityStore userStore = UserIdentityStoreLocator.getUserIdentityStore();
                    portalID = userStore.getPortalUID(person);
                    person.setID(portalID);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (portalID != -1) {
                resetSuccess = this.resetLayout(person);
            }
        } else {
            LOG.error((Object)("Layout reset requested for user " + loginId + " by " + this.owner.getID() + " who is not an administrative user."));
        }
        return resetSuccess;
    }

    private boolean resetLayout(IPerson person) {
        String userName = person.getUserName();
        if (PersonFactory.GUEST_USERNAME.equals(userName)) {
            throw new IllegalArgumentException("CANNOT RESET LAYOUT FOR A GUEST USER: " + person);
        }
        LOG.warn((Object)("Resetting user layout for: " + userName), new Throwable());
        boolean layoutWasReset = false;
        if (this.distributedLayoutStore.isFragmentOwner(person)) {
            person.setAttribute("uPortalTemplateUserName", (Object)FragmentDefinition.getDefaultLayoutOwnerId());
        }
        IUserIdentityStore userStore = UserIdentityStoreLocator.getUserIdentityStore();
        try {
            userStore.removePortalUID(person.getID());
            userStore.getPortalUID(person, true);
            if (person == this.owner) {
                this.layoutCachingService.removeCachedLayout(person, this.profile);
                this.updateCacheKey();
                this.getUserLayoutDOM();
            }
            layoutWasReset = true;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to reset layout for " + person.getAttribute("username") + "."), (Throwable)e);
        }
        return layoutWasReset;
    }

    public IUserLayoutNodeDescription createNodeDescription(Element node) throws PortalException {
        String type = node.getNodeName();
        if (type.equals("channel")) {
            return new ChannelDescription(node);
        }
        if (type.equals("folder")) {
            return new UserLayoutFolderDescription(node);
        }
        throw new PortalException("Given XML Element is not a channel!");
    }

    public Map getChannelFunctionalNameMap() throws PortalException {
        Document layout = this.getUserLayoutDOM();
        NodeList channelNodes = layout.getElementsByTagName("channel");
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < channelNodes.getLength(); ++i) {
            Element chan = (Element)channelNodes.item(i);
            String id = chan.getAttribute("ID");
            String fname = chan.getAttribute("fname");
            if (id.equals("") || fname.equals("")) continue;
            map.put(id, fname);
        }
        return map;
    }

    IPerson getOwner() {
        return this.owner;
    }

    public IFolderLocalNameResolver getFolderNameResolver() {
        return this;
    }

    public String getFolderLabel(String nodeId) {
        IUserLayoutNodeDescription ndesc = this.getNode(nodeId);
        if (!(ndesc instanceof IUserLayoutFolderDescription)) {
            return null;
        }
        IUserLayoutFolderDescription desc = (IUserLayoutFolderDescription)ndesc;
        boolean editAllowed = desc.isEditAllowed();
        String label = desc.getName();
        String plfId = nodeId;
        if (nodeId.startsWith("u")) {
            Document plf = RDBMDistributedLayoutStore.getPLF((IPerson)this.owner);
            Element plfNode = plf.getElementById(nodeId);
            plfId = plfNode != null ? plfNode.getAttribute("dlm:plfID") : null;
        }
        return label;
    }
}

