/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.util.LinkedList;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.jasig.portal.layout.dlm.Evaluator;
import org.jasig.portal.layout.dlm.EvaluatorFactory;
import org.jasig.portal.layout.dlm.providers.EvaluatorGroup;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.xml.XmlUtilitiesImpl;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class FragmentDefinition
extends EvaluatorGroup {
    public static final String NAMESPACE_URI = "http://org.jasig.portal.layout.dlm.config";
    public static final Namespace NAMESPACE = DocumentHelper.createNamespace((String)"dlm", (String)"http://org.jasig.portal.layout.dlm.config");
    private static final String cDefaultLayoutOwnerId = "fragmentTemplate";
    private static final Log LOG = LogFactory.getLog(FragmentDefinition.class);
    @Column(name="FRAGMENT_NAME")
    private final String name;
    @Column(name="OWNER_ID")
    private String ownerID = null;
    @Column(name="PRECEDENCE")
    private double precedence = 0.0;
    @Column(name="DESCRIPTION")
    private String description;
    @Transient
    private int index = 0;
    @Transient
    String defaultLayoutOwnerID = null;

    private FragmentDefinition() {
        this.name = null;
    }

    protected FragmentDefinition(String name) {
        this.name = name;
    }

    public FragmentDefinition(Element e) {
        NamedNodeMap atts = e.getAttributes();
        this.name = this.loadAttribute("name", atts, true, e);
        this.loadFromEelement(e);
    }

    public void loadFromEelement(Element e) {
        boolean REQUIRED = true;
        boolean NOT_REQUIRED = false;
        NamedNodeMap atts = e.getAttributes();
        this.ownerID = this.loadAttribute("ownerID", atts, true, e);
        this.defaultLayoutOwnerID = this.loadAttribute("defaultLayoutOwnerID", atts, false, e);
        this.description = this.loadAttribute("description", atts, false, e);
        String precedence = this.loadAttribute("precedence", atts, true, e);
        try {
            this.precedence = Double.valueOf(precedence);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Invalid format for precedence attribute of <fragment> in\n'" + XmlUtilitiesImpl.toString((Node)e), nfe);
        }
        if (this.evaluators != null) {
            this.evaluators.clear();
        }
        this.loadAudienceEvaluators(e.getElementsByTagName("dlm:audience"));
    }

    public String getName() {
        return this.name;
    }

    public String getOwnerId() {
        return this.ownerID;
    }

    public double getPrecedence() {
        return this.precedence;
    }

    public String getDescription() {
        return this.description;
    }

    public static String getDefaultLayoutOwnerId() {
        return cDefaultLayoutOwnerId;
    }

    public int getEvaluatorCount() {
        return this.evaluators == null ? 0 : this.evaluators.size();
    }

    public List<Evaluator> getEvaluators() {
        return this.evaluators;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isNoAudienceIncluded() {
        return this.evaluators == null || this.evaluators.size() == 0;
    }

    private void loadAudienceEvaluators(NodeList nodes) {
        String evaluatorFactoryAtt = "evaluatorFactory";
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node audience = nodes.item(i);
            NamedNodeMap atts = audience.getAttributes();
            Node att = atts.getNamedItem("evaluatorFactory");
            if (att == null || att.getNodeValue().equals("")) {
                throw new RuntimeException("Required attibute 'evaluatorFactory' is missing or empty on 'audience'  element in\n'" + XmlUtilitiesImpl.toString((Node)audience) + "'");
            }
            String className = att.getNodeValue();
            EvaluatorFactory factory = this.loadEvaluatorFactory(className, audience);
            this.addEvaluator(factory, audience);
        }
    }

    private void addEvaluator(EvaluatorFactory factory, Node audience) {
        Evaluator evaluator = factory.getEvaluator(audience);
        if (evaluator == null) {
            throw new RuntimeException("Evaluator factory '" + factory.getClass().getName() + "' failed to " + "return an evaluator for 'audience' element" + " in\n'" + XmlUtilitiesImpl.toString((Node)audience) + "'");
        }
        if (this.evaluators == null) {
            this.evaluators = new LinkedList();
        }
        this.evaluators.add(evaluator);
    }

    private EvaluatorFactory loadEvaluatorFactory(String factoryClassName, Node audience) {
        Class<?> theClass = null;
        try {
            theClass = Class.forName(factoryClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("java.lang.ClassNotFoundException occurred while loading evaluator factory class '" + factoryClassName + "' (or one of its " + "dependent classes) for 'audience' element " + "in\n'" + XmlUtilitiesImpl.toString((Node)audience) + "'");
        }
        catch (ExceptionInInitializerError eiie) {
            throw new RuntimeException("java.lang.ExceptionInInitializerError occurred while loading evaluator factory Class '" + factoryClassName + "' (or one of its " + "dependent classes) for 'audience' element " + "in\n'" + XmlUtilitiesImpl.toString((Node)audience) + "'. \nThis indicates that an exception " + "occurred during evaluation of a static" + " initializer or the initializer for a " + "static variable.", eiie);
        }
        catch (LinkageError le) {
            throw new RuntimeException("java.lang.LinkageError occurred while loading evaluator factory Class '" + factoryClassName + "' for " + "'audience' element in\n'" + XmlUtilitiesImpl.toString((Node)audience) + "'. \nThis typically means that a " + "dependent class has changed " + "incompatibly after compiling the " + "factory class.", le);
        }
        Object theInstance = null;
        try {
            theInstance = theClass.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("java.lang.IllegalAccessException occurred while loading evaluator factory Class '" + factoryClassName + "' (or one of its " + "dependent classes) for 'audience' element " + "in\n'" + XmlUtilitiesImpl.toString((Node)audience) + "' \nVerify that this is a public class " + "and that it contains a public, zero " + "argument constructor.", iae);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("java.lang.InstantiationException occurred while loading evaluator factory Class '" + factoryClassName + "' (or one of its " + "dependent classes) for 'audience' element " + "in\n'" + XmlUtilitiesImpl.toString((Node)audience) + "' \nVerify that the specified class is a " + "class and not an interface or abstract " + "class.", ie);
        }
        try {
            return theInstance;
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("java.lang.ClassCastException occurred while loading evaluator factory Class '" + factoryClassName + "' (or one of its " + "dependent classes) for 'audience' element " + "in\n'" + XmlUtilitiesImpl.toString((Node)audience) + "'. \nVerify that the class implements the " + "EvaluatorFactory interface.", cce);
        }
    }

    public boolean isApplicable(IPerson p) {
        boolean isApplicable;
        block4: {
            block3: {
                isApplicable = false;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(">>>> calling " + this.name + ".isApplicable( " + p.getAttribute("username") + " )"));
                }
                if (this.evaluators != null) break block3;
                isApplicable = false;
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)"isApplicable()=false due to evaluators collection being null");
                break block4;
            }
            for (int i = 0; i < this.evaluators.size(); ++i) {
                if (!((Evaluator)this.evaluators.get(i)).isApplicable(p)) continue;
                isApplicable = true;
                break;
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("---- " + this.name + ".isApplicable( " + p.getAttribute("username") + " )=" + isApplicable));
        }
        return isApplicable;
    }

    private String loadAttribute(String name, NamedNodeMap atts, boolean required, Element e) {
        Node att = atts.getNamedItem(name);
        if (required && (att == null || att.getNodeValue().equals(""))) {
            throw new RuntimeException("Missing or empty attribute '" + name + "' required by <fragment> in\n'" + XmlUtilitiesImpl.toString((Node)e) + "'");
        }
        if (att == null) {
            return null;
        }
        return att.getNodeValue();
    }

    public void toElement(org.dom4j.Element parent) {
        if (parent == null) {
            String msg = "Argument 'parent' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        QName q = new QName("fragment", NAMESPACE);
        org.dom4j.Element rslt = DocumentHelper.createElement((QName)q);
        rslt.addAttribute("name", this.getName());
        rslt.addAttribute("ownerID", this.getOwnerId());
        rslt.addAttribute("precedence", Double.toString(this.getPrecedence()));
        rslt.addAttribute("description", this.getDescription());
        for (Evaluator v : this.evaluators) {
            v.toElement(rslt);
        }
        parent.add(rslt);
    }

    public Class<? extends EvaluatorFactory> getFactoryClass() {
        String msg = "This method is not necessary for serializing FragmentDefinition instances and should not be invoked.";
        throw new UnsupportedOperationException(msg);
    }

    public String getSummary() {
        throw new UnsupportedOperationException();
    }
}

