/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.dlm.DeleteManager;
import org.jasig.portal.layout.dlm.EditManager;
import org.jasig.portal.layout.dlm.IntegrationResult;
import org.jasig.portal.layout.dlm.ParameterEditManager;
import org.jasig.portal.layout.dlm.PositionManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class PLFIntegrator {
    public static final String RCS_ID = "@(#) $Header$";
    private static Log LOG = LogFactory.getLog(PLFIntegrator.class);

    public static void mergePLFintoILF(Document plf, Document ilf, IntegrationResult result) throws PortalException {
        Element plfLayout = plf.getDocumentElement();
        Element plfRoot = (Element)plfLayout.getFirstChild();
        Element ilfLayout = ilf.getDocumentElement();
        Element ilfRoot = (Element)ilfLayout.getFirstChild();
        DeleteManager.applyAndUpdateDeleteSet((Document)plf, (Document)ilf, (IntegrationResult)result);
        ParameterEditManager.applyAndUpdateParmEditSet((Document)plf, (Document)ilf, (IntegrationResult)result);
        if (null == plfRoot) {
            throw new RuntimeException("The PLF layout root element is missing, so it appears that the database has been corrupted.");
        }
        PLFIntegrator.applyChildChanges((Element)plfRoot, (Element)ilfRoot, (IntegrationResult)result);
    }

    private static void applyChildChanges(Element plfParent, Element ilfParent, IntegrationResult result) throws PortalException {
        Element positions = null;
        Element node = (Element)plfParent.getFirstChild();
        while (node != null) {
            Element nextNode = (Element)node.getNextSibling();
            if (node.getNodeName().equals("folder")) {
                PLFIntegrator.mergeFolder((Element)node, (Element)plfParent, (Element)ilfParent, (IntegrationResult)result);
            } else if (node.getNodeName().equals("dlm:positionSet")) {
                positions = node;
            } else if (node.getNodeName().equals("channel")) {
                PLFIntegrator.mergeChannel((Element)node, (Element)plfParent, (Element)ilfParent, (IntegrationResult)result);
            }
            node = nextNode;
        }
        if (positions != null) {
            IntegrationResult posResult = new IntegrationResult();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"applying positions");
            }
            PositionManager.applyPositions((Element)ilfParent, positions, (IntegrationResult)posResult);
            if (!posResult.changedILF) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"removing positionSet");
                }
                plfParent.removeChild(positions);
                result.changedPLF = true;
            } else {
                result.changedILF = true;
                if (posResult.changedPLF) {
                    result.changedPLF = true;
                }
            }
        }
    }

    private static void mergeChannel(Element plfChild, Element plfParent, Element ilfParent, IntegrationResult result) {
        String id = plfChild.getAttribute("ID");
        if (id.startsWith("u")) {
            Document ilf = ilfParent.getOwnerDocument();
            Element original = ilf.getElementById(id);
            if (original == null) {
                plfParent.removeChild(plfChild);
                result.changedPLF = true;
                return;
            }
            boolean attributeChanged = false;
            IntegrationResult childChanges = new IntegrationResult();
            attributeChanged = EditManager.applyEditSet((Element)plfChild, (Element)original);
            PLFIntegrator.applyChildChanges((Element)plfChild, (Element)original, (IntegrationResult)childChanges);
            if (!attributeChanged && !childChanges.changedILF) {
                plfParent.removeChild(plfChild);
                result.changedPLF = true;
            } else {
                result.changedILF = true;
            }
            if (childChanges.changedPLF) {
                result.changedPLF = true;
            }
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("merging into ilf channel " + id));
            }
            if (ilfParent.getAttribute("dlm:addChildAllowed").equals("false")) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("removing from plf disallowed add of channel " + id));
                }
                plfParent.removeChild(plfChild);
                result.changedPLF = true;
            } else {
                PLFIntegrator.appendChild((Element)plfChild, (Element)ilfParent, (boolean)true);
                result.changedILF = true;
            }
        }
    }

    private static void mergeFolder(Element plfChild, Element plfParent, Element ilfParent, IntegrationResult result) throws PortalException {
        String id = plfChild.getAttribute("ID");
        if (id.startsWith("u")) {
            Document ilf = ilfParent.getOwnerDocument();
            Element original = ilf.getElementById(id);
            if (original == null) {
                plfParent.removeChild(plfChild);
                result.changedPLF = true;
                return;
            }
            boolean attributeChanged = false;
            IntegrationResult childChanges = new IntegrationResult();
            attributeChanged = EditManager.applyEditSet((Element)plfChild, (Element)original);
            PLFIntegrator.applyChildChanges((Element)plfChild, (Element)original, (IntegrationResult)childChanges);
            if (!attributeChanged && !childChanges.changedILF) {
                plfParent.removeChild(plfChild);
                result.changedPLF = true;
            } else {
                result.changedILF = true;
            }
            if (childChanges.changedPLF) {
                result.changedPLF = true;
            }
        } else {
            if (ilfParent.getAttribute("dlm:addChildAllowed").equals("false")) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("removing folder from plf " + id));
                }
                plfParent.removeChild(plfChild);
                result.changedPLF = true;
                return;
            }
            Element ilfChild = PLFIntegrator.appendChild((Element)plfChild, (Element)ilfParent, (boolean)false);
            result.changedILF = true;
            IntegrationResult childChanges = new IntegrationResult();
            PLFIntegrator.applyChildChanges((Element)plfChild, (Element)ilfChild, (IntegrationResult)childChanges);
            if (childChanges.changedPLF) {
                result.changedPLF = true;
            }
        }
    }

    static Element appendChild(Element plfChild, Element parent, boolean copyChildren) {
        Document document = parent.getOwnerDocument();
        Element copy = (Element)document.importNode(plfChild, false);
        parent.appendChild(copy);
        String id = copy.getAttribute("ID");
        if (id != null && !id.equals("")) {
            copy.setIdAttribute("ID", true);
        }
        if (copyChildren) {
            NodeList children = plfChild.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (!(children.item(i) instanceof Element)) continue;
                PLFIntegrator.appendChild((Element)((Element)children.item(i)), (Element)copy, (boolean)true);
            }
        }
        return copy;
    }
}

