/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.providers;

import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.layout.dlm.Evaluator;
import org.jasig.portal.layout.dlm.EvaluatorFactory;
import org.jasig.portal.layout.dlm.providers.GroupMembershipEvaluatorFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.GroupService;

@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class GroupMembershipEvaluator
extends Evaluator {
    private static final int MEMBER_OF_MODE = 0;
    private static final int DEEP_MEMBER_OF_MODE = 1;
    @Column(name="GROUP_NAME")
    private String groupName = null;
    @Column(name="GROUP_KEY")
    private String groupKey = null;
    @Column(name="EVALUATOR_MODE")
    private int evaluatorMode;

    public GroupMembershipEvaluator() {
    }

    public GroupMembershipEvaluator(String mode, String name) {
        if (mode.equals("memberOf")) {
            this.evaluatorMode = 0;
        } else if (mode.equals("deepMemberOf")) {
            this.evaluatorMode = 1;
        } else {
            throw new RuntimeException("Unsupported mode '" + mode + "' specified. Only 'memberOf' and 'deepMemberOf' are " + "supported at this time.");
        }
        this.groupName = name;
        this.groupKey = this.getGroupKey();
    }

    private String getGroupKey() {
        EntityIdentifier[] groups = null;
        try {
            groups = GroupService.searchForGroups((String)this.groupName, (int)1, IPerson.class);
        }
        catch (GroupsException e1) {
            throw new RuntimeException("An exception occurred searching for the group " + this.groupName + ".", e1);
        }
        if (groups == null || groups.length == 0) {
            throw new RuntimeException("Group with name '" + this.groupName + "' not found for " + this.getClass().getName() + ". All evaluations will return false.");
        }
        return groups[0].getKey();
    }

    private IEntityGroup getGroup(String key) {
        try {
            return GroupService.findGroup((String)key);
        }
        catch (GroupsException e) {
            throw new RuntimeException("An exception occurred retrieving the group " + this.groupName + ".", e);
        }
    }

    public boolean isApplicable(IPerson p) {
        if (this.groupKey == null || p == null) {
            return false;
        }
        IEntityGroup group = this.getGroup(this.groupKey);
        EntityIdentifier ei = p.getEntityIdentifier();
        try {
            IGroupMember groupMember = GroupService.getGroupMember((EntityIdentifier)ei);
            boolean isMember = false;
            isMember = this.evaluatorMode == 0 ? groupMember.isMemberOf((IGroupMember)group) : groupMember.isDeepMemberOf((IGroupMember)group);
            return isMember;
        }
        catch (GroupsException e) {
            throw new RuntimeException("Unable to determine if user " + p.getFullName() + " is in group " + this.groupName + ".", e);
        }
    }

    public void toElement(Element parent) {
        if (parent == null) {
            String msg = "Argument 'parent' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        String mde = null;
        switch (this.evaluatorMode) {
            case 0: {
                mde = "memberOf";
                break;
            }
            case 1: {
                mde = "deepMemberOf";
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized evaluatorMode constant:  " + this.evaluatorMode);
            }
        }
        Element rslt = DocumentHelper.createElement((String)"attribute");
        rslt.addAttribute("mode", mde);
        rslt.addAttribute("name", this.groupName);
        parent.add(rslt);
    }

    public Class<? extends EvaluatorFactory> getFactoryClass() {
        return GroupMembershipEvaluatorFactory.class;
    }

    public String getSummary() {
        StringBuilder rslt = new StringBuilder();
        rslt.append("(");
        rslt.append("MEMBER OF '").append(this.groupName).append("'");
        if (this.evaluatorMode == 1) {
            rslt.append(" OR ANY DESCENDANT GROUP");
        }
        rslt.append(")");
        return rslt.toString();
    }
}

