/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.node;

import org.jasig.portal.PortalException;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.layout.node.UserLayoutChannelDescription;
import org.jasig.portal.layout.node.UserLayoutFolderDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class UserLayoutNodeDescription
implements IUserLayoutNodeDescription {
    protected String id = null;
    protected String name = null;
    protected boolean immutable = false;
    protected boolean unremovable = false;
    protected boolean hidden = false;
    protected boolean deleteAllowed = true;
    protected boolean editAllowed = true;
    protected boolean moveAllowed = true;
    protected boolean addChildAllowed = true;
    protected double precedence = 0.0;

    public UserLayoutNodeDescription() {
    }

    public UserLayoutNodeDescription(IUserLayoutNodeDescription d) {
        this.id = d.getId();
        this.name = d.getName();
        this.immutable = d.isImmutable();
        this.unremovable = d.isUnremovable();
        this.hidden = d.isHidden();
    }

    UserLayoutNodeDescription(Element xmlNode) throws PortalException {
        String precedence;
        this.setId(xmlNode.getAttribute("ID"));
        this.setName(xmlNode.getAttribute("name"));
        this.setUnremovable(new Boolean(xmlNode.getAttribute("unremovable")).booleanValue());
        this.setImmutable(new Boolean(xmlNode.getAttribute("immutable")).booleanValue());
        if (xmlNode.getAttribute("dlm:deleteAllowed").equals("false")) {
            this.setDeleteAllowed(false);
        }
        if (xmlNode.getAttribute("dlm:moveAllowed").equals("false")) {
            this.setMoveAllowed(false);
        }
        if (xmlNode.getAttribute("dlm:editAllowed").equals("false")) {
            this.setEditAllowed(false);
        }
        if (xmlNode.getAttribute("dlm:addChildAllowed").equals("false")) {
            this.setAddChildAllowed(false);
        }
        if (!(precedence = xmlNode.getAttribute("dlm:precedence")).equals("")) {
            try {
                this.setPrecedence(Double.parseDouble(precedence));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public double getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(double setting) {
        this.precedence = setting;
    }

    public boolean isMoveAllowed() {
        return this.moveAllowed;
    }

    public void setMoveAllowed(boolean setting) {
        this.moveAllowed = setting;
    }

    public boolean isDeleteAllowed() {
        return this.deleteAllowed;
    }

    public void setDeleteAllowed(boolean setting) {
        this.deleteAllowed = setting;
    }

    public boolean isEditAllowed() {
        return this.editAllowed;
    }

    public void setEditAllowed(boolean setting) {
        this.editAllowed = setting;
    }

    public boolean isAddChildAllowed() {
        return this.addChildAllowed;
    }

    public void setAddChildAllowed(boolean setting) {
        this.addChildAllowed = setting;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isUnremovable() {
        return this.unremovable;
    }

    public void setUnremovable(boolean setting) {
        this.unremovable = setting;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean setting) {
        this.immutable = setting;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean setting) {
        this.hidden = setting;
    }

    public abstract IUserLayoutNodeDescription.LayoutNodeType getType();

    public abstract Element getXML(Document var1);

    public void addNodeAttributes(Element node) {
        node.setAttribute("ID", this.getId());
        node.setAttribute("name", this.getName());
        node.setAttribute("unremovable", new Boolean(this.isUnremovable()).toString());
        node.setAttribute("immutable", new Boolean(this.isImmutable()).toString());
        node.setAttribute("hidden", new Boolean(this.isHidden()).toString());
        if (!this.isDeleteAllowed()) {
            node.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:deleteAllowed", "false");
        }
        if (!this.isMoveAllowed()) {
            node.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:moveAllowed", "false");
        }
        if (!this.isEditAllowed()) {
            node.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:editAllowed", "false");
        }
        if (!this.isAddChildAllowed()) {
            node.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:addChildAllowed", "false");
        }
        if (this.getPrecedence() != 0.0) {
            node.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:precedence", Double.toString(this.getPrecedence()));
        }
    }

    public static UserLayoutNodeDescription createUserLayoutNodeDescription(Element xmlNode) throws PortalException {
        String nodeName = xmlNode.getNodeName();
        if (nodeName.equals("channel")) {
            return new UserLayoutChannelDescription(xmlNode);
        }
        if (nodeName.equals("folder")) {
            return new UserLayoutFolderDescription(xmlNode);
        }
        throw new PortalException("Given XML element '" + nodeName + "' is neither folder nor channel");
    }

    public String toString() {
        return "[" + this.id + "," + this.name + "]";
    }
}

