/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.permission.dao.jpa;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Type;
import org.jasig.portal.permission.IPermissionActivity;
import org.jasig.portal.permission.IPermissionOwner;
import org.jasig.portal.permission.dao.jpa.PermissionActivityImpl;

@Entity
@Table(name="UP_PERMISSION_OWNER")
@SequenceGenerator(name="UP_PERMISSION_OWNER_GEN", sequenceName="UP_PERMISSION_OWNER_SEQ", allocationSize=1)
@TableGenerator(name="UP_PERMISSION_OWNER_GEN", pkColumnValue="UP_PERMISSION_OWNER", allocationSize=1)
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class PermissionOwnerImpl
implements IPermissionOwner,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_PERMISSION_OWNER_GEN")
    @Column(name="OWNER_ID")
    private final Long id = -1L;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @NaturalId
    @Column(name="OWNER_FNAME", length=128, nullable=false)
    @Type(type="fname")
    private String fname;
    @Column(name="OWNER_NAME", length=128, nullable=false)
    private String name;
    @Column(name="OWNER_DESCRIPTION", length=255)
    private String description;
    @OneToMany(targetEntity=PermissionActivityImpl.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="OWNER_ID")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private Set<IPermissionActivity> activities = new HashSet();

    private PermissionOwnerImpl() {
        this.entityVersion = -1L;
    }

    public PermissionOwnerImpl(String name, String fname) {
        this.entityVersion = -1L;
        this.fname = fname;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public String getFname() {
        return this.fname;
    }

    public void setFname(String fname) {
        this.fname = fname;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwnerName() {
        return this.name;
    }

    public String getOwnerToken() {
        return this.fname;
    }

    public Set<IPermissionActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(Set<IPermissionActivity> activities) {
        this.activities = activities;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IPermissionOwner)) {
            return false;
        }
        IPermissionOwner owner = (IPermissionOwner)obj;
        return this.fname.equals(owner.getFname());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fname == null ? 0 : this.fname.hashCode());
        return result;
    }

    public String toString() {
        return "PermissionOwnerImpl [id=" + this.id + ", entityVersion=" + this.entityVersion + ", fname=" + this.fname + ", name=" + this.name + ", description=" + this.description + "]";
    }
}

