/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.persondir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jasig.portal.persondir.ILocalAccountDao;
import org.jasig.portal.persondir.ILocalAccountPerson;
import org.jasig.portal.persondir.LocalAccountQuery;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.AbstractDefaultAttributePersonAttributeDao;
import org.jasig.services.persondir.support.AttributeNamedPersonImpl;
import org.jasig.services.persondir.support.IUsernameAttributeProvider;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.jasig.services.persondir.support.NamedPersonImpl;

public class LocalAccountPersonAttributeDao
extends AbstractDefaultAttributePersonAttributeDao {
    private ILocalAccountDao localAccountDao;
    private Map<String, Set<String>> resultAttributeMapping;
    private Set<String> possibleUserAttributes;
    private String unmappedUsernameAttribute = null;
    private String displayNameAttribute = "displayName";
    private Map<String, Set<String>> queryAttributeMapping;

    public void setLocalAccountDao(ILocalAccountDao localAccountDao) {
        this.localAccountDao = localAccountDao;
    }

    public void setQueryAttributeMapping(Map<String, ?> queryAttributeMapping) {
        Map parsedQueryAttributeMapping = MultivaluedPersonAttributeUtils.parseAttributeToAttributeMapping(queryAttributeMapping);
        if (parsedQueryAttributeMapping.containsKey("")) {
            throw new IllegalArgumentException("The map from attribute names to attributes must not have any empty keys.");
        }
        this.queryAttributeMapping = parsedQueryAttributeMapping;
    }

    public Map<String, Set<String>> getResultAttributeMapping() {
        return this.resultAttributeMapping;
    }

    public void setResultAttributeMapping(Map<String, ?> resultAttributeMapping) {
        Map parsedResultAttributeMapping = MultivaluedPersonAttributeUtils.parseAttributeToAttributeMapping(resultAttributeMapping);
        if (parsedResultAttributeMapping.containsKey("")) {
            throw new IllegalArgumentException("The map from attribute names to attributes must not have any empty keys.");
        }
        Collection userAttributes = MultivaluedPersonAttributeUtils.flattenCollection(parsedResultAttributeMapping.values());
        this.resultAttributeMapping = parsedResultAttributeMapping;
        this.possibleUserAttributes = Collections.unmodifiableSet(new LinkedHashSet(userAttributes));
    }

    public String getUnmappedUsernameAttribute() {
        return this.unmappedUsernameAttribute;
    }

    public void setUnmappedUsernameAttribute(String userNameAttribute) {
        this.unmappedUsernameAttribute = userNameAttribute;
    }

    public Set<String> getPossibleUserAttributeNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.possibleUserAttributes);
        names.addAll(this.localAccountDao.getCurrentAttributeNames());
        names.add(this.displayNameAttribute);
        return names;
    }

    public Set<String> getAvailableQueryAttributes() {
        if (this.queryAttributeMapping == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.queryAttributeMapping.keySet());
    }

    public final Set<IPersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> query) {
        Validate.notNull(query, (String)"query may not be null.");
        LocalAccountQuery queryBuilder = this.generateQuery(query);
        if (queryBuilder == null) {
            this.logger.debug((Object)("No queryBuilder was generated for query " + query + ", null will be returned"));
            return null;
        }
        IUsernameAttributeProvider usernameAttributeProvider = this.getUsernameAttributeProvider();
        List unmappedPeople = this.localAccountDao.getPeople(queryBuilder);
        if (unmappedPeople == null) {
            return null;
        }
        LinkedHashSet<IPersonAttributes> mappedPeople = new LinkedHashSet<IPersonAttributes>();
        for (ILocalAccountPerson unmappedPerson : unmappedPeople) {
            IPersonAttributes mappedPerson = this.mapPersonAttributes(unmappedPerson);
            mappedPeople.add(mappedPerson);
        }
        return Collections.unmodifiableSet(mappedPeople);
    }

    protected LocalAccountQuery generateQuery(Map<String, List<Object>> query) {
        LocalAccountQuery queryBuilder = new LocalAccountQuery();
        String userNameAttribute = this.getConfiguredUserNameAttribute();
        for (Map.Entry<String, List<Object>> queryEntry : query.entrySet()) {
            String attrName = queryEntry.getKey();
            if (userNameAttribute.equals(attrName)) {
                String value = queryEntry.getValue().get(0).toString();
                queryBuilder.setUserName(value);
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            for (Object o : queryEntry.getValue()) {
                values.add(o.toString());
            }
            queryBuilder.setAttribute(attrName, values);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generated query builder '" + queryBuilder + "' from query Map " + query + "."));
        }
        return queryBuilder;
    }

    protected IPersonAttributes mapPersonAttributes(ILocalAccountPerson person) {
        NamedPersonImpl newPerson;
        LinkedHashMap<String, List> mappedAttributes = new LinkedHashMap<String, List>();
        mappedAttributes.putAll(person.getAttributes());
        mappedAttributes.put(this.getUsernameAttributeProvider().getUsernameAttribute(), Collections.singletonList(person.getName()));
        if (!mappedAttributes.containsKey(this.displayNameAttribute) || ((List)mappedAttributes.get(this.displayNameAttribute)).size() == 0 || StringUtils.isBlank((String)((String)((List)mappedAttributes.get(this.displayNameAttribute)).get(0)))) {
            List firstNames = (List)mappedAttributes.get("givenName");
            List lastNames = (List)mappedAttributes.get("sn");
            StringBuilder displayName = new StringBuilder();
            if (firstNames != null && firstNames.size() > 0) {
                displayName.append(firstNames.get(0)).append(" ");
            }
            if (lastNames != null && lastNames.size() > 0) {
                displayName.append(lastNames.get(0));
            }
            mappedAttributes.put(this.displayNameAttribute, Collections.singletonList(displayName.toString()));
        }
        for (Map.Entry resultAttrEntry : this.getResultAttributeMapping().entrySet()) {
            String dataKey = (String)resultAttrEntry.getKey();
            if (!mappedAttributes.containsKey(dataKey)) continue;
            Set<String> resultKeys = (Set<String>)resultAttrEntry.getValue();
            if (resultKeys == null) {
                resultKeys = Collections.singleton(dataKey);
            }
            List value = (List)mappedAttributes.get(dataKey);
            for (String resultKey : resultKeys) {
                if (resultKey == null) {
                    if (mappedAttributes.containsKey(dataKey)) continue;
                    mappedAttributes.put(dataKey, value);
                    continue;
                }
                if (mappedAttributes.containsKey(resultKey)) continue;
                mappedAttributes.put(resultKey, value);
            }
        }
        String name = person.getName();
        if (name != null) {
            newPerson = new NamedPersonImpl(name, mappedAttributes);
        } else {
            String userNameAttribute = this.getConfiguredUserNameAttribute();
            newPerson = new AttributeNamedPersonImpl(userNameAttribute, mappedAttributes);
        }
        return newPerson;
    }

    protected String getConfiguredUserNameAttribute() {
        if (this.unmappedUsernameAttribute != null) {
            return this.unmappedUsernameAttribute;
        }
        IUsernameAttributeProvider usernameAttributeProvider = this.getUsernameAttributeProvider();
        return usernameAttributeProvider.getUsernameAttribute();
    }
}

