/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.cache;

import javax.portlet.CacheControl;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.portlet.container.cache.PortletCachingHeaderUtils;
import org.jasig.portal.portlet.rendering.PortletResourceOutputHandler;

public class HeaderSettingCacheControl
implements CacheControl {
    private final CacheControl cacheControl;
    private final PortletResourceOutputHandler portletResourceOutputHandler;
    private final long lastModified = System.currentTimeMillis();

    public HeaderSettingCacheControl(CacheControl cacheControl, PortletResourceOutputHandler portletResourceOutputHandler) {
        this.cacheControl = cacheControl;
        this.portletResourceOutputHandler = portletResourceOutputHandler;
    }

    private void setCacheHeaders(int time, boolean publicScope) {
        PortletCachingHeaderUtils.setCachingHeaders((int)time, (boolean)publicScope, (long)this.lastModified, (PortletResourceOutputHandler)this.portletResourceOutputHandler);
    }

    public int getExpirationTime() {
        return this.cacheControl.getExpirationTime();
    }

    public void setExpirationTime(int time) {
        this.cacheControl.setExpirationTime(time);
        this.setCacheHeaders(time, this.isPublicScope());
    }

    public boolean isPublicScope() {
        return this.cacheControl.isPublicScope();
    }

    public void setPublicScope(boolean publicScope) {
        this.cacheControl.setPublicScope(publicScope);
        this.setCacheHeaders(this.getExpirationTime(), publicScope);
    }

    public String getETag() {
        return this.cacheControl.getETag();
    }

    public void setETag(String token) {
        token = StringUtils.trimToNull((String)token);
        this.cacheControl.setETag(token);
        PortletCachingHeaderUtils.setETag((String)token, (PortletResourceOutputHandler)this.portletResourceOutputHandler);
    }

    public boolean useCachedContent() {
        return this.cacheControl.useCachedContent();
    }

    public void setUseCachedContent(boolean useCachedContent) {
        this.cacheControl.setUseCachedContent(useCachedContent);
    }
}

