/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.cache;

import java.io.Serializable;
import java.util.Locale;
import javax.portlet.CacheControl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.jasig.portal.portlet.container.cache.CacheState;
import org.jasig.portal.portlet.container.cache.CachedPortletData;
import org.jasig.portal.portlet.container.cache.CachedPortletResourceData;
import org.jasig.portal.portlet.container.cache.CachedPortletResultHolder;
import org.jasig.portal.portlet.container.cache.IPortletCacheControlService;
import org.jasig.portal.portlet.container.cache.PrivatePortletCacheKey;
import org.jasig.portal.portlet.container.cache.PublicPortletCacheKey;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.rendering.PortletRenderResult;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IUrlSyntaxProvider;
import org.jasig.portal.utils.cache.TaggedCacheEntryPurger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.support.RequestContextUtils;

@Service
public class PortletCacheControlServiceImpl
implements IPortletCacheControlService {
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TaggedCacheEntryPurger taggedCacheEntryPurger;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IUrlSyntaxProvider urlSyntaxProvider;
    private Ehcache privateScopePortletRenderHeaderOutputCache;
    private Ehcache publicScopePortletRenderHeaderOutputCache;
    private Ehcache privateScopePortletRenderOutputCache;
    private Ehcache publicScopePortletRenderOutputCache;
    private Ehcache privateScopePortletResourceOutputCache;
    private Ehcache publicScopePortletResourceOutputCache;
    private int cacheSizeThreshold = 102400;

    @Autowired
    public void setTaggedCacheEntryPurger(TaggedCacheEntryPurger taggedCacheEntryPurger) {
        this.taggedCacheEntryPurger = taggedCacheEntryPurger;
    }

    @Autowired
    @Qualifier(value="org.jasig.portal.portlet.container.cache.PortletCacheControlServiceImpl.privateScopePortletRenderHeaderOutputCache")
    public void setPrivateScopePortletRenderHeaderOutputCache(Ehcache privateScopePortletRenderHeaderOutputCache) {
        this.privateScopePortletRenderHeaderOutputCache = privateScopePortletRenderHeaderOutputCache;
    }

    @Autowired
    @Qualifier(value="org.jasig.portal.portlet.container.cache.PortletCacheControlServiceImpl.publicScopePortletRenderHeaderOutputCache")
    public void setPublicScopePortletRenderHeaderOutputCache(Ehcache publicScopePortletRenderHeaderOutputCache) {
        this.publicScopePortletRenderHeaderOutputCache = publicScopePortletRenderHeaderOutputCache;
    }

    @Autowired
    @Qualifier(value="org.jasig.portal.portlet.container.cache.PortletCacheControlServiceImpl.privateScopePortletRenderOutputCache")
    public void setPrivateScopePortletRenderOutputCache(Ehcache privateScopePortletRenderOutputCache) {
        this.privateScopePortletRenderOutputCache = privateScopePortletRenderOutputCache;
    }

    @Autowired
    @Qualifier(value="org.jasig.portal.portlet.container.cache.PortletCacheControlServiceImpl.publicScopePortletRenderOutputCache")
    public void setPublicScopePortletRenderOutputCache(Ehcache publicScopePortletRenderOutputCache) {
        this.publicScopePortletRenderOutputCache = publicScopePortletRenderOutputCache;
    }

    @Autowired
    @Qualifier(value="org.jasig.portal.portlet.container.cache.PortletCacheControlServiceImpl.privateScopePortletResourceOutputCache")
    public void setPrivateScopePortletResourceOutputCache(Ehcache privateScopePortletResourceOutputCache) {
        this.privateScopePortletResourceOutputCache = privateScopePortletResourceOutputCache;
    }

    @Autowired
    @Qualifier(value="org.jasig.portal.portlet.container.cache.PortletCacheControlServiceImpl.publicScopePortletResourceOutputCache")
    public void setPublicScopePortletResourceOutputCache(Ehcache publicScopePortletResourceOutputCache) {
        this.publicScopePortletResourceOutputCache = publicScopePortletResourceOutputCache;
    }

    @Value(value="${org.jasig.portal.portlet.container.cache.PortletCacheControlServiceImpl.cacheSizeThreshold:102400}")
    public void setCacheSizeThreshold(int cacheSizeThreshold) {
        this.cacheSizeThreshold = cacheSizeThreshold;
    }

    public int getCacheSizeThreshold() {
        return this.cacheSizeThreshold;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Autowired
    public void setUrlSyntaxProvider(IUrlSyntaxProvider urlSyntaxProvider) {
        this.urlSyntaxProvider = urlSyntaxProvider;
    }

    public CacheState<CachedPortletData<PortletRenderResult>, PortletRenderResult> getPortletRenderHeaderState(HttpServletRequest request, IPortletWindowId portletWindowId) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        if (portletWindow == null) {
            this.logger.warn("portletWindowRegistry returned null for {}, returning default cacheControl and no cached portlet data", (Object)portletWindowId);
            return new CacheState();
        }
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(request);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        PublicPortletCacheKey publicCacheKey = PublicPortletCacheKey.createPublicPortletRenderHeaderCacheKey((IPortletWindow)portletWindow, (IPortalRequestInfo)portalRequestInfo, (Locale)locale);
        return this.getPortletState(request, portletWindow, publicCacheKey, this.publicScopePortletRenderHeaderOutputCache, this.privateScopePortletRenderHeaderOutputCache, false);
    }

    public CacheState<CachedPortletData<PortletRenderResult>, PortletRenderResult> getPortletRenderState(HttpServletRequest request, IPortletWindowId portletWindowId) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        if (portletWindow == null) {
            this.logger.warn("portletWindowRegistry returned null for {}, returning default cacheControl and no cached portlet data", (Object)portletWindowId);
            return new CacheState();
        }
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(request);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        PublicPortletCacheKey publicCacheKey = PublicPortletCacheKey.createPublicPortletRenderCacheKey((IPortletWindow)portletWindow, (IPortalRequestInfo)portalRequestInfo, (Locale)locale);
        return this.getPortletState(request, portletWindow, publicCacheKey, this.publicScopePortletRenderOutputCache, this.privateScopePortletRenderOutputCache, false);
    }

    public CacheState<CachedPortletResourceData<Long>, Long> getPortletResourceState(HttpServletRequest request, IPortletWindowId portletWindowId) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        if (portletWindow == null) {
            this.logger.warn("portletWindowRegistry returned null for {}, returning default cacheControl and no cached portlet data", (Object)portletWindowId);
            return new CacheState();
        }
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(request);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        PublicPortletCacheKey publicCacheKey = PublicPortletCacheKey.createPublicPortletResourceCacheKey((IPortletWindow)portletWindow, (IPortalRequestInfo)portalRequestInfo, (Locale)locale);
        return this.getPortletState(request, portletWindow, publicCacheKey, this.publicScopePortletResourceOutputCache, this.privateScopePortletResourceOutputCache, true);
    }

    private <D extends CachedPortletResultHolder<T>, T extends Serializable> CacheState<D, T> getPortletState(HttpServletRequest request, IPortletWindow portletWindow, PublicPortletCacheKey publicCacheKey, Ehcache publicOutputCache, Ehcache privateOutputCache, boolean useHttpHeaders) {
        CacheState cacheState = this.getPortletCacheState(request, portletWindow, publicCacheKey, publicOutputCache, privateOutputCache);
        String etagHeader = null;
        CachedPortletResultHolder cachedPortletData = cacheState.getCachedPortletData();
        if (cachedPortletData != null) {
            long expirationTime;
            if (useHttpHeaders) {
                etagHeader = request.getHeader(IF_NONE_MATCH);
                if (etagHeader != null && etagHeader.equals(cachedPortletData.getEtag())) {
                    cacheState.setBrowserDataMatches(true);
                } else {
                    long ifModifiedSince = request.getDateHeader(IF_MODIFIED_SINCE);
                    if (ifModifiedSince >= 0L && cachedPortletData.getTimeStored() <= ifModifiedSince) {
                        cacheState.setBrowserDataMatches(true);
                    }
                }
            }
            if ((expirationTime = cachedPortletData.getExpirationTime()) == -1L || expirationTime > System.currentTimeMillis()) {
                cacheState.setUseCachedData(true);
                cacheState.setUseBrowserData(cacheState.isBrowserDataMatches());
                return cacheState;
            }
        }
        CacheControl cacheControl = cacheState.getCacheControl();
        IPortletEntity entity = portletWindow.getPortletEntity();
        IPortletDefinitionId definitionId = entity.getPortletDefinitionId();
        PortletDefinition portletDescriptor = this.portletDefinitionRegistry.getParentPortletDescriptor(definitionId);
        String cacheScopeValue = portletDescriptor.getCacheScope();
        if ("portlet.public-scope".equalsIgnoreCase(cacheScopeValue)) {
            cacheControl.setPublicScope(true);
        }
        cacheControl.setExpirationTime(portletDescriptor.getExpirationCache());
        if (etagHeader != null) {
            cacheControl.setETag(etagHeader);
            cacheState.setBrowserSetEtag(true);
        } else if (cachedPortletData != null) {
            cacheControl.setETag(cachedPortletData.getEtag());
        }
        return cacheState;
    }

    protected <D extends CachedPortletResultHolder<T>, T extends Serializable> CacheState<D, T> getPortletCacheState(HttpServletRequest request, IPortletWindow portletWindow, PublicPortletCacheKey publicCacheKey, Ehcache publicOutputCache, Ehcache privateOutputCache) {
        CacheState cacheState = new CacheState();
        cacheState.setPublicPortletCacheKey(publicCacheKey);
        IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
        CachedPortletResultHolder cachedPortletData = this.getCachedPortletData((Serializable)publicCacheKey, publicOutputCache, portletWindow);
        if (cachedPortletData != null) {
            cacheState.setCachedPortletData(cachedPortletData);
            return cacheState;
        }
        HttpSession session = request.getSession();
        String sessionId = session.getId();
        IPortletEntityId entityId = portletWindow.getPortletEntityId();
        PrivatePortletCacheKey privateCacheKey = new PrivatePortletCacheKey(sessionId, portletWindowId, entityId, publicCacheKey);
        cacheState.setPrivatePortletCacheKey(privateCacheKey);
        cachedPortletData = this.getCachedPortletData((Serializable)privateCacheKey, privateOutputCache, portletWindow);
        if (cachedPortletData != null) {
            cacheState.setCachedPortletData(cachedPortletData);
            return cacheState;
        }
        return cacheState;
    }

    protected <T extends Serializable> CachedPortletResultHolder<T> getCachedPortletData(Serializable cacheKey, Ehcache outputCache, IPortletWindow portletWindow) {
        Element publicCacheElement = outputCache.get(cacheKey);
        if (publicCacheElement == null) {
            this.logger.debug("No cached output for key {}", (Object)cacheKey);
            return null;
        }
        CachedPortletResultHolder cachedPortletData = (CachedPortletResultHolder)publicCacheElement.getObjectValue();
        if (publicCacheElement.isExpired() && cachedPortletData.getEtag() == null) {
            this.logger.debug("Cached output for key {} is expired", (Object)cacheKey);
            outputCache.remove(cacheKey);
            return null;
        }
        this.logger.debug("Returning cached output with key {} for {}", (Object)cacheKey, (Object)portletWindow);
        return (CachedPortletResultHolder)publicCacheElement.getObjectValue();
    }

    public boolean shouldOutputBeCached(CacheControl cacheControl) {
        return cacheControl.getExpirationTime() != 0;
    }

    public void cachePortletRenderHeaderOutput(IPortletWindowId portletWindowId, HttpServletRequest httpRequest, CacheState<CachedPortletData<PortletRenderResult>, PortletRenderResult> cacheState, CachedPortletData<PortletRenderResult> cachedPortletData) {
        this.cachePortletOutput(portletWindowId, httpRequest, cacheState, cachedPortletData, this.publicScopePortletRenderHeaderOutputCache, this.privateScopePortletRenderHeaderOutputCache);
    }

    public void cachePortletRenderOutput(IPortletWindowId portletWindowId, HttpServletRequest httpRequest, CacheState<CachedPortletData<PortletRenderResult>, PortletRenderResult> cacheState, CachedPortletData<PortletRenderResult> cachedPortletData) {
        this.cachePortletOutput(portletWindowId, httpRequest, cacheState, cachedPortletData, this.publicScopePortletRenderOutputCache, this.privateScopePortletRenderOutputCache);
    }

    public void cachePortletResourceOutput(IPortletWindowId portletWindowId, HttpServletRequest httpRequest, CacheState<CachedPortletResourceData<Long>, Long> cacheState, CachedPortletResourceData<Long> cachedPortletResourceData) {
        this.cachePortletOutput(portletWindowId, httpRequest, cacheState, cachedPortletResourceData, this.publicScopePortletResourceOutputCache, this.privateScopePortletResourceOutputCache);
    }

    private <D extends CachedPortletResultHolder<T>, T extends Serializable> void cachePortletOutput(IPortletWindowId portletWindowId, HttpServletRequest httpRequest, CacheState<D, T> cacheState, D cachedPortletData, Ehcache publicOutputCache, Ehcache privateOutputCache) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpRequest, portletWindowId);
        CacheControl cacheControl = cacheState.getCacheControl();
        if (cacheControl.isPublicScope()) {
            PublicPortletCacheKey publicCacheKey = cacheState.getPublicPortletCacheKey();
            this.cacheElement(publicOutputCache, (Serializable)publicCacheKey, cachedPortletData, cacheControl);
            this.logger.debug("Cached public data under key {} for {}", (Object)publicCacheKey, (Object)portletWindow);
        } else {
            PrivatePortletCacheKey privateCacheKey = cacheState.getPrivatePortletCacheKey();
            if (privateCacheKey == null) {
                HttpSession session = httpRequest.getSession();
                String sessionId = session.getId();
                IPortletEntityId entityId = portletWindow.getPortletEntityId();
                PublicPortletCacheKey publicCacheKey = cacheState.getPublicPortletCacheKey();
                privateCacheKey = new PrivatePortletCacheKey(sessionId, portletWindowId, entityId, publicCacheKey);
            }
            this.cacheElement(privateOutputCache, (Serializable)privateCacheKey, cachedPortletData, cacheControl);
            this.logger.debug("Cached private data under key {} for {}", (Object)privateCacheKey, (Object)portletWindow);
        }
    }

    protected void cacheElement(Ehcache cache, Serializable cacheKey, CachedPortletResultHolder<?> data, CacheControl cacheControl) {
        if (cacheControl.getETag() != null) {
            Element element = new Element((Object)cacheKey, data);
            cache.put(element);
            return;
        }
        int expirationTime = cacheControl.getExpirationTime();
        if (expirationTime == -1) {
            Element element = new Element((Object)cacheKey, data);
            cache.put(element);
            return;
        }
        CacheConfiguration cacheConfiguration = cache.getCacheConfiguration();
        Element element = new Element((Object)cacheKey, data);
        long cacheTTL = cacheConfiguration.getTimeToLiveSeconds();
        if ((long)expirationTime < cacheTTL) {
            element.setTimeToLive(expirationTime);
        }
        cache.put(element);
    }

    public boolean purgeCachedPortletData(IPortletWindowId portletWindowId, HttpServletRequest httpRequest) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpRequest, portletWindowId);
        IPortletEntity entity = portletWindow.getPortletEntity();
        IPortletDefinitionId definitionId = entity.getPortletDefinitionId();
        HttpSession session = httpRequest.getSession();
        int purgeCount = 0;
        purgeCount += this.taggedCacheEntryPurger.purgeCacheEntries(PublicPortletCacheKey.createTag((IPortletDefinitionId)definitionId));
        this.logger.debug("Purging all cached data for {} removed {} keys", (Object)portletWindow, (Object)(purgeCount += this.taggedCacheEntryPurger.purgeCacheEntries(PrivatePortletCacheKey.createTag((String)session.getId(), (IPortletWindowId)portletWindowId))));
        return purgeCount != 0;
    }
}

