/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlet.container.properties.IRequestPropertiesManager;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.utils.Populator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.OrderComparator;
import org.springframework.stereotype.Service;

@Service(value="requestPropertiesManager")
@Qualifier(value="main")
public class RequestPropertiesManagerBroker
implements IRequestPropertiesManager {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private List<IRequestPropertiesManager> propertiesManagers = Collections.emptyList();

    @Autowired
    public void setPropertiesManagers(Collection<? extends IRequestPropertiesManager> propertiesManagers) {
        this.propertiesManagers = new ArrayList<IRequestPropertiesManager>(propertiesManagers);
        Collections.sort(this.propertiesManagers, OrderComparator.INSTANCE);
    }

    public boolean setResponseProperty(HttpServletRequest portletRequest, IPortletWindow portletWindow, String property, String value) {
        for (IRequestPropertiesManager propertiesManager : this.propertiesManagers) {
            if (!propertiesManager.setResponseProperty(portletRequest, portletWindow, property, value)) continue;
            return true;
        }
        return false;
    }

    public boolean addResponseProperty(HttpServletRequest portletRequest, IPortletWindow portletWindow, String property, String value) {
        for (IRequestPropertiesManager propertiesManager : this.propertiesManagers) {
            if (!propertiesManager.addResponseProperty(portletRequest, portletWindow, property, value)) continue;
            return true;
        }
        return false;
    }

    public <P extends Populator<String, String>> void populateRequestProperties(HttpServletRequest portletRequest, IPortletWindow portletWindow, P propertiesPopulator) {
        for (IRequestPropertiesManager propertiesManager : this.propertiesManagers) {
            propertiesManager.populateRequestProperties(portletRequest, portletWindow, propertiesPopulator);
        }
    }
}

