/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletURLGenerationListener;
import org.apache.pluto.container.PortletURLListenerService;
import org.apache.pluto.container.om.portlet.Listener;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="portletURLListenerService")
public class LocalPortletURLListenerServiceImpl
implements PortletURLListenerService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public List<PortletURLGenerationListener> getPortletURLGenerationListeners(PortletApplicationDefinition app) {
        ArrayList<PortletURLGenerationListener> listeners = new ArrayList<PortletURLGenerationListener>();
        List portletURLFilterList = app.getListeners();
        if (portletURLFilterList != null) {
            for (Listener listener : portletURLFilterList) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(listener.getListenerClass());
                    if (clazz == null) continue;
                    listeners.add((PortletURLGenerationListener)clazz.newInstance());
                }
                catch (ClassNotFoundException e) {
                    this.logger.error("class not found for " + listener.getListenerClass(), (Throwable)e);
                }
                catch (InstantiationException e) {
                    this.logger.error("instantiation failed for " + listener.getListenerClass(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    this.logger.error("IllegalAccessException for " + listener.getListenerClass(), (Throwable)e);
                }
            }
        }
        return listeners;
    }
}

