/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.UserAttribute;
import org.jasig.portal.portlet.container.services.RequestAttributeService;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RequestAttributeServiceImpl
implements RequestAttributeService {
    private IPersonAttributeDao personAttributeDao;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletDefinitionRegistry portletDefinitionRegistry;

    @Autowired
    public void setPersonAttributeDao(IPersonAttributeDao personAttributeDao) {
        this.personAttributeDao = personAttributeDao;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public Object getAttribute(HttpServletRequest httpServletRequest, PortletWindow plutoPortletWindow, String attributeName) {
        if ("org.jasig.portlet.USER_INFO_MULTIVALUED".equals(attributeName)) {
            String remoteUser = httpServletRequest.getRemoteUser();
            if (remoteUser == null) {
                return null;
            }
            IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(httpServletRequest, plutoPortletWindow);
            List expectedUserAttributes = this.getExpectedUserAttributes(httpServletRequest, portletWindow);
            return this.getMultiValuedUserInfoMap(remoteUser, expectedUserAttributes);
        }
        return null;
    }

    protected Map<String, List<Object>> getMultiValuedUserInfoMap(String remoteUser, List<? extends UserAttribute> expectedUserAttributes) {
        IPersonAttributes personAttributes = this.personAttributeDao.getPerson(remoteUser);
        if (personAttributes == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List> resultUserInfoMap = new HashMap<String, List>(expectedUserAttributes.size());
        Map attributes = personAttributes.getAttributes();
        for (UserAttribute userAttribute : expectedUserAttributes) {
            String userAttributeName = userAttribute.getName();
            if (!attributes.containsKey(userAttributeName)) continue;
            List list_valueObjs = (List)attributes.get(userAttributeName);
            resultUserInfoMap.put(userAttributeName, list_valueObjs);
        }
        return Collections.unmodifiableMap(resultUserInfoMap);
    }

    protected List<? extends UserAttribute> getExpectedUserAttributes(HttpServletRequest request, IPortletWindow portletWindow) {
        IPortletEntity portletEntity = portletWindow.getPortletEntity();
        IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
        PortletApplicationDefinition portletApplicationDescriptor = this.portletDefinitionRegistry.getParentPortletApplicationDescriptor(portletDefinition.getPortletDefinitionId());
        return portletApplicationDescriptor.getUserAttributes();
    }
}

