/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import java.util.concurrent.TimeUnit;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import javax.servlet.http.Cookie;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;
import org.jasig.portal.portlet.dao.jpa.PortalCookieImpl;
import org.jasig.portal.portlet.om.IPortalCookie;
import org.jasig.portal.portlet.om.IPortletCookie;
import org.joda.time.DateTime;

@Entity
@javax.persistence.Table(name="UP_PORTLET_COOKIES", uniqueConstraints={@UniqueConstraint(columnNames={"PORTAL_COOKIE_ID", "COOKIE_NAME"})})
@SequenceGenerator(name="UP_PORTLET_COOKIES_GEN", sequenceName="UP_PORTLET_COOKIES_SEQ", allocationSize=5)
@TableGenerator(name="UP_PORTLET_COOKIES_GEN", pkColumnValue="UP_PORTLET_COOKIES", allocationSize=5)
@Table(appliesTo="UP_PORTLET_COOKIES", indexes={@Index(name="IDX_UP_PRTLT_CKS_EXP", columnNames={"EXPIRES"})})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@NamedQueries(value={@NamedQuery(name="UP_PORTLET_COOKIES__DELETE_EXPIRED", query="delete from PortletCookieImpl c where c.expires <= :expirationDate")})
class PortletCookieImpl
implements IPortletCookie {
    public static final String UP_PORTLET_COOKIES__DELETE_EXPIRED = "UP_PORTLET_COOKIES__DELETE_EXPIRED";
    @Id
    @GeneratedValue(generator="UP_PORTLET_COOKIES_GEN")
    @Column(name="PORTLET_COOKIE_ID")
    private final long internalPortletCookieId;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @ManyToOne(targetEntity=PortalCookieImpl.class)
    private final IPortalCookie portalCookie;
    @Column(name="COOKIE_NAME", length=500, nullable=false, updatable=false)
    private final String name;
    @Column(name="COOKIE_COMMENT", length=1000, nullable=true, updatable=true)
    private String comment;
    @Column(name="COOKIE_DOMAIN", length=500, nullable=true, updatable=true)
    private String domain;
    @Column(name="EXPIRES", nullable=false, updatable=true)
    @Type(type="dateTime")
    private DateTime expires;
    @Column(name="COOKIE_PATH", length=1000, nullable=true, updatable=true)
    private String path;
    @Column(name="COOKIE_VALUE", length=1000, nullable=false, updatable=true)
    private String value = "";
    @Column(name="VERSION", nullable=false, updatable=true)
    private int version = 0;
    @Column(name="SECURE", nullable=false, updatable=true)
    private boolean secure = false;

    private PortletCookieImpl() {
        this.internalPortletCookieId = -1L;
        this.entityVersion = -1L;
        this.name = null;
        this.portalCookie = null;
    }

    PortletCookieImpl(IPortalCookie portalCookie, Cookie cookie) {
        this.internalPortletCookieId = -1L;
        this.entityVersion = -1L;
        this.name = cookie.getName();
        this.portalCookie = portalCookie;
        this.updateFromCookie(cookie);
    }

    public void updateFromCookie(Cookie cookie) {
        this.setComment(cookie.getComment());
        this.setDomain(cookie.getDomain());
        this.setExpires(DateTime.now().plusSeconds(cookie.getMaxAge()));
        this.setPath(cookie.getPath());
        this.setSecure(cookie.getSecure());
        this.setValue(cookie.getValue());
    }

    public String getComment() {
        return this.comment;
    }

    public String getDomain() {
        return this.domain;
    }

    public DateTime getExpires() {
        return this.expires;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setExpires(DateTime expires) {
        this.expires = expires;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public Cookie toCookie() {
        Cookie cookie = new Cookie(this.name, this.value);
        cookie.setComment(this.comment);
        if (this.domain != null) {
            cookie.setDomain(this.domain);
        }
        int maxAge = this.expires == null ? -1 : (int)TimeUnit.MILLISECONDS.toSeconds(this.expires.getMillis() - System.currentTimeMillis());
        cookie.setMaxAge(maxAge);
        cookie.setPath(this.path);
        cookie.setSecure(this.secure);
        cookie.setVersion(this.version);
        return cookie;
    }

    public String toString() {
        return "PortletCookieImpl [internalPortletCookieId=" + this.internalPortletCookieId + ", entityVersion=" + this.entityVersion + ", name=" + this.name + ", comment=" + this.comment + ", domain=" + this.domain + ", expires=" + this.expires + ", path=" + this.path + ", value=" + this.value + ", version=" + this.version + ", secure=" + this.secure + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortletCookieImpl other = (PortletCookieImpl)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

