/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.pluto.container.PortletPreference;
import org.apache.pluto.container.om.portlet.Preference;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.Table;
import org.jasig.portal.portlet.om.IPortletPreference;

@Entity
@javax.persistence.Table(name="UP_PORTLET_PREF")
@Table(appliesTo="UP_PORTLET_PREF", indexes={@Index(name="IDX_UPP_PREFS_ID", columnNames={"PORTLET_PREFS_ID"})})
@SequenceGenerator(name="UP_PORTLET_PREF_GEN", sequenceName="UP_PORTLET_PREF_SEQ", allocationSize=10)
@TableGenerator(name="UP_PORTLET_PREF_GEN", pkColumnValue="UP_PORTLET_PREF", allocationSize=10)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PortletPreferenceImpl
implements IPortletPreference,
Cloneable {
    private static final String NULL_MARKER = "NULL";
    @Id
    @GeneratedValue(generator="UP_PORTLET_PREF_GEN")
    @Column(name="PORTLET_PREF_ID")
    private final long portletPreferenceId;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @Column(name="PREF_NAME", length=100000)
    @Lob
    private String name = null;
    @Column(name="READ_ONLY", nullable=false)
    private boolean readOnly = false;
    @ElementCollection(fetch=FetchType.EAGER, targetClass=String.class)
    @JoinTable(name="UP_PORTLET_PREF_VALUES", joinColumns={@JoinColumn(name="PORTLET_PREF_ID")})
    @IndexColumn(name="VALUE_ORDER")
    @Lob
    @Column(name="PREF_VALUE", length=100000)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private List<String> values = new ArrayList(0);
    @Column(name="NULL_VALUES", nullable=false)
    private boolean nullValues = true;
    @Transient
    private transient String[] valuesArray;

    public PortletPreferenceImpl() {
        this.portletPreferenceId = -1L;
        this.entityVersion = -1L;
    }

    public PortletPreferenceImpl(PortletPreferenceImpl portletPreference) {
        if (portletPreference.getName() == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.portletPreferenceId = -1L;
        this.entityVersion = -1L;
        this.name = portletPreference.getName();
        this.readOnly = portletPreference.isReadOnly();
        this.setValues(portletPreference.getValues());
    }

    public PortletPreferenceImpl(PortletPreference portletPreference) {
        if (portletPreference.getName() == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.portletPreferenceId = -1L;
        this.entityVersion = -1L;
        this.name = portletPreference.getName();
        this.readOnly = portletPreference.isReadOnly();
        String[] values = portletPreference.getValues();
        this.setValues(values);
    }

    public PortletPreferenceImpl(Preference preference) {
        if (preference.getName() == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.portletPreferenceId = -1L;
        this.entityVersion = -1L;
        this.name = preference.getName();
        this.readOnly = preference.isReadOnly();
        this.setValues(preference.getValues().toArray(new String[0]));
    }

    public PortletPreferenceImpl(String name, boolean readOnly, String ... values) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.portletPreferenceId = -1L;
        this.entityVersion = -1L;
        this.name = name;
        this.readOnly = readOnly;
        this.setValues(values);
    }

    public String getName() {
        return this.name;
    }

    public String[] getValues() {
        if (this.nullValues || this.values == null) {
            return null;
        }
        if (this.valuesArray != null) {
            return (String[])this.valuesArray.clone();
        }
        String[] valuesArray = new String[this.values.size()];
        int index = 0;
        for (String value : this.values) {
            if (NULL_MARKER.equals(value)) {
                valuesArray[index++] = null;
                continue;
            }
            valuesArray[index++] = value.substring(1);
        }
        this.valuesArray = (String[])valuesArray.clone();
        return valuesArray;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setValues(String[] values) {
        if (values == null) {
            this.valuesArray = null;
            this.values = null;
            this.nullValues = true;
        } else if (this.values == null) {
            this.values = new ArrayList<String>(Arrays.asList(values));
            this.nullValues = false;
            this.valuesArray = (String[])values.clone();
        } else {
            this.nullValues = false;
            this.values.clear();
            for (String value : values) {
                if (value == null) {
                    this.values.add(NULL_MARKER);
                    continue;
                }
                this.values.add('_' + value);
            }
            this.valuesArray = (String[])values.clone();
        }
    }

    public PortletPreference clone() {
        return new PortletPreferenceImpl(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IPortletPreference)) {
            return false;
        }
        PortletPreferenceImpl rhs = (PortletPreferenceImpl)object;
        return new EqualsBuilder().append((Object)this.name, (Object)rhs.getName()).append(this.readOnly, rhs.isReadOnly()).append((Object[])this.getValues(), (Object[])rhs.getValues()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(-1904185833, -1222355625).append((Object)this.name).append(this.readOnly).append((Object)this.values).toHashCode();
    }

    public String toString() {
        return "PortletPreferenceImpl [portletPreferenceId=" + this.portletPreferenceId + ", entityVersion=" + this.entityVersion + ", name=" + this.name + ", readOnly=" + this.readOnly + "]";
    }
}

