/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.delegation;

import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.api.portlet.PortletDelegationDispatcher;
import org.jasig.portal.api.portlet.PortletDelegationLocator;
import org.jasig.portal.portlet.delegation.IPortletDelegationManager;
import org.jasig.portal.portlet.delegation.PortletDelegationDispatcherImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.rendering.IPortletRenderer;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.url.IPortalUrlProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PortletDelegationLocatorImpl
implements PortletDelegationLocator {
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortalRequestUtils portalRequestUtils;
    private IPersonManager personManager;
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletRenderer portletRenderer;
    private IPortalUrlProvider portalUrlProvider;
    private IPortletDelegationManager portletDelegationManager;

    @Autowired
    public void setPortletDelegationManager(IPortletDelegationManager portletDelegationManager) {
        this.portletDelegationManager = portletDelegationManager;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortletRenderer(IPortletRenderer portletRenderer) {
        this.portletRenderer = portletRenderer;
    }

    @Autowired
    public void setPortalUrlProvider(IPortalUrlProvider portalUrlProvider) {
        this.portalUrlProvider = portalUrlProvider;
    }

    public PortletDelegationDispatcher createRequestDispatcher(PortletRequest portletRequest, String fName) {
        IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getPortletDefinitionByFname(fName);
        IPortletDefinitionId portletDefinitionId = portletDefinition.getPortletDefinitionId();
        return this.createRequestDispatcher(portletRequest, portletDefinitionId);
    }

    public PortletDelegationDispatcher createRequestDispatcher(PortletRequest portletRequest, IPortletDefinitionId delegatePortletDefinitionId) {
        HttpServletRequest request = this.portalRequestUtils.getPortletHttpRequest(portletRequest);
        String windowID = portletRequest.getWindowID();
        IPortletWindowId parentPortletWindowId = this.portletWindowRegistry.getPortletWindowId(request, windowID);
        IPortletEntity delegatePortletEntity = this.portletEntityRegistry.getOrCreateDelegatePortletEntity(request, parentPortletWindowId, delegatePortletDefinitionId);
        IPortletEntityId delegatePortletEntityId = delegatePortletEntity.getPortletEntityId();
        IPortletWindow delegatePortletWindow = this.portletWindowRegistry.createDelegatePortletWindow(request, delegatePortletEntityId, parentPortletWindowId);
        IPerson person = this.personManager.getPerson(request);
        int userId = person.getID();
        return new PortletDelegationDispatcherImpl(delegatePortletWindow, userId, this.portalRequestUtils, this.personManager, this.portletRenderer, this.portalUrlProvider, this.portletDelegationManager);
    }

    public PortletDelegationDispatcher getRequestDispatcher(PortletRequest portletRequest, IPortletWindowId portletWindowId) {
        HttpServletRequest request = this.portalRequestUtils.getPortletHttpRequest(portletRequest);
        IPerson person = this.personManager.getPerson(request);
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        IPortletWindowId delegationParentId = portletWindow.getDelegationParentId();
        if (delegationParentId == null) {
            throw new IllegalArgumentException("Portlet window '" + portletWindow + "' is not a delegate window and cannot be delgated to.");
        }
        return new PortletDelegationDispatcherImpl(portletWindow, person.getID(), this.portalRequestUtils, this.personManager, this.portletRenderer, this.portalUrlProvider, this.portletDelegationManager);
    }
}

