/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.delegation;

import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.MimeResponse;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.time.FastDateFormat;
import org.jasig.portal.portlet.delegation.MimeResponsePortletOutputHandler;
import org.jasig.portal.portlet.rendering.PortletResourceOutputHandler;

public class ResourceResponsePortletOutputHandler
extends MimeResponsePortletOutputHandler
implements PortletResourceOutputHandler {
    private static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    private static final FastDateFormat HTTP_HEADER_DATE_FORMAT = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy HH:mm:ss Z", (TimeZone)GMT_ZONE, (Locale)Locale.US);
    private final ResourceResponse resourceResponse;

    public ResourceResponsePortletOutputHandler(ResourceResponse resourceResponse) {
        super((MimeResponse)resourceResponse);
        this.resourceResponse = resourceResponse;
    }

    public void setCharacterEncoding(String charset) {
        this.resourceResponse.setCharacterEncoding(charset);
    }

    public void setContentLength(int len) {
        this.resourceResponse.setContentLength(len);
    }

    public void setLocale(Locale locale) {
        this.resourceResponse.setLocale(locale);
    }

    public void setStatus(int status) {
        this.resourceResponse.setProperty("portlet.http-status-code", Integer.toString(status));
    }

    public void setDateHeader(String name, long date) {
        String value = HTTP_HEADER_DATE_FORMAT.format(date);
        this.setHeader(name, value);
    }

    public void addDateHeader(String name, long date) {
        String value = HTTP_HEADER_DATE_FORMAT.format(date);
        this.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.resourceResponse.setProperty(name, value);
    }

    public void addHeader(String name, String value) {
        this.resourceResponse.addProperty(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.resourceResponse.setProperty(name, Integer.toString(value));
    }

    public void addIntHeader(String name, int value) {
        this.resourceResponse.addProperty(name, Integer.toString(value));
    }

    public boolean containsHeader(String name) {
        return false;
    }

    public String getCharacterEncoding() {
        return this.resourceResponse.getCharacterEncoding();
    }

    public Locale getLocale() {
        return this.resourceResponse.getLocale();
    }
}

