/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.delegation.jsp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.portlet.MimeResponse;
import javax.servlet.jsp.JspWriter;
import org.jasig.portal.portlet.rendering.PortletOutputHandler;

public class JspWriterPortletOutputHandler
implements PortletOutputHandler {
    private final JspWriter jspWriter;
    private final PrintWriter printWriter;
    private final MimeResponse mimeResponse;

    public JspWriterPortletOutputHandler(JspWriter jspWriter, MimeResponse mimeResponse) {
        this.jspWriter = jspWriter;
        this.printWriter = new PrintWriter((Writer)this.jspWriter);
        this.mimeResponse = mimeResponse;
    }

    public PrintWriter getPrintWriter() throws IOException {
        return this.printWriter;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IllegalStateException("getWriter has already been called");
    }

    public void flushBuffer() throws IOException {
        this.printWriter.flush();
    }

    public int getBufferSize() {
        return this.jspWriter.getBufferSize();
    }

    public boolean isCommitted() {
        return true;
    }

    public void reset() {
        throw new IllegalStateException("Response has already been committed");
    }

    public void resetBuffer() {
        try {
            this.jspWriter.clear();
        }
        catch (IOException e) {
            throw new IllegalStateException("Response has already been committed", e);
        }
    }

    public void setBufferSize(int size) {
        this.mimeResponse.setBufferSize(size);
    }

    public void setContentType(String contentType) {
        this.mimeResponse.setContentType(contentType);
    }

    public String getContentType() {
        return this.mimeResponse.getContentType();
    }
}

