/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.registry;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jasig.portal.portlet.om.IPortletEntityDescriptor;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.registry.SubscribeKey;
import org.jasig.portal.utils.threading.NoopLock;

class PortletEntityCache<T extends IPortletEntityDescriptor>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Lock writeLock;
    private final Lock readLock;
    private final Map<SubscribeKey, T> entitiesBySubscribeKey = new HashMap();
    private final Map<IPortletEntityId, T> entitiesById = new HashMap();

    public PortletEntityCache() {
        this(true);
    }

    public PortletEntityCache(boolean threadSafe) {
        if (threadSafe) {
            ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock(true);
            this.writeLock = cacheLock.writeLock();
            this.readLock = cacheLock.readLock();
        } else {
            this.writeLock = NoopLock.INSTANCE;
            this.readLock = NoopLock.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T storeIfAbsentEntity(IPortletEntityId portletEntityId, Function<IPortletEntityId, T> entityCreator) {
        IPortletEntityDescriptor existingEntity = this.getEntity(portletEntityId);
        if (existingEntity != null) {
            return (T)existingEntity;
        }
        this.writeLock.lock();
        try {
            existingEntity = (IPortletEntityDescriptor)this.entitiesById.get(portletEntityId);
            if (existingEntity != null) {
                IPortletEntityDescriptor iPortletEntityDescriptor = existingEntity;
                return (T)iPortletEntityDescriptor;
            }
            IPortletEntityDescriptor entity = (IPortletEntityDescriptor)entityCreator.apply((Object)portletEntityId);
            this.storeEntity(entity);
            IPortletEntityDescriptor iPortletEntityDescriptor = entity;
            return (T)iPortletEntityDescriptor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T storeIfAbsentEntity(T entity) {
        IPortletEntityId portletEntityId = entity.getPortletEntityId();
        IPortletEntityDescriptor existingEntity = this.getEntity(portletEntityId);
        if (existingEntity != null) {
            return (T)existingEntity;
        }
        this.writeLock.lock();
        try {
            existingEntity = (IPortletEntityDescriptor)this.entitiesById.get(portletEntityId);
            if (existingEntity != null) {
                IPortletEntityDescriptor iPortletEntityDescriptor = existingEntity;
                return (T)iPortletEntityDescriptor;
            }
            this.storeEntity(entity);
        }
        finally {
            this.writeLock.unlock();
        }
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeEntity(T entity) {
        this.writeLock.lock();
        try {
            SubscribeKey subscribeKey = new SubscribeKey(entity.getUserId(), entity.getLayoutNodeId());
            this.entitiesBySubscribeKey.put(subscribeKey, entity);
            this.entitiesById.put(entity.getPortletEntityId(), entity);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getEntity(String layoutNodeId, int userId) {
        if (this.entitiesBySubscribeKey.isEmpty()) {
            return null;
        }
        this.readLock.lock();
        try {
            SubscribeKey subscribeKey = new SubscribeKey(userId, layoutNodeId);
            IPortletEntityDescriptor iPortletEntityDescriptor = (IPortletEntityDescriptor)this.entitiesBySubscribeKey.get(subscribeKey);
            return (T)iPortletEntityDescriptor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getEntity(IPortletEntityId portletEntityId) {
        if (this.entitiesById.isEmpty()) {
            return null;
        }
        this.readLock.lock();
        try {
            IPortletEntityDescriptor iPortletEntityDescriptor = (IPortletEntityDescriptor)this.entitiesById.get(portletEntityId);
            return (T)iPortletEntityDescriptor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntity(IPortletEntityId portletEntityId) {
        this.writeLock.lock();
        try {
            IPortletEntityDescriptor entity = (IPortletEntityDescriptor)this.entitiesById.remove(portletEntityId);
            if (entity != null) {
                int userId = entity.getUserId();
                String layoutNodeId = entity.getLayoutNodeId();
                SubscribeKey subscribeKey = new SubscribeKey(userId, layoutNodeId);
                this.entitiesBySubscribeKey.remove(subscribeKey);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

